/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.Objects;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.codeassist.ExpectedTypes;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;

class RelevanceUtils {
    RelevanceUtils() {
    }

    public static int computeRelevanceForCaseMatching(char[] token, char[] proposalName, AssistOptions options) {
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)true)) {
            return 14;
        }
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)false)) {
            return 4;
        }
        if (CharOperation.prefixEquals((char[])token, (char[])proposalName, (boolean)false)) {
            if (CharOperation.prefixEquals((char[])token, (char[])proposalName, (boolean)true)) {
                return 10;
            }
        } else {
            if (options.camelCaseMatch && CharOperation.camelCaseMatch((char[])token, (char[])proposalName)) {
                return 5;
            }
            if (options.substringMatch && CharOperation.substringMatch((char[])token, (char[])proposalName)) {
                return -21;
            }
            if (options.subwordMatch && CharOperation.subWordMatch((char[])token, (char[])proposalName)) {
                return -22;
            }
        }
        return 0;
    }

    static int computeRelevanceForQualification(boolean prefixRequired, String prefix, String qualifiedPrefix) {
        boolean insideQualifiedReference;
        boolean bl = insideQualifiedReference = !prefix.equals(qualifiedPrefix);
        if (!prefixRequired && !insideQualifiedReference) {
            return 3;
        }
        if (prefixRequired && insideQualifiedReference) {
            return 2;
        }
        return 0;
    }

    static int computeRelevanceForExpectingType(ITypeBinding proposalType, ExpectedTypes expectedTypes) {
        if (proposalType != null) {
            int relevance = 0;
            if (!expectedTypes.getExpectedTypes().isEmpty() && PrimitiveType.VOID.toString().equals(proposalType.getName())) {
                return -5;
            }
            for (ITypeBinding expectedType : expectedTypes.getExpectedTypes()) {
                if (expectedTypes.allowsSubtypes() && proposalType.getErasure().isSubTypeCompatible(expectedType.getErasure())) {
                    if (Objects.equals(expectedType.getQualifiedName(), proposalType.getQualifiedName())) {
                        return 30;
                    }
                    if (proposalType.getPackage() != null && proposalType.getPackage().isUnnamed()) {
                        return 25;
                    }
                    relevance = 20;
                }
                if (!expectedTypes.allowsSupertypes() || !expectedType.isSubTypeCompatible(proposalType)) continue;
                if (Objects.equals(expectedType.getQualifiedName(), proposalType.getQualifiedName())) {
                    return 30;
                }
                relevance = 20;
            }
            return relevance;
        }
        return 0;
    }
}

