/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;

public class ExpectedTypes {
    private static final Set<StructuralPropertyDescriptor> CONDITION_LOCATIONS = Set.of(IfStatement.EXPRESSION_PROPERTY, WhileStatement.EXPRESSION_PROPERTY, DoStatement.EXPRESSION_PROPERTY, ForStatement.EXPRESSION_PROPERTY, ConditionalExpression.EXPRESSION_PROPERTY);
    private final int offset;
    private Collection<TypeFilter> expectedTypesFilters = Set.of(TypeFilter.SUPERTYPE, TypeFilter.SUBTYPE);
    private final Collection<ITypeBinding> expectedTypes = new LinkedHashSet<ITypeBinding>();
    private final Collection<ITypeBinding> uninterestingBindings = new LinkedHashSet<ITypeBinding>();
    private final Collection<ITypeBinding> forbiddenBindings = new LinkedHashSet<ITypeBinding>();
    private final AssistOptions options;
    private final ASTNode node;
    private boolean isReady;

    public ExpectedTypes(AssistOptions options, ASTNode toComplete, int offset) {
        this.offset = offset;
        this.options = options;
        this.node = toComplete;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeExpectedTypes() {
        block65: {
            ASTNode parent;
            block76: {
                PrefixExpression.Operator operator;
                block77: {
                    block75: {
                        Expression expression;
                        block74: {
                            block73: {
                                block71: {
                                    ASTNode cursor;
                                    MethodInvocation messageSend;
                                    block72: {
                                        ITypeBinding initialBinding;
                                        Name name;
                                        boolean isStatic;
                                        block70: {
                                            block69: {
                                                block68: {
                                                    block67: {
                                                        block66: {
                                                            VariableDeclaration variable;
                                                            ASTNode parent2;
                                                            for (parent2 = this.node; parent2 != null; parent2 = parent2.getParent()) {
                                                                IMethodBinding methodBinding;
                                                                MemberValuePair mvp;
                                                                IMemberValuePairBinding binding;
                                                                ITypeBinding arrayType;
                                                                ASTNode parameterizedType;
                                                                CastExpression cast;
                                                                ClassInstanceCreation newObj;
                                                                Assignment assign;
                                                                MethodInvocation method;
                                                                VariableDeclarationFragment fragment;
                                                                if (parent2 instanceof VariableDeclarationFragment && this.offset > (fragment = (VariableDeclarationFragment)parent2).getName().getStartPosition() + fragment.getName().getLength() && (variable = fragment.resolveBinding()) != null) {
                                                                    this.expectedTypes.add(variable.getType());
                                                                }
                                                                if (parent2 instanceof MethodInvocation && this.offset > (method = (MethodInvocation)parent2).getName().getStartPosition() + method.getName().getLength() || parent2 instanceof InfixExpression || parent2 instanceof ReturnStatement || parent2 instanceof Block || parent2 instanceof LambdaExpression) break;
                                                                if (parent2 instanceof Assignment && this.offset > (assign = (Assignment)parent2).getLeftHandSide().getStartPosition() + assign.getLeftHandSide().getLength()) {
                                                                    this.expectedTypes.add(assign.resolveTypeBinding());
                                                                    return;
                                                                }
                                                                if (parent2 instanceof ClassInstanceCreation && this.offset > (newObj = (ClassInstanceCreation)parent2).getType().getStartPosition() + newObj.getType().getLength()) break;
                                                                if (parent2 instanceof CastExpression && this.offset > (cast = (CastExpression)parent2).getType().getStartPosition() + cast.getType().getLength()) {
                                                                    this.expectedTypes.add(cast.getType().resolveBinding());
                                                                    return;
                                                                }
                                                                if (parent2.getLocationInParent() != null && CONDITION_LOCATIONS.contains(parent2.getLocationInParent())) {
                                                                    this.expectedTypes.add(parent2.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                                                                    return;
                                                                }
                                                                if (parent2.getLocationInParent() == ParameterizedType.TYPE_ARGUMENTS_PROPERTY && (variable = parent2.getParent()) instanceof ParameterizedType) {
                                                                    ParameterizedType parameterized = (ParameterizedType)variable;
                                                                    int index = parameterized.typeArguments().indexOf(parent2);
                                                                    parameterizedType = parameterized.resolveBinding();
                                                                    if (parameterizedType != null && index >= 0) {
                                                                        ITypeBinding[] typeParameters;
                                                                        if (parameterizedType.getTypeDeclaration() != null) {
                                                                            parameterizedType = parameterizedType.getTypeDeclaration();
                                                                        }
                                                                        if ((typeParameters = parameterizedType.getTypeParameters()).length > index) {
                                                                            ITypeBinding expectedType = typeParameters[index];
                                                                            if (expectedType != null) {
                                                                                if (expectedType.isTypeVariable() || expectedType.isWildcardType()) {
                                                                                    if (expectedType.getSuperclass() != null) {
                                                                                        this.expectedTypes.add(expectedType.getSuperclass());
                                                                                    }
                                                                                    this.expectedTypes.addAll(Arrays.asList(expectedType.getInterfaces()));
                                                                                } else {
                                                                                    this.expectedTypes.add(expectedType);
                                                                                }
                                                                            }
                                                                            if (this.expectedTypes.isEmpty()) {
                                                                                this.expectedTypes.add(parent2.getAST().resolveWellKnownType(Object.class.getName()));
                                                                            }
                                                                        }
                                                                    }
                                                                    return;
                                                                }
                                                                if (parent2 instanceof SwitchCase) {
                                                                    SwitchCase switchCase = (SwitchCase)parent2;
                                                                    parameterizedType = switchCase.getParent();
                                                                    if (parameterizedType instanceof SwitchStatement) {
                                                                        SwitchStatement stmt = (SwitchStatement)parameterizedType;
                                                                        this.expectedTypes.add(stmt.getExpression().resolveTypeBinding());
                                                                        return;
                                                                    }
                                                                    parameterizedType = switchCase.getParent();
                                                                    if (parameterizedType instanceof SwitchExpression) {
                                                                        SwitchExpression expr = (SwitchExpression)parameterizedType;
                                                                        this.expectedTypes.add(expr.getExpression().resolveTypeBinding());
                                                                        return;
                                                                    }
                                                                }
                                                                if (parent2 instanceof ArrayInitializer) {
                                                                    ArrayInitializer array = (ArrayInitializer)parent2;
                                                                    arrayType = array.resolveTypeBinding();
                                                                    if (arrayType == null || !arrayType.isArray()) break;
                                                                    this.expectedTypes.add(arrayType.getElementType());
                                                                    break;
                                                                }
                                                                if (parent2.getLocationInParent() != MemberValuePair.VALUE_PROPERTY || !((arrayType = parent2.getParent()) instanceof MemberValuePair) || (binding = (mvp = (MemberValuePair)arrayType).resolveMemberValuePairBinding()) == null || (methodBinding = binding.getMethodBinding()) == null) continue;
                                                                this.expectedTypes.add(methodBinding.getReturnType());
                                                                break;
                                                            }
                                                            if ((parent = parent2) == null) {
                                                                return;
                                                            }
                                                            this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE);
                                                            if (!(parent instanceof VariableDeclaration)) break block66;
                                                            variable = (VariableDeclaration)parent;
                                                            if (parent instanceof TypeParameter || this.offset <= variable.getName().getStartPosition() + variable.getName().getLength()) break block66;
                                                            ITypeBinding binding = variable.resolveBinding().getType();
                                                            if (binding != null) {
                                                                if (!(variable.getInitializer() instanceof ArrayInitializer)) {
                                                                    this.expectedTypes.add(binding);
                                                                    break block65;
                                                                } else {
                                                                    this.expectedTypes.add(binding.getComponentType());
                                                                }
                                                            }
                                                            break block65;
                                                        }
                                                        if (!(parent instanceof Assignment)) break block67;
                                                        Assignment assignment = (Assignment)parent;
                                                        ITypeBinding binding = assignment.resolveTypeBinding();
                                                        if (binding != null) {
                                                            this.expectedTypes.add(binding);
                                                        }
                                                        break block65;
                                                    }
                                                    if (!(parent instanceof ReturnStatement)) break block68;
                                                    ExpectedTypes.findLambda(parent).map(LambdaExpression::resolveMethodBinding).or(() -> ExpectedTypes.findMethod(parent).map(MethodDeclaration::resolveBinding)).map(IMethodBinding::getReturnType).ifPresent(this.expectedTypes::add);
                                                    break block65;
                                                }
                                                if (!(parent instanceof LambdaExpression)) break block69;
                                                LambdaExpression lambda = (LambdaExpression)parent;
                                                if (lambda.getBody() == this.node) {
                                                    Optional.ofNullable(lambda.resolveMethodBinding()).map(IMethodBinding::getReturnType).ifPresent(this.expectedTypes::add);
                                                }
                                                break block65;
                                            }
                                            if (!(parent instanceof CastExpression)) break block70;
                                            CastExpression castExpression = (CastExpression)parent;
                                            ITypeBinding binding = castExpression.resolveTypeBinding();
                                            if (binding != null) {
                                                this.expectedTypes.add(binding);
                                                this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
                                            }
                                            break block65;
                                        }
                                        if (!(parent instanceof MethodInvocation)) break block71;
                                        messageSend = (MethodInvocation)parent;
                                        if (messageSend.getExpression() == null) break block72;
                                        Expression expression2 = messageSend.getExpression();
                                        boolean bl = isStatic = expression2 instanceof Name && (name = (Name)expression2).resolveBinding() instanceof ITypeBinding;
                                        for (ITypeBinding currentBinding = initialBinding = messageSend.getExpression().resolveTypeBinding(); currentBinding != null; currentBinding = currentBinding.getSuperclass()) {
                                            this.computeExpectedTypesForMessageSend(currentBinding, messageSend.getName().toString(), messageSend.arguments(), initialBinding, (ASTNode)messageSend, isStatic);
                                            this.computeExpectedTypesForMessageSendForInterface(currentBinding, messageSend.getName().toString(), messageSend.arguments(), initialBinding, (ASTNode)messageSend, isStatic);
                                        }
                                        break block65;
                                    }
                                    IMethodBinding methodBinding = messageSend.resolveMethodBinding();
                                    if (this.node == parent) break block65;
                                    for (cursor = this.node; cursor != null && cursor.getParent() != messageSend; cursor = cursor.getParent()) {
                                    }
                                    if (cursor == null || methodBinding == null) break block65;
                                    int i = messageSend.arguments().indexOf(cursor);
                                    if (0 <= i && i < methodBinding.getParameterTypes().length) {
                                        this.expectedTypes.add(methodBinding.getParameterTypes()[i]);
                                        break block65;
                                    } else if (0 <= i && methodBinding.isVarargs()) {
                                        this.expectedTypes.add(methodBinding.getParameterTypes()[methodBinding.getParameterTypes().length - 1]);
                                    }
                                    break block65;
                                }
                                if (!(parent instanceof ClassInstanceCreation)) break block73;
                                ClassInstanceCreation allocationExpression = (ClassInstanceCreation)parent;
                                ITypeBinding binding = allocationExpression.resolveTypeBinding();
                                if (binding != null) {
                                    this.computeExpectedTypesForAllocationExpression(binding, allocationExpression.arguments(), (ASTNode)allocationExpression);
                                }
                                break block65;
                            }
                            if (!(parent instanceof InstanceofExpression)) break block74;
                            InstanceofExpression e = (InstanceofExpression)parent;
                            ITypeBinding binding = e.getLeftOperand().resolveTypeBinding();
                            if (binding != null) {
                                this.expectedTypes.add(binding);
                                this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
                            }
                            break block65;
                        }
                        if (!(parent instanceof InfixExpression)) break block75;
                        InfixExpression binaryExpression = (InfixExpression)parent;
                        InfixExpression.Operator operator2 = binaryExpression.getOperator();
                        if (operator2 == InfixExpression.Operator.EQUALS || operator2 == InfixExpression.Operator.NOT_EQUALS) {
                            ITypeBinding binding = binaryExpression.getLeftOperand().resolveTypeBinding();
                            if (binding != null) {
                                this.expectedTypes.add(binding);
                                this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
                            }
                        } else if (operator2 == InfixExpression.Operator.PLUS) {
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(String.class.getName()));
                        } else if (operator2 == InfixExpression.Operator.CONDITIONAL_AND || operator2 == InfixExpression.Operator.CONDITIONAL_OR || operator2 == InfixExpression.Operator.XOR) {
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                        } else {
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
                        }
                        if (operator2 == InfixExpression.Operator.LESS && (expression = binaryExpression.getLeftOperand()) instanceof Name) {
                            Name name = (Name)expression;
                        }
                        break block65;
                    }
                    if (!(parent instanceof PrefixExpression)) break block76;
                    PrefixExpression prefixExpression = (PrefixExpression)parent;
                    operator = prefixExpression.getOperator();
                    if (operator != PrefixExpression.Operator.NOT) break block77;
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                    break block65;
                }
                if (operator == PrefixExpression.Operator.COMPLEMENT) {
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
                    break block65;
                } else if (operator == PrefixExpression.Operator.PLUS || operator == PrefixExpression.Operator.MINUS || operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
                }
                break block65;
            }
            if (parent instanceof ArrayAccess) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
            } else if (parent instanceof DoStatement) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            } else if (parent instanceof MemberValuePair) {
                MemberValuePair pair = (MemberValuePair)parent;
                Optional.ofNullable(pair.resolveMemberValuePairBinding()).map(IMemberValuePairBinding::getMethodBinding).map(IMethodBinding::getReturnType).map(ITypeBinding::getComponentType).ifPresent(this.expectedTypes::add);
            } else if (parent instanceof WhileStatement) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            } else if (parent instanceof IfStatement) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            } else if (parent instanceof AssertStatement) {
                AssertStatement assertStatement = (AssertStatement)parent;
                if (assertStatement.getExpression() == this.node) {
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                }
            } else if (parent instanceof ForStatement) {
                ForStatement forStatement = (ForStatement)parent;
                if (forStatement.getExpression().equals((Object)this.node)) {
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                }
            } else if (parent instanceof Javadoc) {
                ExpectedTypes.findMethod(parent).map(MethodDeclaration::resolveBinding).map(IMethodBinding::getExceptionTypes).map(Arrays::stream).orElseGet(() -> Stream.of(new ITypeBinding[0])).forEach(this.expectedTypes::add);
            } else if (parent instanceof ConditionalExpression) {
                ConditionalExpression conditionalExpr = (ConditionalExpression)parent;
                if (conditionalExpr.getExpression() == this.node) {
                    this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                } else {
                    ITypeBinding typeBinding = conditionalExpr.resolveTypeBinding();
                    if (typeBinding != null && !typeBinding.isRecovered()) {
                        this.expectedTypes.add(typeBinding);
                    }
                }
            }
        }
        this.isReady = true;
    }

    private void computeExpectedTypesForAllocationExpression(ITypeBinding binding, List<Expression> arguments, ASTNode invocationSite) {
        IMethodBinding[] methods;
        if (arguments == null) {
            return;
        }
        block0: for (IMethodBinding method : methods = (IMethodBinding[])this.avaiableMethods(binding).toArray(IMethodBinding[]::new)) {
            ITypeBinding expectedType;
            ITypeBinding[] parameters;
            if (!method.isConstructor() || method.isSynthetic() || (parameters = method.getParameterTypes()).length < arguments.size()) continue;
            int length = arguments.size() - 1;
            for (int j = 0; j < length; ++j) {
                Expression argument = arguments.get(j);
                ITypeBinding argType = argument.resolveTypeBinding();
                if (argType != null && !argType.isSubTypeCompatible(parameters[j])) continue block0;
            }
            if (arguments.size() <= 0 || (expectedType = method.getParameterTypes()[arguments.size() - 1]) == null) continue;
            this.expectedTypes.add(expectedType);
        }
    }

    private void computeExpectedTypesForMessageSend(ITypeBinding binding, String selector, List<Expression> arguments, ITypeBinding receiverType, ASTNode invocationSite, boolean isStatic) {
        IMethodBinding[] methods;
        if (arguments == null) {
            return;
        }
        block0: for (IMethodBinding method : methods = (IMethodBinding[])this.avaiableMethods(binding).toArray(IMethodBinding[]::new)) {
            ITypeBinding expectedType;
            ITypeBinding[] parameters;
            if (method.isSynthetic() || method.isConstructor() || isStatic && !Modifier.isStatic((int)method.getModifiers()) || !Objects.equals(method.getName(), selector) || (parameters = method.getParameterTypes()).length < arguments.size()) continue;
            if (arguments.isEmpty() && parameters.length > 0) {
                this.expectedTypes.add(parameters[0]);
                continue;
            }
            int length = arguments.size() - 1;
            int completionArgIndex = arguments.size() - 1;
            for (int j = 0; j < length; ++j) {
                Expression argument = arguments.get(j);
                ITypeBinding argType = argument.resolveTypeBinding();
                if (argType != null && !argType.getErasure().isSubTypeCompatible(parameters[j].getErasure())) continue block0;
            }
            if (completionArgIndex < 0 || (expectedType = method.getParameterTypes()[completionArgIndex]) == null) continue;
            this.expectedTypes.add(expectedType);
        }
    }

    private void computeExpectedTypesForMessageSendForInterface(ITypeBinding binding, String selector, List<Expression> arguments, ITypeBinding receiverType, ASTNode invocationSite, boolean isStatic) {
        ITypeBinding[] itsInterfaces = binding.getInterfaces();
        int itsLength = itsInterfaces.length;
        ITypeBinding[] interfacesToVisit = itsInterfaces;
        int nextPosition = interfacesToVisit.length;
        for (int i = 0; i < nextPosition; ++i) {
            ITypeBinding currentType = interfacesToVisit[i];
            this.computeExpectedTypesForMessageSend(currentType, selector, arguments, receiverType, invocationSite, isStatic);
            itsInterfaces = currentType.getInterfaces();
            itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ITypeBinding[] iTypeBindingArray = interfacesToVisit;
                interfacesToVisit = new ITypeBinding[nextPosition + itsLength + 5];
                System.arraycopy(iTypeBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            block1: for (int a = 0; a < itsLength; ++a) {
                ITypeBinding next = itsInterfaces[a];
                for (int b = 0; b < nextPosition; ++b) {
                    if (Objects.equals(next, interfacesToVisit[b])) continue block1;
                }
                interfacesToVisit[nextPosition++] = next;
            }
        }
    }

    private static Optional<MethodDeclaration> findMethod(ASTNode node) {
        while (node != null && !(node instanceof MethodDeclaration)) {
            node = node.getParent();
        }
        return Optional.ofNullable((MethodDeclaration)node);
    }

    private static Optional<LambdaExpression> findLambda(ASTNode node) {
        while (node != null && !(node instanceof LambdaExpression)) {
            node = node.getParent();
        }
        return Optional.ofNullable((LambdaExpression)node);
    }

    private Set<IMethodBinding> avaiableMethods(ITypeBinding typeBinding) {
        HashSet<IMethodBinding> res = new HashSet<IMethodBinding>();
        res.addAll(Arrays.asList(typeBinding.getDeclaredMethods()));
        for (ITypeBinding interfac : typeBinding.getInterfaces()) {
            res.addAll(this.avaiableMethods(interfac));
        }
        if (typeBinding.getSuperclass() != null) {
            res.addAll(this.avaiableMethods(typeBinding.getSuperclass()));
        }
        return res;
    }

    public List<ITypeBinding> getExpectedTypes() {
        if (!this.isReady) {
            this.computeExpectedTypes();
        }
        return new ArrayList<ITypeBinding>(this.expectedTypes);
    }

    public boolean allowsSubtypes() {
        return this.expectedTypesFilters.contains((Object)TypeFilter.SUBTYPE);
    }

    public boolean allowsSupertypes() {
        return this.expectedTypesFilters.contains((Object)TypeFilter.SUPERTYPE);
    }

    private static enum TypeFilter {
        SUPERTYPE,
        SUBTYPE;

    }
}

