/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle.handlers;

import com.github.badsyntax.gradle.ErrorMessageBuilder;
import com.github.badsyntax.gradle.GradleExecution;
import com.github.badsyntax.gradle.GradleLocalInstallation;
import com.github.badsyntax.gradle.GradleProjectConnectionType;
import com.github.badsyntax.gradle.GradleProjectConnector;
import com.github.badsyntax.gradle.GradleWrapper;
import com.github.badsyntax.gradle.StopDaemonsReply;
import com.github.badsyntax.gradle.StopDaemonsRequest;
import com.github.badsyntax.gradle.exceptions.GradleExecutionException;
import io.grpc.stub.StreamObserver;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopDaemonsHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)StopDaemonsHandler.class.getName());
    private StopDaemonsRequest req;
    private StreamObserver<StopDaemonsReply> responseObserver;

    public StopDaemonsHandler(StopDaemonsRequest req, StreamObserver<StopDaemonsReply> responseObserver) {
        this.req = req;
        this.responseObserver = responseObserver;
    }

    public void run() {
        File projectRoot = new File(this.req.getProjectDir());
        try {
            GradleExecution gradleExecution = null;
            GradleProjectConnectionType connectionType = GradleProjectConnector.getConnectionType();
            if (connectionType == GradleProjectConnectionType.WRAPPER) {
                if (!GradleWrapper.hasValidWrapper(projectRoot)) {
                    this.replyWithError(new Exception("Unsupported operation."));
                    return;
                }
                gradleExecution = new GradleWrapper(projectRoot);
            } else if (connectionType == GradleProjectConnectionType.LOCALINSTALLATION) {
                String localInstallation = GradleProjectConnector.getLocalInstallation();
                gradleExecution = new GradleLocalInstallation(new File(localInstallation));
            } else if (connectionType == GradleProjectConnectionType.SPECIFICVERSION) {
                this.replyWithError(new Exception("Unsupported operation."));
                return;
            }
            if (gradleExecution == null) {
                this.replyWithError(new Exception("Stop daemons failed. Please check your Gradle Settings."));
                return;
            }
            String stopOutput = gradleExecution.exec("--stop");
            this.replyWithSuccess(stopOutput);
            this.responseObserver.onCompleted();
        }
        catch (GradleExecutionException e) {
            logger.error(e.getMessage());
            this.replyWithError(e);
        }
    }

    private void replyWithError(Exception e) {
        this.responseObserver.onError((Throwable)ErrorMessageBuilder.build(e));
    }

    private void replyWithSuccess(String message) {
        this.responseObserver.onNext((Object)StopDaemonsReply.newBuilder().setMessage(message).build());
    }
}

