/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.codeassist.DOMThrownExceptionFinder;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;

public class ExpectedTypes {
    private static final Set<StructuralPropertyDescriptor> CONDITION_LOCATIONS = Set.of(IfStatement.EXPRESSION_PROPERTY, WhileStatement.EXPRESSION_PROPERTY, DoStatement.EXPRESSION_PROPERTY, ForStatement.EXPRESSION_PROPERTY, ConditionalExpression.EXPRESSION_PROPERTY);
    private final int offset;
    private Collection<TypeFilter> expectedTypesFilters = Set.of(TypeFilter.SUPERTYPE, TypeFilter.SUBTYPE);
    private final Collection<ITypeBinding> expectedTypes = new LinkedHashSet<ITypeBinding>();
    private final Collection<ITypeBinding> uninterestingBindings = new LinkedHashSet<ITypeBinding>();
    private final Collection<ITypeBinding> forbiddenBindings = new LinkedHashSet<ITypeBinding>();
    private final AssistOptions options;
    private final ASTNode node;
    private boolean isReady;

    public ExpectedTypes(AssistOptions options, ASTNode toComplete, int offset) {
        this.offset = offset;
        this.options = options;
        this.node = toComplete;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeExpectedTypes() {
        ASTNode parent;
        VariableDeclaration variable;
        ASTNode parent2;
        for (parent2 = this.node; parent2 != null; parent2 = parent2.getParent()) {
            IMethodBinding methodBinding;
            MemberValuePair mvp;
            ASTNode typeBinding;
            ASTNode parameterizedType;
            CastExpression cast;
            ASTNode binding;
            ClassInstanceCreation newObj;
            Assignment assign;
            MethodInvocation method;
            VariableDeclarationFragment fragment;
            if (parent2 instanceof VariableDeclarationFragment && this.offset > (fragment = (VariableDeclarationFragment)parent2).getName().getStartPosition() + fragment.getName().getLength() && (variable = fragment.resolveBinding()) != null) {
                this.expectedTypes.add(variable.getType());
            }
            if (parent2 instanceof MethodInvocation && this.offset > (method = (MethodInvocation)parent2).getName().getStartPosition() + method.getName().getLength()) {
                ITypeBinding receiverType;
                if (method.arguments().size() != 1 || ((ASTNode)method.arguments().get(0)).getLength() != 0) break;
                if (method.getExpression() != null && (receiverType = method.getExpression().resolveTypeBinding()) != null) {
                    Arrays.stream(receiverType.getDeclaredMethods()).filter(decl -> Objects.equals(decl.getName(), method.getName())).filter(decl -> decl.getParameterTypes().length > 0).map(decl -> decl.getParameterTypes()[0]).forEach(this.expectedTypes::add);
                    break;
                }
            }
            if (parent2 instanceof InfixExpression || parent2 instanceof ReturnStatement || parent2 instanceof Block || parent2 instanceof LambdaExpression || parent2 instanceof TryStatement) break;
            if (parent2 instanceof Assignment && this.offset > (assign = (Assignment)parent2).getLeftHandSide().getStartPosition() + assign.getLeftHandSide().getLength()) {
                this.expectedTypes.add(assign.resolveTypeBinding());
                return;
            }
            if (parent2 instanceof ClassInstanceCreation && this.offset > (newObj = (ClassInstanceCreation)parent2).getType().getStartPosition() + newObj.getType().getLength()) {
                binding = newObj.resolveTypeBinding();
                if (binding == null) break;
                this.computeExpectedTypesForAllocationExpression((ITypeBinding)binding, newObj.arguments(), (ASTNode)newObj);
                break;
            }
            if (parent2 instanceof CastExpression && this.offset > (cast = (CastExpression)parent2).getType().getStartPosition() + cast.getType().getLength()) {
                this.expectedTypes.add(cast.getType().resolveBinding());
                return;
            }
            if (parent2.getLocationInParent() != null && CONDITION_LOCATIONS.contains(parent2.getLocationInParent())) {
                this.expectedTypes.add(parent2.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                return;
            }
            if (parent2.getLocationInParent() == ParameterizedType.TYPE_ARGUMENTS_PROPERTY && (binding = parent2.getParent()) instanceof ParameterizedType) {
                ITypeBinding[] typeParameters;
                ParameterizedType parameterized = (ParameterizedType)binding;
                int index = parameterized.typeArguments().indexOf(parent2);
                parameterizedType = parameterized.resolveBinding();
                if (parameterizedType == null) return;
                if (index < 0) return;
                if (parameterizedType.getTypeDeclaration() != null) {
                    parameterizedType = parameterizedType.getTypeDeclaration();
                }
                if ((typeParameters = parameterizedType.getTypeParameters()).length <= index) return;
                ITypeBinding expectedType = typeParameters[index];
                if (expectedType != null) {
                    if (expectedType.isTypeVariable() || expectedType.isWildcardType()) {
                        if (expectedType.getSuperclass() != null) {
                            this.expectedTypes.add(expectedType.getSuperclass());
                        }
                        this.expectedTypes.addAll(Arrays.asList(expectedType.getInterfaces()));
                    } else {
                        this.expectedTypes.add(expectedType);
                    }
                }
                if (!this.expectedTypes.isEmpty()) return;
                this.expectedTypes.add(parent2.getAST().resolveWellKnownType(Object.class.getName()));
                return;
            }
            if (parent2 instanceof SwitchCase) {
                SwitchCase switchCase = (SwitchCase)parent2;
                parameterizedType = switchCase.getParent();
                if (parameterizedType instanceof SwitchStatement) {
                    SwitchStatement stmt = (SwitchStatement)parameterizedType;
                    this.expectedTypes.add(stmt.getExpression().resolveTypeBinding());
                    return;
                }
                parameterizedType = switchCase.getParent();
                if (parameterizedType instanceof SwitchExpression) {
                    SwitchExpression expr = (SwitchExpression)parameterizedType;
                    this.expectedTypes.add(expr.getExpression().resolveTypeBinding());
                    return;
                }
            }
            if (parent2 instanceof ArrayInitializer) {
                ArrayInitializer array = (ArrayInitializer)parent2;
                ITypeBinding arrayType = array.resolveTypeBinding();
                if (arrayType == null || !arrayType.isArray()) break;
                this.expectedTypes.add(arrayType.getElementType());
                break;
            }
            if (parent2 instanceof ParameterizedType) {
                ParameterizedType parameterizedType2 = (ParameterizedType)parent2;
                typeBinding = parameterizedType2.getType().resolveBinding().getTypeDeclaration();
                if (typeBinding.getTypeParameters()[0].isWildcardType() && typeBinding.getTypeParameters()[0].getBound() != null) {
                    this.expectedTypes.add(typeBinding.getTypeParameters()[0].getBound());
                    return;
                }
                this.expectedTypes.add(parent2.getAST().resolveWellKnownType(Object.class.getName()));
                return;
            }
            if (parent2.getLocationInParent() == MemberValuePair.VALUE_PROPERTY && (typeBinding = parent2.getParent()) instanceof MemberValuePair && (binding = (mvp = (MemberValuePair)typeBinding).resolveMemberValuePairBinding()) != null && (methodBinding = binding.getMethodBinding()) != null) {
                this.expectedTypes.add(methodBinding.getReturnType());
                break;
            }
            if (parent2.getLocationInParent() != LambdaExpression.BODY_PROPERTY || !((binding = parent2.getParent()) instanceof LambdaExpression)) continue;
            LambdaExpression lambda = (LambdaExpression)binding;
            if (parent2 instanceof Block || (binding = lambda.resolveMethodBinding()) == null) continue;
            this.expectedTypes.add(binding.getReturnType());
            break;
        }
        if ((parent = parent2) == null) {
            return;
        }
        this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE);
        if (parent instanceof VariableDeclaration) {
            variable = (VariableDeclaration)parent;
            if (!(parent instanceof TypeParameter) && this.offset > variable.getName().getStartPosition() + variable.getName().getLength()) {
                ITypeBinding binding = variable.resolveBinding().getType();
                if (binding == null) return;
                if (!(variable.getInitializer() instanceof ArrayInitializer)) {
                    this.expectedTypes.add(binding);
                    return;
                }
                this.expectedTypes.add(binding.getComponentType());
                return;
            }
        }
        if (parent instanceof Assignment) {
            Assignment assignment = (Assignment)parent;
            ITypeBinding binding = assignment.resolveTypeBinding();
            if (binding == null) return;
            this.expectedTypes.add(binding);
            return;
        }
        if (parent instanceof ReturnStatement) {
            ExpectedTypes.findLambda(parent).map(LambdaExpression::resolveMethodBinding).or(() -> ExpectedTypes.findMethod(parent).map(MethodDeclaration::resolveBinding)).map(IMethodBinding::getReturnType).ifPresent(this.expectedTypes::add);
            return;
        }
        if (parent instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)parent;
            if (lambda.getBody() != this.node) return;
            Optional.ofNullable(lambda.resolveMethodBinding()).map(IMethodBinding::getReturnType).ifPresent(this.expectedTypes::add);
            return;
        }
        if (parent instanceof CastExpression) {
            CastExpression castExpression = (CastExpression)parent;
            ITypeBinding binding = castExpression.resolveTypeBinding();
            if (binding == null) return;
            this.expectedTypes.add(binding);
            this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
            return;
        }
        if (parent instanceof MethodInvocation) {
            ASTNode cursor;
            MethodInvocation messageSend = (MethodInvocation)parent;
            if (messageSend.getExpression() != null) {
                Name name;
                ITypeBinding initialBinding;
                ITypeBinding currentBinding = initialBinding = messageSend.getExpression().resolveTypeBinding();
                Expression expression = messageSend.getExpression();
                boolean isStatic = expression instanceof Name && (name = (Name)expression).resolveBinding() instanceof ITypeBinding;
                while (currentBinding != null) {
                    this.computeExpectedTypesForMessageSend(currentBinding, messageSend.getName().toString(), messageSend.arguments(), initialBinding, (ASTNode)messageSend, isStatic);
                    this.computeExpectedTypesForMessageSendForInterface(currentBinding, messageSend.getName().toString(), messageSend.arguments(), initialBinding, (ASTNode)messageSend, isStatic);
                    currentBinding = currentBinding.getSuperclass();
                }
                return;
            }
            IMethodBinding methodBinding = messageSend.resolveMethodBinding();
            if (this.node == parent) return;
            for (cursor = this.node; cursor != null && cursor.getParent() != messageSend; cursor = cursor.getParent()) {
            }
            if (cursor == null) return;
            if (methodBinding == null) return;
            int i = messageSend.arguments().indexOf(cursor);
            if (0 <= i && i < methodBinding.getParameterTypes().length) {
                this.expectedTypes.add(methodBinding.getParameterTypes()[i]);
                return;
            }
            if (0 > i) return;
            if (!methodBinding.isVarargs()) return;
            this.expectedTypes.add(methodBinding.getParameterTypes()[methodBinding.getParameterTypes().length - 1]);
            return;
        }
        if (parent instanceof ClassInstanceCreation) {
            ClassInstanceCreation allocationExpression = (ClassInstanceCreation)parent;
            ITypeBinding binding = allocationExpression.resolveTypeBinding();
            if (binding == null) return;
            this.computeExpectedTypesForAllocationExpression(binding, allocationExpression.arguments(), (ASTNode)allocationExpression);
            return;
        }
        if (parent instanceof InstanceofExpression) {
            InstanceofExpression e = (InstanceofExpression)parent;
            ITypeBinding binding = e.getLeftOperand().resolveTypeBinding();
            if (binding == null) return;
            this.expectedTypes.add(binding);
            this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
            return;
        }
        if (parent instanceof InfixExpression) {
            ITypeBinding binding;
            InfixExpression binaryExpression = (InfixExpression)parent;
            InfixExpression.Operator operator = binaryExpression.getOperator();
            if (operator == InfixExpression.Operator.EQUALS || operator == InfixExpression.Operator.NOT_EQUALS) {
                binding = binaryExpression.getLeftOperand().resolveTypeBinding();
                if (binding != null) {
                    this.expectedTypes.add(binding);
                    this.expectedTypesFilters = Set.of(TypeFilter.SUBTYPE, TypeFilter.SUPERTYPE);
                }
            } else if (operator == InfixExpression.Operator.PLUS) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(String.class.getName()));
            } else if (operator == InfixExpression.Operator.CONDITIONAL_AND || operator == InfixExpression.Operator.CONDITIONAL_OR || operator == InfixExpression.Operator.XOR) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            } else {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
            }
            if (operator != InfixExpression.Operator.LESS) return;
            Expression i = binaryExpression.getLeftOperand();
            if (!(i instanceof Name)) return;
            binding = (Name)i;
            return;
        }
        if (parent instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)parent;
            PrefixExpression.Operator operator = prefixExpression.getOperator();
            if (operator == PrefixExpression.Operator.NOT) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
                return;
            }
            if (operator == PrefixExpression.Operator.COMPLEMENT) {
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
                this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
                return;
            }
            if (operator != PrefixExpression.Operator.PLUS && operator != PrefixExpression.Operator.MINUS && operator != PrefixExpression.Operator.INCREMENT) {
                if (operator != PrefixExpression.Operator.DECREMENT) return;
            }
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.FLOAT.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.DOUBLE.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.CHAR.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BYTE.toString()));
            return;
        }
        if (parent instanceof ArrayAccess) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.SHORT.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.INT.toString()));
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.LONG.toString()));
            return;
        }
        if (parent instanceof DoStatement) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            return;
        }
        if (parent instanceof MemberValuePair) {
            MemberValuePair pair = (MemberValuePair)parent;
            Optional.ofNullable(pair.resolveMemberValuePairBinding()).map(IMemberValuePairBinding::getMethodBinding).map(IMethodBinding::getReturnType).map(ITypeBinding::getComponentType).ifPresent(this.expectedTypes::add);
            return;
        }
        if (parent instanceof TryStatement) {
            DOMThrownExceptionFinder thrownExceptionFinder = new DOMThrownExceptionFinder();
            thrownExceptionFinder.processThrownExceptions((TryStatement)parent);
            ITypeBinding[] bindings = thrownExceptionFinder.getThrownUncaughtExceptions();
            ITypeBinding[] alreadyCaughtExceptions = thrownExceptionFinder.getAlreadyCaughtExceptions();
            ITypeBinding[] discouragedExceptions = thrownExceptionFinder.getDiscouragedExceptions();
            if (bindings != null && bindings.length > 0) {
                for (ITypeBinding binding : bindings) {
                    this.expectedTypes.add(binding);
                }
                this.expectedTypesFilters = Set.of(TypeFilter.SUPERTYPE);
            }
            if (alreadyCaughtExceptions != null && alreadyCaughtExceptions.length > 0) {
                for (ITypeBinding alreadyCaughtException : alreadyCaughtExceptions) {
                    this.forbiddenBindings.add(alreadyCaughtException);
                }
            }
            if (discouragedExceptions == null) return;
            if (discouragedExceptions.length <= 0) return;
            ITypeBinding[] iTypeBindingArray = discouragedExceptions;
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding discouragedException = iTypeBindingArray[n2];
                this.uninterestingBindings.add(discouragedException);
                ++n2;
            }
            return;
        }
        if (parent instanceof WhileStatement) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            return;
        }
        if (parent instanceof IfStatement) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            return;
        }
        if (parent instanceof AssertStatement) {
            AssertStatement assertStatement = (AssertStatement)parent;
            if (assertStatement.getExpression() != this.node) return;
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            return;
        }
        if (parent instanceof ForStatement) {
            ForStatement forStatement = (ForStatement)parent;
            if (!forStatement.getExpression().equals((Object)this.node)) return;
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            return;
        }
        if (parent instanceof Javadoc) {
            ExpectedTypes.findMethod(parent).map(MethodDeclaration::resolveBinding).map(IMethodBinding::getExceptionTypes).map(Arrays::stream).orElseGet(() -> Stream.of(new ITypeBinding[0])).forEach(this.expectedTypes::add);
            return;
        }
        if (!(parent instanceof ConditionalExpression)) return;
        ConditionalExpression conditionalExpr = (ConditionalExpression)parent;
        if (conditionalExpr.getExpression() == this.node) {
            this.expectedTypes.add(this.node.getAST().resolveWellKnownType(PrimitiveType.BOOLEAN.toString()));
            return;
        }
        ITypeBinding typeBinding = conditionalExpr.resolveTypeBinding();
        if (typeBinding == null) return;
        if (typeBinding.isRecovered()) return;
        this.expectedTypes.add(typeBinding);
    }

    private void computeExpectedTypesForAllocationExpression(ITypeBinding binding, List<Expression> arguments, ASTNode invocationSite) {
        IMethodBinding[] methods;
        if (arguments == null) {
            return;
        }
        block0: for (IMethodBinding method : methods = (IMethodBinding[])this.avaiableMethods(binding).toArray(IMethodBinding[]::new)) {
            ITypeBinding[] parameters;
            if (!method.isConstructor() || method.isSynthetic() || (parameters = method.getParameterTypes()).length < arguments.size()) continue;
            int length = arguments.size() - 1;
            for (int j = 0; j < length; ++j) {
                Expression argument = arguments.get(j);
                ITypeBinding argType = argument.resolveTypeBinding();
                if (argType != null && !argType.isSubTypeCompatible(parameters[j])) continue block0;
            }
            if (arguments.size() > 0) {
                ITypeBinding expectedType = method.getParameterTypes()[arguments.size() - 1];
                if (expectedType == null) continue;
                this.expectedTypes.add(expectedType);
                continue;
            }
            if (!arguments.isEmpty() || parameters.length <= 0 || parameters[0] == null) continue;
            this.expectedTypes.add(parameters[0]);
        }
    }

    private void computeExpectedTypesForMessageSend(ITypeBinding binding, String selector, List<Expression> arguments, ITypeBinding receiverType, ASTNode invocationSite, boolean isStatic) {
        IMethodBinding[] methods;
        if (arguments == null) {
            return;
        }
        block0: for (IMethodBinding method : methods = (IMethodBinding[])this.avaiableMethods(binding).toArray(IMethodBinding[]::new)) {
            ITypeBinding expectedType;
            ITypeBinding[] parameters;
            if (method.isSynthetic() || method.isConstructor() || isStatic && !Modifier.isStatic((int)method.getModifiers()) || !Objects.equals(method.getName(), selector) || (parameters = method.getParameterTypes()).length < arguments.size()) continue;
            if (arguments.isEmpty() && parameters.length > 0) {
                this.expectedTypes.add(parameters[0]);
                continue;
            }
            int length = arguments.size() - 1;
            int completionArgIndex = arguments.size() - 1;
            for (int j = 0; j < length; ++j) {
                Expression argument = arguments.get(j);
                ITypeBinding argType = argument.resolveTypeBinding();
                if (argType != null && !argType.getErasure().isSubTypeCompatible(parameters[j].getErasure())) continue block0;
            }
            if (completionArgIndex < 0 || (expectedType = method.getParameterTypes()[completionArgIndex]) == null) continue;
            this.expectedTypes.add(expectedType);
        }
    }

    private void computeExpectedTypesForMessageSendForInterface(ITypeBinding binding, String selector, List<Expression> arguments, ITypeBinding receiverType, ASTNode invocationSite, boolean isStatic) {
        ITypeBinding[] itsInterfaces = binding.getInterfaces();
        int itsLength = itsInterfaces.length;
        ITypeBinding[] interfacesToVisit = itsInterfaces;
        int nextPosition = interfacesToVisit.length;
        for (int i = 0; i < nextPosition; ++i) {
            ITypeBinding currentType = interfacesToVisit[i];
            this.computeExpectedTypesForMessageSend(currentType, selector, arguments, receiverType, invocationSite, isStatic);
            itsInterfaces = currentType.getInterfaces();
            itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ITypeBinding[] iTypeBindingArray = interfacesToVisit;
                interfacesToVisit = new ITypeBinding[nextPosition + itsLength + 5];
                System.arraycopy(iTypeBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            block1: for (int a = 0; a < itsLength; ++a) {
                ITypeBinding next = itsInterfaces[a];
                for (int b = 0; b < nextPosition; ++b) {
                    if (Objects.equals(next, interfacesToVisit[b])) continue block1;
                }
                interfacesToVisit[nextPosition++] = next;
            }
        }
    }

    private static Optional<MethodDeclaration> findMethod(ASTNode node) {
        while (node != null && !(node instanceof MethodDeclaration)) {
            node = node.getParent();
        }
        return Optional.ofNullable((MethodDeclaration)node);
    }

    private static Optional<LambdaExpression> findLambda(ASTNode node) {
        while (node != null && !(node instanceof LambdaExpression)) {
            node = node.getParent();
        }
        return Optional.ofNullable((LambdaExpression)node);
    }

    private LinkedHashSet<IMethodBinding> avaiableMethods(ITypeBinding typeBinding) {
        LinkedHashSet<IMethodBinding> res = new LinkedHashSet<IMethodBinding>();
        res.addAll(Arrays.asList(typeBinding.getDeclaredMethods()));
        for (ITypeBinding interfac : typeBinding.getInterfaces()) {
            res.addAll(this.avaiableMethods(interfac));
        }
        if (typeBinding.getSuperclass() != null) {
            res.addAll(this.avaiableMethods(typeBinding.getSuperclass()));
        }
        return res;
    }

    public List<ITypeBinding> getExpectedTypes() {
        if (!this.isReady) {
            this.computeExpectedTypes();
            this.expectedTypes.removeIf(ITypeBinding::isNullType);
            this.isReady = true;
        }
        return new ArrayList<ITypeBinding>(this.expectedTypes);
    }

    public Collection<ITypeBinding> getUninterestingTypes() {
        return this.uninterestingBindings;
    }

    public boolean allowsSubtypes() {
        return this.expectedTypesFilters.contains((Object)TypeFilter.SUBTYPE);
    }

    public boolean allowsSupertypes() {
        return this.expectedTypesFilters.contains((Object)TypeFilter.SUPERTYPE);
    }

    private static enum TypeFilter {
        SUPERTYPE,
        SUBTYPE;

    }
}

