/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.IJavaSearchDelegate;
import org.eclipse.jdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.PackageReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.TypeParameterReferenceMatch;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.ModularClassFile;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.DOMPatternLocatorFactory;
import org.eclipse.jdt.internal.core.search.PatternLocatorVisitor;
import org.eclipse.jdt.internal.core.search.matching.ClassFileMatchLocator;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.ModularClassFileMatchLocator;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class DOMJavaSearchDelegate
implements IJavaSearchDelegate {
    private Map<PossibleMatch, NodeSetWrapper> matchToWrapper = new HashMap<PossibleMatch, NodeSetWrapper>();

    public void locateMatches(final MatchLocator locator, IJavaProject javaProject, final PossibleMatch[] possibleMatches, int start, int length) throws CoreException {
        locator.initialize((JavaProject)javaProject, length);
        for (int i = 0; i < possibleMatches.length; ++i) {
            this.matchToWrapper.put(possibleMatches[i], this.wrapNodeSet(possibleMatches[i].nodeSet));
        }
        Map map = javaProject.getOptions(true);
        map.put("org.eclipse.jdt.core.compiler.taskTags", Util.EMPTY_STRING);
        locator.options = new CompilerOptions(map);
        ICompilationUnit[] unitArray = new ICompilationUnit[possibleMatches.length];
        final HashMap<ICompilationUnit, PossibleMatch> cuToMatch = new HashMap<ICompilationUnit, PossibleMatch>();
        for (int i = 0; i < possibleMatches.length; ++i) {
            ICompilationUnit u;
            PossibleMatch currentPossibleMatch;
            locator.currentPossibleMatch = currentPossibleMatch = possibleMatches[i];
            if (this.skipMatch(locator, javaProject, currentPossibleMatch)) continue;
            unitArray[i] = u = this.findUnitForPossibleMatch(locator, javaProject, possibleMatches[i]);
            if (u != null) {
                cuToMatch.put(u, possibleMatches[i]);
                continue;
            }
            Openable openable = currentPossibleMatch.openable;
            if (!(openable instanceof IClassFile)) continue;
            IClassFile classFile = (IClassFile)openable;
            this.locateMatchesForBinary(currentPossibleMatch, locator);
        }
        ICompilationUnit[] nonNullUnits = (ICompilationUnit[])Arrays.asList(unitArray).stream().filter(Objects::nonNull).toArray(ICompilationUnit[]::new);
        if (nonNullUnits.length == 0) {
            return;
        }
        HashSet<WorkingCopyOwner> ownerSet = new HashSet<WorkingCopyOwner>();
        for (int i = 0; i < nonNullUnits.length; ++i) {
            if (nonNullUnits[i].getOwner() == null) continue;
            ownerSet.add(nonNullUnits[i].getOwner());
        }
        WorkingCopyOwner owner = null;
        if (ownerSet.size() == 1) {
            owner = ownerSet.toArray(new WorkingCopyOwner[ownerSet.size()])[0];
        }
        ASTParser astParser = ASTParser.newParser((int)AST.getJLSLatest());
        astParser.setCompilerOptions(javaProject.getOptions(true));
        astParser.setProject(javaProject);
        astParser.setResolveBindings(true);
        astParser.setBindingsRecovery(true);
        if (owner != null) {
            astParser.setWorkingCopyOwner(owner);
        }
        final CompilationUnit[] domUnits = new CompilationUnit[possibleMatches.length];
        final ArrayList nonNullDomIndexes = new ArrayList();
        astParser.createASTs(nonNullUnits, new String[0], new ASTRequestor(this){
            final /* synthetic */ DOMJavaSearchDelegate this$0;
            {
                this.this$0 = this$0;
            }

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                PossibleMatch pm = (PossibleMatch)cuToMatch.get(source);
                if (pm != null) {
                    for (int i = 0; i < possibleMatches.length; ++i) {
                        if (possibleMatches[i] != pm) continue;
                        domUnits[i] = ast;
                        nonNullDomIndexes.add(i);
                        locator.currentPossibleMatch = pm;
                        NodeSetWrapper wrapper = this.this$0.matchToWrapper.get(possibleMatches[i]);
                        ast.accept((ASTVisitor)new PatternLocatorVisitor(locator, wrapper));
                        return;
                    }
                }
            }
        }, locator.progressMonitor);
        Collections.sort(nonNullDomIndexes);
        Iterator iterator = nonNullDomIndexes.iterator();
        while (iterator.hasNext()) {
            PossibleMatch possibleMatch;
            int x = (Integer)iterator.next();
            locator.currentPossibleMatch = possibleMatch = possibleMatches[x];
            NodeSetWrapper wrapper = this.matchToWrapper.get(possibleMatch);
            for (ASTNode node : wrapper.trustedASTNodeLevels.keySet()) {
                int level;
                SearchMatch match = this.toMatch(locator, node, level = wrapper.trustedASTNodeLevels.get(node).intValue(), possibleMatch);
                if (match == null || match.getElement() == null) continue;
                DOMPatternLocator locator2 = DOMPatternLocatorFactory.createWrapper(locator.patternLocator, locator.pattern);
                locator2.reportSearchMatch(locator, node, match);
            }
        }
    }

    private NodeSetWrapper wrapNodeSet(MatchingNodeSet nodeSet) {
        return new NodeSetWrapper(nodeSet.mustResolve);
    }

    private boolean skipMatch(MatchLocator locator, IJavaProject javaProject, PossibleMatch possibleMatch) {
        char[] pModuleName;
        return locator.options.sourceLevel >= 0x350000L && (pModuleName = possibleMatch.getModuleName()) != null && locator.lookupEnvironment.getModule(pModuleName) == null;
    }

    private ICompilationUnit findUnitForPossibleMatch(MatchLocator locator, IJavaProject jp, PossibleMatch match) {
        if (!this.skipMatch(locator, jp, match)) {
            Openable openable = match.openable;
            if (openable instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)openable;
                return cu;
            }
            openable = match.openable;
            if (openable instanceof ITypeRoot) {
                ITypeRoot tr;
                ITypeRoot toOpen = tr = (ITypeRoot)openable;
                try {
                    IClassFile classFile;
                    String n = tr.getElementName();
                    if (n.toLowerCase().endsWith(".class") && n.contains("$")) {
                        IPackageFragment ipf;
                        IClassFile open2;
                        String enclosingSourceFile = n.substring(0, n.indexOf("$")) + ".class";
                        IJavaElement parent = tr.getParent();
                        if (parent instanceof IPackageFragment && (open2 = (ipf = (IPackageFragment)parent).getClassFile(enclosingSourceFile)) instanceof ITypeRoot) {
                            ITypeRoot tr2;
                            toOpen = tr2 = (ITypeRoot)open2;
                        }
                    }
                    if (toOpen instanceof IClassFile && (classFile = (IClassFile)toOpen).getBuffer() == null) {
                        return null;
                    }
                    ICompilationUnit ret = toOpen.getWorkingCopy(null, (IProgressMonitor)new NullProgressMonitor());
                    return ret;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private SearchMatch toMatch(MatchLocator locator, ASTNode node, int accuracy, PossibleMatch possibleMatch) {
        if (node == null) {
            return null;
        }
        SearchMatch sm = this.toCoreMatch(locator, node, accuracy, possibleMatch);
        if (accuracy == 16) {
            sm.setRule(16);
        }
        return sm;
    }

    private SearchMatch toCoreMatch(MatchLocator locator, ASTNode node, int accuracy, PossibleMatch possibleMatch) {
        ClassInstanceCreation newInstance;
        MethodInvocation method;
        IJavaElement javaElement;
        IResource resource = possibleMatch.resource;
        if ((node instanceof MethodDeclaration || node instanceof AbstractTypeDeclaration || node instanceof VariableDeclaration || node instanceof AnnotationTypeMemberDeclaration) && (javaElement = DOMASTNodeUtils.getDeclaringJavaElement(node)) != null) {
            SourceRange range = new SourceRange(node.getStartPosition(), node.getLength());
            if (javaElement instanceof NamedMember) {
                NamedMember named = (NamedMember)javaElement;
                try {
                    range = named.getNameRange();
                }
                catch (JavaModelException ex) {
                    ILog.get().error(ex.getMessage(), (Throwable)ex);
                }
            }
            return locator.newDeclarationMatch(javaElement, null, accuracy, range.getOffset(), range.getLength());
        }
        if (node instanceof MethodInvocation) {
            method = (MethodInvocation)node;
            IJavaElement enclosing = DOMASTNodeUtils.getEnclosingJavaElement(node.getParent());
            IMethodBinding mb = method.resolveMethodBinding();
            boolean isSynthetic = mb != null && mb.isSynthetic();
            return new MethodReferenceMatch(enclosing, accuracy, method.getName().getStartPosition(), method.getStartPosition() + method.getLength() - method.getName().getStartPosition(), false, isSynthetic, (accuracy & 0x200) != 0, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
        }
        if (node instanceof SuperMethodInvocation) {
            method = (SuperMethodInvocation)node;
            return new MethodReferenceMatch(DOMASTNodeUtils.getEnclosingJavaElement(node.getParent()), accuracy, method.getName().getStartPosition(), method.getStartPosition() + method.getLength() - method.getName().getStartPosition(), false, method.resolveMethodBinding().isSynthetic(), (accuracy & 0x200) != 0, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
        }
        if (node instanceof ClassInstanceCreation) {
            newInstance = (ClassInstanceCreation)node;
            return new MethodReferenceMatch(DOMASTNodeUtils.getEnclosingJavaElement(node.getParent().getParent()), accuracy, newInstance.getStartPosition(), newInstance.getLength(), true, newInstance.resolveConstructorBinding().isSynthetic(), (accuracy & 0x200) != 0, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
        }
        if (node instanceof ConstructorInvocation) {
            newInstance = (ConstructorInvocation)node;
            return new MethodReferenceMatch(DOMASTNodeUtils.getEnclosingJavaElement(node), accuracy, newInstance.getStartPosition(), newInstance.getLength(), true, newInstance.resolveConstructorBinding().isSynthetic(), (accuracy & 0x200) != 0, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
        }
        if (node instanceof SuperConstructorInvocation) {
            newInstance = (SuperConstructorInvocation)node;
            return new MethodReferenceMatch(DOMASTNodeUtils.getEnclosingJavaElement(node), accuracy, newInstance.getStartPosition(), newInstance.getLength(), true, newInstance.resolveConstructorBinding().isSynthetic(), (accuracy & 0x200) != 0, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
        }
        if (node instanceof CreationReference) {
            CreationReference constructorRef = (CreationReference)node;
            return new MethodReferenceMatch(DOMASTNodeUtils.getEnclosingJavaElement(node), accuracy, constructorRef.getStartPosition(), constructorRef.getLength(), true, constructorRef.resolveMethodBinding().isSynthetic(), (accuracy & 0x200) != 0, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
        }
        if (node.getLocationInParent() == SingleMemberAnnotation.VALUE_PROPERTY && locator.pattern instanceof MethodPattern) {
            return new MethodReferenceMatch(DOMASTNodeUtils.getEnclosingJavaElement(node), accuracy, node.getStartPosition(), node.getLength(), true, false, (accuracy & 0x200) != 0, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
        }
        if (node instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)node;
            int start = enumConstantDeclaration.getStartPosition();
            int len = enumConstantDeclaration.getLength();
            if (enumConstantDeclaration.getAnonymousClassDeclaration() != null) {
                len = enumConstantDeclaration.getAnonymousClassDeclaration().getStartPosition() - start;
            }
            return new FieldDeclarationMatch(DOMASTNodeUtils.getDeclaringJavaElement(node), accuracy, start, len, this.getParticipant(locator), resource);
        }
        if (node instanceof Type) {
            ASTNode aSTNode;
            Type nt = (Type)node;
            IJavaElement element = DOMASTNodeUtils.getEnclosingJavaElement(node);
            if (element instanceof LocalVariable) {
                element = element.getParent();
            }
            TypeReferenceMatch ret = new TypeReferenceMatch(element, accuracy, node.getStartPosition(), node.getLength(), DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
            if (nt.isParameterizedType() && ((ParameterizedType)nt).typeArguments().size() == 0) {
                ret.setRaw(true);
            }
            if ((aSTNode = nt.getParent()) instanceof TypeParameter) {
                TypeParameter typeParam = (TypeParameter)aSTNode;
                ret.setLocalElement(typeParam.resolveBinding().getJavaElement());
            }
            return ret;
        }
        if (node instanceof TypeParameter) {
            TypeParameter nodeTP = (TypeParameter)node;
            IJavaElement element = DOMASTNodeUtils.getEnclosingJavaElement(node);
            return new TypeParameterReferenceMatch(element, accuracy, nodeTP.getName().getStartPosition(), nodeTP.getName().getLength(), DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
        }
        if (node instanceof Name) {
            Name name = (Name)node;
            IBinding b = name.resolveBinding();
            IJavaElement enclosing = DOMASTNodeUtils.getEnclosingJavaElement(node);
            if (b instanceof ITypeBinding) {
                ITypeBinding btb = (ITypeBinding)b;
                TypeReferenceMatch ref = new TypeReferenceMatch(enclosing, accuracy, node.getStartPosition(), node.getLength(), DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
                if (btb.isRawType()) {
                    ref.setRaw(true);
                }
                return ref;
            }
            if (b instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)b;
                if (variable.isField()) {
                    return new FieldReferenceMatch(enclosing, accuracy, node.getStartPosition(), node.getLength(), true, true, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
                }
                return new LocalVariableReferenceMatch(enclosing, accuracy, node.getStartPosition(), node.getLength(), true, true, DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
            }
            if (b instanceof IPackageBinding) {
                return new PackageReferenceMatch(enclosing, accuracy, name.getStartPosition(), name.getLength(), DOMASTNodeUtils.insideDocComment((ASTNode)name), this.getParticipant(locator), resource);
            }
            if (b instanceof IMethodBinding) {
                return new MethodReferenceMatch(enclosing, accuracy, node.getStartPosition(), node.getLength(), DOMASTNodeUtils.insideDocComment(node), this.getParticipant(locator), resource);
            }
        }
        if (node.getLocationInParent() == SimpleType.NAME_PROPERTY || node.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
            return this.toMatch(locator, node.getParent(), accuracy, possibleMatch);
        }
        return null;
    }

    public SearchParticipant getParticipant(MatchLocator locator) {
        return locator.currentPossibleMatch.document.getParticipant();
    }

    private void locateMatchesForBinary(PossibleMatch possibleMatch, MatchLocator locator) {
        Openable openable = possibleMatch.openable;
        if (openable instanceof ClassFile) {
            ClassFile classFile = (ClassFile)openable;
            info = null;
            try {
                info = this.getBinaryInfo(classFile, classFile.resource());
            }
            catch (CoreException ce) {
                ILog.get().error(ce.getMessage(), (Throwable)ce);
            }
            if (info != null) {
                try {
                    new ClassFileMatchLocator().locateMatches(locator, classFile, (IBinaryType)info);
                }
                catch (CoreException e) {
                    ILog.get().error(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            info = possibleMatch.openable;
            if (info instanceof ModularClassFile) {
                ModularClassFile modularClassFile = (ModularClassFile)info;
                try {
                    new ModularClassFileMatchLocator().locateMatches(locator, modularClassFile);
                }
                catch (CoreException e) {
                    ILog.get().error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IBinaryType getBinaryInfo(ClassFile classFile, IResource resource) throws CoreException {
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (classFile.isOpen()) {
            return binaryType.getElementInfo();
        }
        try {
            ClassFileReader info;
            PackageFragment pkg = (PackageFragment)classFile.getParent();
            PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
            if (root.isArchive()) {
                String classFileName = classFile.getElementName();
                String classFilePath = org.eclipse.jdt.internal.core.util.Util.concatWith((String[])pkg.names, (String)classFileName, (char)'/');
                ZipFile zipFile = null;
                try {
                    zipFile = ((JarPackageFragmentRoot)root).getJar();
                    info = ClassFileReader.read((ZipFile)zipFile, (String)classFilePath);
                }
                finally {
                    JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                }
            } else {
                info = org.eclipse.jdt.internal.core.util.Util.newClassFileReader((IResource)resource);
            }
            if (info == null) {
                throw binaryType.newNotPresentException();
            }
            return info;
        }
        catch (ClassFormatException e) {
            if (JobManager.VERBOSE) {
                JavaModelManager.trace((String)"", (Exception)((Object)e));
            }
            return null;
        }
        catch (IOException e) {
            throw new JavaModelException((Throwable)e, 985);
        }
    }
}

