/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.movefunction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.movefunction.FunctionData;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionRefactoring;

class ChangeCreator {
    private final IFile selectedFile;
    private final MoveFunctionRefactoring.MoveFunctionSettings settings;
    private final List<FunctionData> functions;
    private final IProject project;
    private static Map<Module, List<Module>> moduleImports = new HashMap<Module, List<Module>>();
    private Change change;

    ChangeCreator(IFile selectedFile, MoveFunctionRefactoring.MoveFunctionSettings settings, List<FunctionData> functions, IProject project) {
        this.selectedFile = selectedFile;
        this.settings = settings;
        this.functions = functions;
        this.project = project;
    }

    ChangeCreator(IFile selectedFile, MoveFunctionRefactoring.MoveFunctionSettings settings, List<FunctionData> functions, IProject project, Map<Module, List<Module>> mi) {
        this.selectedFile = selectedFile;
        this.settings = settings;
        this.functions = functions;
        this.project = project;
        moduleImports = mi;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        if (this.functions.isEmpty()) {
            return null;
        }
        if (this.settings.getExcludedModuleNames() != null && this.settings.getExcludedModuleNames().matcher(module.getIdentifier().getTtcnName()).matches()) {
            return null;
        }
        boolean noDestination = true;
        for (FunctionData fd : this.functions) {
            if (!fd.isToBeMoved() || fd.getFinalDestination() == null) continue;
            noDestination = false;
        }
        if (noDestination) {
            return null;
        }
        CompositeChange cc = null;
        if (!(module instanceof TTCN3Module)) {
            return null;
        }
        cc = new CompositeChange("Moving functions from: " + module.getFullName());
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        cc.add((Change)tfc);
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        for (FunctionData function : this.functions) {
            InsertEdit importEdit;
            if (function.getFinalDestination() == null || !function.isToBeMoved()) continue;
            Module finalDestinationModule = function.getFinalDestination().getModule();
            TextFileChange tfcDestination = new TextFileChange(finalDestinationModule.getName(), (IFile)finalDestinationModule.getLocation().getFile());
            MultiTextEdit rootEdit2 = new MultiTextEdit();
            tfcDestination.setEdit((TextEdit)rootEdit2);
            cc.add((Change)tfcDestination);
            Location funcDefLocation = function.getDefiniton().getLocation();
            int length = funcDefLocation.getEndOffset() - funcDefLocation.getOffset();
            DeleteEdit deleteEdit = new DeleteEdit(funcDefLocation.getOffset(), length);
            rootEdit.addChild((TextEdit)deleteEdit);
            if (!moduleImports.containsKey(finalDestinationModule)) {
                moduleImports.put(finalDestinationModule, new ArrayList());
            }
            if ((importEdit = this.insertMissingImports(finalDestinationModule, function.getUsedModules())) != null) {
                rootEdit2.addChild((TextEdit)importEdit);
            }
            this.findFunctionUses(function);
            for (Module m : function.getUsedBy()) {
                TextFileChange tfcModuleUsedMethod = new TextFileChange(m.getName(), (IFile)m.getLocation().getFile());
                MultiTextEdit rootEdit3 = new MultiTextEdit();
                tfcModuleUsedMethod.setEdit((TextEdit)rootEdit3);
                int offset = m.getLocation().getEndOffset();
                Assignments assignments = m.getAssignments();
                int nOfAssignments = assignments.getNofAssignments();
                for (int i = 0; i < nOfAssignments; ++i) {
                    int assignmentOffset = assignments.getAssignmentByIndex(i).getLocation().getOffset();
                    if (offset <= assignmentOffset) continue;
                    offset = assignmentOffset;
                }
                rootEdit3.addChild((TextEdit)new InsertEdit(offset, "\n import from " + finalDestinationModule.getIdentifier().getTtcnName() + " all;\n  "));
                cc.add((Change)tfcModuleUsedMethod);
            }
            Assignments destinationAssignments = finalDestinationModule.getAssignments();
            rootEdit2.addChild((TextEdit)new InsertEdit(destinationAssignments.getAssignmentByIndex(destinationAssignments.getNofAssignments() - 1).getLocation().getEndOffset(), "\n" + function.getFunctionBody() + "\n"));
        }
        return cc;
    }

    private InsertEdit insertMissingImports(Module destinationModule, List<Module> usedModules) {
        List importedModules = destinationModule.getImportedModules();
        String importText = "";
        for (Module m : usedModules) {
            if (importedModules.contains(m) || m.equals(destinationModule) || moduleImports.get(destinationModule).contains(m)) continue;
            importText = importText + "import from " + m.getIdentifier().getTtcnName() + " all;\n  ";
            moduleImports.get(destinationModule).add(m);
        }
        TextFileChange insertImports = new TextFileChange(destinationModule.getName(), (IFile)destinationModule.getLocation().getFile());
        MultiTextEdit rootEdit = new MultiTextEdit();
        insertImports.setEdit((TextEdit)rootEdit);
        int offset = destinationModule.getLocation().getEndOffset();
        Assignments assignments = destinationModule.getAssignments();
        int nOfAssignments = assignments.getNofAssignments();
        for (int i = 0; i < nOfAssignments; ++i) {
            int assignmentOffset = assignments.getAssignmentByIndex(i).getLocation().getOffset();
            if (offset <= assignmentOffset) continue;
            offset = assignmentOffset;
        }
        rootEdit.addChild((TextEdit)new InsertEdit(offset, importText));
        if ("".equals(importText)) {
            return null;
        }
        return new InsertEdit(offset, importText);
    }

    private void findFunctionUses(FunctionData function) {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)this.project);
        for (Module m : projectSourceParser.getModules()) {
            if (m.equals(function.getFinalDestination().getModule())) continue;
            ModuleVisitor vis = new ModuleVisitor(function.getDefiniton());
            m.accept((ASTVisitor)vis);
            if (!vis.getIsUsed() || m.getImportedModules().contains(function.getFinalDestination().getModule()) || m.equals(function.getFinalDestination().getModule())) continue;
            function.addUsedBy(m);
        }
    }

    private static class ModuleVisitor
    extends ASTVisitor {
        private final Def_Function function;
        private boolean isUsed;

        public ModuleVisitor(Def_Function function) {
            this.function = function;
            this.isUsed = false;
        }

        public int visit(IVisitableNode node) {
            Assignment assignment;
            if (node instanceof Reference && (assignment = ((Reference)node).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null)) != null && assignment.equals(this.function)) {
                this.isUsed = true;
            }
            return 3;
        }

        public boolean getIsUsed() {
            return this.isUsed;
        }
    }
}

