/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;

public class ASTLocationChainVisitor
extends ASTVisitor {
    private final List<IVisitableNode> chain = new ArrayList<IVisitableNode>();
    private final int offset;

    public ASTLocationChainVisitor(int offset) {
        this.offset = offset;
    }

    public List<IVisitableNode> getChain() {
        return this.chain;
    }

    @Override
    public int visit(IVisitableNode node) {
        if (node instanceof ILocateableNode) {
            Location loc = ((ILocateableNode)((Object)node)).getLocation();
            if (loc != null && loc.containsOffset(this.offset)) {
                this.chain.add(node);
            } else {
                return 1;
            }
        }
        return 3;
    }

    public void printChain() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node chain for offset ").append(this.offset).append(" : ");
        boolean first = true;
        for (IVisitableNode node : this.chain) {
            if (!first) {
                sb.append(" -> ");
            } else {
                first = false;
            }
            sb.append(node.getClass().getSimpleName());
        }
        TITANDebugConsole.println(sb.toString());
    }
}

