/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.TableConstraint;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Constraint;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Constraints
extends ASTNode {
    private List<Constraint> constraints;

    public Constraints newInstance() {
        Constraints temp = new Constraints();
        if (null != this.constraints) {
            for (Constraint constraint : this.constraints) {
                Constraint newConstraint = constraint.newInstance();
                temp.constraints.add(newConstraint);
                newConstraint.setFullNameParent(this);
            }
        }
        return temp;
    }

    public void addConstraint(Constraint constraint) {
        if (null == constraint) {
            return;
        }
        if (null == this.constraints) {
            this.constraints = new ArrayList<Constraint>(1);
        }
        this.constraints.add(constraint);
        constraint.setFullNameParent(this);
    }

    public int getNofConstraints() {
        if (null == this.constraints) {
            return 0;
        }
        return this.constraints.size();
    }

    public Constraint getConstraintByIndex(int index) {
        if (null == this.constraints) {
            return null;
        }
        return this.constraints.get(index);
    }

    public TableConstraint getTableConstraint() {
        if (null == this.constraints) {
            return null;
        }
        for (Constraint tempConstraint : this.constraints) {
            if (!Constraint.Constraint_type.CT_TABLE.equals((Object)tempConstraint.getConstraintType())) continue;
            return (TableConstraint)tempConstraint;
        }
        return null;
    }

    public void setMyType(Type type) {
        if (null == this.constraints) {
            return;
        }
        for (Constraint tempConstraint : this.constraints) {
            tempConstraint.setMyType(type);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.constraints.size();
        for (int i = 0; i < size; ++i) {
            if (this.constraints.get(i) != child) continue;
            return builder.append("[").append(String.valueOf(i + 1)).append("]");
        }
        return builder;
    }

    public void check(CompilationTimeStamp timestamp) {
        if (null == this.constraints) {
            return;
        }
        for (Constraint tempConstraint : this.constraints) {
            tempConstraint.check(timestamp);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.constraints == null) {
            return;
        }
        for (Constraint c : this.constraints) {
            c.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.constraints != null) {
            for (Constraint c : this.constraints) {
                if (c.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

