/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeReferenceList;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandler;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.ReferenceCollector;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.ReferencesProcessor;

public final class AssignmentHandlerComponent
extends ReferencesProcessor {
    private final Map<Definition, Set<String>> componentDefinitions = new HashMap<Definition, Set<String>>();

    public AssignmentHandlerComponent(Assignment assignment) {
        super(assignment);
    }

    public void collectDataFrom(ComponentTypeBody componentTypeBody) {
        for (Definition tempDefinition : componentTypeBody.getDefinitions()) {
            ReferenceCollector referenceCollector = new ReferenceCollector();
            tempDefinition.accept(referenceCollector);
            Set<String> references = this.computeReferences(referenceCollector.getReferences());
            if (this.containsErroneousReference(referenceCollector.getReferences())) {
                this.setIsInfected(true);
            }
            this.componentDefinitions.put(tempDefinition, references);
        }
        this.processComponentTypeReferenceList(componentTypeBody.getAttributeExtensions());
        this.processComponentTypeReferenceList(componentTypeBody.getExtensions());
    }

    private void processComponentTypeReferenceList(ComponentTypeReferenceList componentTypeReferenceList) {
        if (componentTypeReferenceList != null) {
            ReferenceCollector referenceCollector = new ReferenceCollector();
            componentTypeReferenceList.accept(referenceCollector);
            if (this.containsErroneousReference(referenceCollector.getReferences())) {
                this.setIsInfected(true);
            }
            this.addContagiousReferences(this.computeReferences(referenceCollector.getReferences()));
        }
    }

    @Override
    public Set<String> getNonContagiousReferences() {
        Set<String> result = super.getNonContagiousReferences();
        for (Map.Entry<Definition, Set<String>> entry : this.componentDefinitions.entrySet()) {
            Set<String> references = entry.getValue();
            result.addAll(references);
        }
        return result;
    }

    @Override
    public void check(AssignmentHandler assignmentHandler) {
        this.checkIsInfected(assignmentHandler);
        this.checkIsContagious(assignmentHandler);
    }

    @Override
    public void checkIsInfected(AssignmentHandler other) {
        if (!other.getIsInfected()) {
            return;
        }
        String otherName = other.getAssignment().getIdentifier().getDisplayName();
        if (other.getAssignment().getLastTimeChecked() == null && this.isContagiousReferencesContains(otherName)) {
            this.setIsInfected(true);
            this.addInfectedReference(otherName);
            this.addReason("It uses " + otherName + "@" + other.getAssignment().getMyScope().getModuleScope().getIdentifier().getDisplayName() + " which is infected.");
            return;
        }
        Set<String> infectedFields = this.computeInfectedFields(otherName);
        if (!infectedFields.isEmpty()) {
            this.addContagiousReferences(infectedFields);
            this.addInfectedReferences(infectedFields);
            this.setIsInfected(true);
            this.addReason("It uses " + otherName + "@" + other.getAssignment().getMyScope().getModuleScope().getIdentifier().getDisplayName() + " which is infected.");
        }
    }

    private Set<String> computeInfectedFields(String definitionName) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<Definition, Set<String>> entry : this.componentDefinitions.entrySet()) {
            Set<String> references = entry.getValue();
            for (String referene : references) {
                if (!referene.equals(definitionName)) continue;
                result.add(definitionName);
            }
        }
        return result;
    }

    @Override
    public int visit(IVisitableNode node) {
        if (node instanceof ComponentTypeBody) {
            this.collectDataFrom((ComponentTypeBody)node);
            return 1;
        }
        return 3;
    }
}

