/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.utils.CommentUtils;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.compiler.ProjectSourceCompiler;
import org.eclipse.titan.designer.core.JavaRuntimeHelper;
import org.eclipse.titan.designer.core.ant.JavaAppLaunchConfigGenerator;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class AntScriptGenerator {
    public static final String BUILD_XML_NAME = "jarbuild.xml";
    private static final String BUILD_TARGET = "jar";
    private static final String MCTR_CLI_MAIN = "org.eclipse.titan.runtime.core.mctr.CliMain";
    private static final String REQUIRED_ANT_VERSION_TEXT = "ANT 1.7 is required";
    private static final String INDENT_SPACES = "    ";
    private static final String DOUBLE_INDENT_SPACES = "        ";
    private static final String REDIRECTED_CLASS_PATH_MANIFEST_NAME = "Rsrc-Class-Path";
    private static final String REDIRECTED_MAIN_CLASS_MANIFEST_NAME = "Rsrc-Main-Class";
    private static final String CURRENT_DIR = "./";
    private static final String LOADER_MAIN_CLASS = "org.eclipse.jdt.internal.jarinjarloader.JarRsrcLoader";

    private static SourceInfo[] convert(IPath[] classpath) {
        SourceInfo[] result = new SourceInfo[classpath.length];
        for (int i = 0; i < classpath.length; ++i) {
            IPath path = classpath[i];
            if (path == null) continue;
            if (path.toFile().isDirectory()) {
                result[i] = new SourceInfo(false, path.toString());
                continue;
            }
            if (!path.toFile().isFile() || !path.getFileExtension().equals(BUILD_TARGET)) continue;
            result[i] = new SourceInfo(true, path.toString());
        }
        return result;
    }

    private static void copyJarInJarLoader(IProject project) throws CoreException, IOException {
        int cnt;
        String pathString = "temp" + File.separator + "jar-in-jar-loader.zip";
        IFile zipFile = project.getFile((IPath)new Path(pathString));
        if (zipFile.exists()) {
            return;
        }
        IFolder tempFolder = project.getFolder((IPath)new Path("temp"));
        FileUtils.createDir((IFolder)tempFolder);
        URI zipURI = URIUtil.toURI((IPath)zipFile.getLocation());
        if (zipURI == null) {
            throw new IOException("Path error: " + pathString);
        }
        InputStream is = JavaPlugin.getDefault().getBundle().getEntry("jar-in-jar-loader.zip").openStream();
        FileOutputStream os = new FileOutputStream(new File(zipURI));
        byte[] buf = new byte[1024];
        while ((cnt = is.read(buf)) > 0) {
            ((OutputStream)os).write(buf, 0, cnt);
        }
        ((OutputStream)os).close();
    }

    public static boolean existsBuildXML(IProject project) {
        if (project == null) {
            return false;
        }
        IFile buildFile = project.getFile(BUILD_XML_NAME);
        return buildFile.exists();
    }

    public static boolean generateAndStoreBuildXML(IProject project, boolean isUpdated) {
        return AntScriptGenerator.generateAndStoreBuildXML(project, isUpdated, PackageType.getDefault());
    }

    public static boolean generateAndStoreBuildXML(IProject project, boolean isUpdated, PackageType pt) {
        if (project == null) {
            return false;
        }
        if (AntScriptGenerator.existsBuildXML(project) && !isUpdated) {
            return true;
        }
        try {
            Document content = AntScriptGenerator.generateBuildXML(project, pt);
            if (content == null) {
                return false;
            }
            AntScriptGenerator.storeBuildXML(project, content);
            switch (pt) {
                case PACKAGE: {
                    AntScriptGenerator.copyJarInJarLoader(project);
                    break;
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            return false;
        }
        return true;
    }

    public static Document generateBuildXML(IProject project, PackageType pt) throws CoreException {
        String jarFileName;
        if (project == null) {
            return null;
        }
        String jarPathString = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
        if (StringUtils.isNullOrEmpty((String)jarPathString)) {
            ErrorReporter.INTERNAL_ERROR((String)"Jar file is null or empty");
            return null;
        }
        File jarFile = new File(jarPathString);
        String jarFolder = jarFile.getParent();
        if (StringUtils.isNullOrEmpty((String)jarFolder)) {
            jarFolder = ".";
        }
        if (StringUtils.isNullOrEmpty((String)(jarFileName = jarFile.getName()))) {
            ErrorReporter.INTERNAL_ERROR((String)"Jar file is null or empty");
            return null;
        }
        ILaunchConfiguration config = JavaAppLaunchConfigGenerator.findLaunchConfiguration(project);
        if (config == null) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while generating the ANT script 'jarbuild.xml' for project", (String)"No suitable launch configuration is found! Create launch configuration by selecting 'Run As' in the pop up menu");
            return null;
        }
        SourceInfo[] sourceInfos = AntScriptGenerator.convert(AntScriptGenerator.getClasspath(config));
        if (sourceInfos == null || sourceInfos.length == 0) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while generating the ANT script 'jarbuild.xml' for project", (String)"Error while resolving classpaths!");
            return null;
        }
        JavaAppLaunchConfigGenerator.deleteTemporaryJavaAppLaunchConfiguration(project);
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            ErrorReporter.INTERNAL_ERROR((String)"Could not get XML builder");
            return null;
        }
        Document document = docBuilder.newDocument();
        String headerComment = CommentUtils.getHeaderComments((String)" ", (String)GeneralConstants.VERSION_STRING).replace("for", "        for") + "\n " + DOUBLE_INDENT_SPACES + REQUIRED_ANT_VERSION_TEXT + "\n " + DOUBLE_INDENT_SPACES + "Do not edit this file unless you know what you are doing!" + " ";
        Comment comment = document.createComment(headerComment);
        document.appendChild(comment);
        Element projectElement = document.createElement("project");
        projectElement.setAttribute("name", project.getName());
        projectElement.setAttribute("default", BUILD_TARGET);
        projectElement.setAttribute("basedir", ".");
        projectElement.appendChild(comment);
        document.appendChild(projectElement);
        Element property = document.createElement("property");
        property.setAttribute("name", "project");
        property.setAttribute("value", project.getName());
        projectElement.appendChild(property);
        property = document.createElement("property");
        property.setAttribute("name", "dir.build");
        property.setAttribute("value", "java_bin");
        projectElement.appendChild(property);
        property = document.createElement("property");
        property.setAttribute("name", "dir.jar");
        property.setAttribute("value", jarFolder);
        projectElement.appendChild(property);
        property = document.createElement("property");
        property.setAttribute("name", "version");
        property.setAttribute("value", "1.0");
        projectElement.appendChild(property);
        property = document.createElement("property");
        property.setAttribute("name", "main-class");
        property.setAttribute("value", ProjectSourceCompiler.getPackageGeneratedRoot(project) + ".Parallel_main");
        projectElement.appendChild(property);
        Element target = document.createElement("target");
        target.setAttribute("name", BUILD_TARGET);
        target.setAttribute("description", "generate the JAR file");
        projectElement.appendChild(target);
        Element buildNumber = document.createElement("buildnumber");
        target.appendChild(buildNumber);
        comment = document.createComment(" Create the directory for JAR ");
        target.appendChild(comment);
        Element makeDir = document.createElement("mkdir");
        makeDir.setAttribute("dir", "${dir.jar}");
        target.appendChild(makeDir);
        String parametrizedJarString = "${dir.jar}/" + jarFileName;
        Element jar = document.createElement(BUILD_TARGET);
        jar.setAttribute("destfile", parametrizedJarString);
        switch (pt) {
            case EXTRACT: {
                jar.setAttribute("filesetmanifest", "mergewithoutmain");
                break;
            }
        }
        target.appendChild(jar);
        Element manifest = document.createElement("manifest");
        jar.appendChild(manifest);
        Element attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Main-Class");
        switch (pt) {
            case EXTRACT: {
                attribute.setAttribute("value", "${main-class}");
                break;
            }
            case PACKAGE: {
                attribute.setAttribute("value", LOADER_MAIN_CLASS);
                break;
            }
        }
        manifest.appendChild(attribute);
        switch (pt) {
            case PACKAGE: {
                attribute = document.createElement("attribute");
                attribute.setAttribute("name", REDIRECTED_MAIN_CLASS_MANIFEST_NAME);
                attribute.setAttribute("value", "${main-class}");
                manifest.appendChild(attribute);
                attribute = document.createElement("attribute");
                attribute.setAttribute("name", REDIRECTED_CLASS_PATH_MANIFEST_NAME);
                StringBuilder rsrcClassPath = new StringBuilder();
                rsrcClassPath.append(CURRENT_DIR);
                SourceInfo[] sourceInfoArray = sourceInfos;
                int n = sourceInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    SourceInfo sourceInfo = sourceInfoArray[i];
                    if (!sourceInfo.isJar) continue;
                    rsrcClassPath.append(" ").append(new File(sourceInfo.absPath).getName());
                }
                attribute.setAttribute("value", rsrcClassPath.toString());
                manifest.appendChild(attribute);
                break;
            }
        }
        attribute = document.createElement("attribute");
        attribute.setAttribute("name", "Class-Path");
        attribute.setAttribute("value", ".");
        manifest.appendChild(attribute);
        switch (pt) {
            case PACKAGE: {
                Element zipfileset = document.createElement("zipfileset");
                zipfileset.setAttribute("src", "temp/jar-in-jar-loader.zip");
                jar.appendChild(zipfileset);
                break;
            }
        }
        for (SourceInfo sourceInfo : sourceInfos) {
            String relPath;
            if (sourceInfo.isJar) {
                File sourceJarFile = new File(sourceInfo.absPath);
                relPath = PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)sourceJarFile.getParent()).replace("\\", "/");
                Element fileset = document.createElement("zipfileset");
                switch (pt) {
                    case EXTRACT: {
                        fileset.setAttribute("src", relPath + "/" + sourceJarFile.getName());
                        fileset.setAttribute("excludes", "META-INF/*.SF");
                        break;
                    }
                    case PACKAGE: {
                        fileset.setAttribute("dir", relPath);
                        fileset.setAttribute("includes", sourceJarFile.getName());
                        break;
                    }
                }
                jar.appendChild(fileset);
                continue;
            }
            Element fileset = document.createElement("fileset");
            relPath = PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)sourceInfo.absPath).replace("\\", "/");
            fileset.setAttribute("dir", relPath);
            jar.appendChild(fileset);
        }
        return document;
    }

    private static IPath[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<IPath> userEntries = new ArrayList<IPath>(entries.length);
        boolean isModularConfig = JavaRuntimeHelper.isModularConfiguration(configuration);
        for (IRuntimeClasspathEntry cpentry : entries) {
            IPath entry;
            String location;
            int classPathProperty = cpentry.getClasspathProperty();
            if ((isModularConfig || classPathProperty != 3) && (!isModularConfig || classPathProperty != 5 && classPathProperty != 4) || (location = cpentry.getLocation()) == null || userEntries.contains(entry = Path.fromOSString((String)location))) continue;
            userEntries.add(entry);
        }
        return userEntries.toArray(new IPath[userEntries.size()]);
    }

    public static void storeBuildXML(IProject project, Document document) throws IOException {
        if (project == null || document == null) {
            return;
        }
        try {
            String buildXMLPath = project.getLocation().toOSString() + File.separator + BUILD_XML_NAME;
            FileOutputStream outputStream = new FileOutputStream(buildXMLPath);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Could not transform to XML");
        }
    }

    private static class SourceInfo {
        public final boolean isJar;
        public final String absPath;

        public SourceInfo(boolean isJar, String absPath) {
            this.isJar = isJar;
            this.absPath = absPath;
        }
    }

    public static enum PackageType {
        EXTRACT,
        PACKAGE;


        public static PackageType getDefault() {
            return EXTRACT;
        }
    }
}

