/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public final class StringDetectionPatternRule
implements IPredicateRule {
    private static final int UNDEFINED = -1;
    private IToken fToken;
    private char[] fStartSequence;
    private char[][] fEndSequences;
    private int fColumn = -1;
    private char fEscapeCharacter;
    private boolean fEscapeContinuesLine;
    private boolean fBreaksOnEOL;
    private boolean fBreaksOnEOF;
    private final Comparator<char[]> fLineDelimiterComparator = new DecreasingCharArrayLengthComparator();
    private char[][] fLineDelimiters;
    private char[][] fSortedLineDelimiters;

    public StringDetectionPatternRule(String startSequence, char[][] endSequence, IToken token) {
        this(startSequence, endSequence, token, '\u0000');
    }

    public StringDetectionPatternRule(String startSequence, char[][] endSequence, IToken token, char escapeCharacter) {
        this(startSequence, endSequence, token, escapeCharacter, false);
    }

    public StringDetectionPatternRule(String startSequence, char[][] endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL) {
        Assert.isTrue((startSequence != null && startSequence.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((endSequence != null || breaksOnEOL ? 1 : 0) != 0);
        Assert.isNotNull((Object)token);
        this.fStartSequence = startSequence == null ? new char[]{} : startSequence.toCharArray();
        this.fEndSequences = endSequence;
        this.fToken = token;
        this.fEscapeCharacter = escapeCharacter;
        this.fBreaksOnEOL = breaksOnEOL;
    }

    public StringDetectionPatternRule(String startSequence, char[][] endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL);
        this.fBreaksOnEOF = breaksOnEOF;
    }

    public StringDetectionPatternRule(String startSequence, char[][] endSequence, IToken token, char escapeCharacter, boolean breaksOnEOL, boolean breaksOnEOF, boolean escapeContinuesLine) {
        this(startSequence, endSequence, token, escapeCharacter, breaksOnEOL, breaksOnEOF);
        this.fEscapeContinuesLine = escapeContinuesLine;
    }

    public void setColumnConstraint(int column) {
        this.fColumn = column < 0 ? -1 : column;
    }

    protected IToken doEvaluate(ICharacterScanner scanner) {
        return this.doEvaluate(scanner, false);
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        int c;
        if (resume ? this.endSequenceDetected(scanner) : (c = scanner.read()) == this.fStartSequence[0] && this.sequenceDetected(scanner, this.fStartSequence, false) && this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    private boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        int count;
        char[][] originalDelimiters = scanner.getLegalLineDelimiters();
        if (this.fLineDelimiters == null || originalDelimiters.length != count) {
            this.fSortedLineDelimiters = new char[count][];
        } else {
            for (count = originalDelimiters.length; count > 0 && this.fLineDelimiters[count - 1] == originalDelimiters[count - 1]; --count) {
            }
        }
        if (count != 0) {
            this.fLineDelimiters = originalDelimiters;
            System.arraycopy(this.fLineDelimiters, 0, this.fSortedLineDelimiters, 0, this.fLineDelimiters.length);
            Arrays.sort(this.fSortedLineDelimiters, this.fLineDelimiterComparator);
        }
        int readCount = 1;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                if (this.fEscapeContinuesLine) {
                    c = scanner.read();
                    for (int i = 0; !(i >= this.fSortedLineDelimiters.length || c == this.fSortedLineDelimiters[i][0] && this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)); ++i) {
                    }
                } else {
                    scanner.read();
                }
            } else {
                int i;
                boolean found = false;
                for (i = 0; i < this.fEndSequences.length; ++i) {
                    if (this.fEndSequences[i].length <= 0 || c != this.fEndSequences[i][0]) continue;
                    found = true;
                    if (!this.sequenceDetected(scanner, this.fEndSequences[i], true)) continue;
                    return true;
                }
                if (!found && this.fBreaksOnEOL) {
                    for (i = 0; i < this.fSortedLineDelimiters.length; ++i) {
                        if (c != this.fSortedLineDelimiters[i][0] || !this.sequenceDetected(scanner, this.fSortedLineDelimiters[i], true)) continue;
                        return true;
                    }
                }
            }
            ++readCount;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        while (readCount > 0) {
            scanner.unread();
            --readCount;
        }
        return false;
    }

    private boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        for (int i = 1; i < sequence.length; ++i) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c == sequence[i]) continue;
            scanner.unread();
            for (int j = i - 1; j > 0; --j) {
                scanner.unread();
            }
            return false;
        }
        return true;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (this.fColumn == -1) {
            return this.doEvaluate(scanner, resume);
        }
        int c = scanner.read();
        scanner.unread();
        if (c == this.fStartSequence[0]) {
            return this.fColumn == scanner.getColumn() ? this.doEvaluate(scanner, resume) : Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }

    private static class DecreasingCharArrayLengthComparator
    implements Comparator<char[]> {
        private DecreasingCharArrayLengthComparator() {
        }

        @Override
        public int compare(char[] o1, char[] o2) {
            return o2.length - o1.length;
        }
    }
}

