/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.maincontroller;

import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.tabpages.maincontroller.BaseMainControllerTab;

public final class SingleMainControllerTab
extends BaseMainControllerTab {
    public SingleMainControllerTab(ILaunchConfigurationTabGroup tabGroup) {
        super(tabGroup);
        this.workingDirectoryRequired = true;
        this.executableRequired = true;
    }

    @Override
    public boolean canSave() {
        if ("".equals(this.executableFileText.getStringValue()) || !this.executableFileIsValid) {
            return false;
        }
        return super.canSave();
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean result = super.isValid(launchConfig);
        if (!result) {
            return false;
        }
        if ("".equals(this.executableFileText.getStringValue())) {
            this.setErrorMessage("The executable file must be set.");
            return false;
        }
        if (!this.executableFileIsValid) {
            this.setErrorMessage("The executable file is not valid.");
            return false;
        }
        if (!this.executableIsForSingleMode) {
            this.setErrorMessage("The executable was built for parallel mode execution, it can not be launched in a single mode launcher.");
            return false;
        }
        if (!this.executableIsExecutable) {
            this.setErrorMessage("The executable is not actually executable. Please set an executable generated for single mode execution as the executable.");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public static boolean initLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration, IProject project, String configFilePath) {
        boolean result = BaseMainControllerTab.initLaunchConfiguration(configuration, project, configFilePath, true);
        if (!result) {
            return false;
        }
        String executable = SingleMainControllerTab.getExecutableForProject(project);
        if ("".equals(executable)) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)("Error while creating the default launch configuration for project " + project.getName()), (String)"The executable file must be set.");
            return false;
        }
        return true;
    }
}

