/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.util.BooleanList;
import org.jfree.chart.util.LineUtils;
import org.jfree.chart.util.ShapeList;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class XYEdgeRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    private static final long serialVersionUID = -754074656456575380L;
    public static final boolean DEFAULT_SHAPE_ROTATE = true;
    public static final boolean DEFAULT_DRAW_PLOT_CROSSING_LINES = true;
    private final ShapeList beginShapes = new ShapeList();
    private final BooleanList beginShapesRotate = new BooleanList();
    private final ShapeList endShapes = new ShapeList();
    private final BooleanList endShapesRotate = new BooleanList();
    private final BooleanList drawPlotCrossingLines = new BooleanList();
    private Shape defaultBeginShape;
    private Boolean defaultBeginShapeRotate;
    private Shape defaultEndShape;
    private Boolean defaultEndShapeRotate;
    private boolean defaultShapeRotate = true;
    private boolean defaultDrawPlotCrossingLines = true;

    public XYEdgeRenderer() {
        this.setDefaultShape(new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
        this.setAutoPopulateSeriesShape(false);
        this.setDataBoundsIncludesVisibleSeriesOnly(false);
    }

    public void setDefaultDrawPlotCrossingLines(boolean drawCrossingLines, boolean notify) {
        this.defaultDrawPlotCrossingLines = drawCrossingLines;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getDefaultDrawPlotCrossingLines() {
        return this.defaultDrawPlotCrossingLines;
    }

    public boolean getSeriesDrawPlotCrossingLines(int series) {
        Boolean drawCrossingLines = this.drawPlotCrossingLines.getBoolean(series);
        return drawCrossingLines == null ? this.getDefaultDrawPlotCrossingLines() : drawCrossingLines.booleanValue();
    }

    public void setSeriesDrawPlotCrossingLines(int series, boolean drawCrossingLines, boolean notify) {
        this.drawPlotCrossingLines.setBoolean(series, Boolean.valueOf(drawCrossingLines));
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void setDefaultShapeRotate(boolean baseShapeRotate) {
        this.defaultShapeRotate = baseShapeRotate;
    }

    public boolean getDefaultShapeRotate(boolean baseShapeRotate) {
        return this.defaultShapeRotate;
    }

    public void setDefaultBeginShape(Shape baseBeginShape, boolean notify) {
        this.defaultBeginShape = baseBeginShape;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Shape getDefaultBeginShape() {
        return this.defaultBeginShape;
    }

    public void setSeriesBeginShape(int series, Shape shape, boolean notify) {
        this.beginShapes.setShape(series, shape);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Shape getSeriesBeginShape(int series) {
        Shape shape = this.beginShapes.getShape(series);
        return shape == null ? this.defaultBeginShape : shape;
    }

    public void setSeriesBeginShapeRotate(int series, boolean rotate, boolean notify) {
        this.beginShapesRotate.setBoolean(series, Boolean.valueOf(rotate));
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public void setDefaultBeginShapeRotate(Boolean baseBeginShapeRotate, boolean notify) {
        this.defaultBeginShapeRotate = baseBeginShapeRotate;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Boolean getDefaultBeginShapeRotate() {
        return this.defaultBeginShapeRotate == null ? this.defaultShapeRotate : this.defaultBeginShapeRotate;
    }

    public boolean getSeriesBeginShapeRotate(int series) {
        Boolean rotate = this.beginShapesRotate.getBoolean(series);
        return rotate == null ? this.getDefaultBeginShapeRotate() : rotate;
    }

    public void setDefaultEndShape(Shape baseEndShape, boolean notify) {
        this.defaultEndShape = baseEndShape;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Shape getDefaultEndShape() {
        return this.defaultEndShape;
    }

    public void setSeriesEndShape(int series, Shape shape, boolean notify) {
        this.endShapes.setShape(series, shape);
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Shape getSeriesEndShape(int series) {
        Shape shape = this.endShapes.getShape(series);
        return shape == null ? this.defaultEndShape : shape;
    }

    public void setDefaultEndShapeRotate(Boolean baseEndShapeRotate, boolean notify) {
        this.defaultEndShapeRotate = baseEndShapeRotate;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public Boolean getDefaultEndShapeRotate() {
        return this.defaultEndShapeRotate == null ? this.defaultShapeRotate : this.defaultEndShapeRotate;
    }

    public void setSeriesEndShapeRotate(int series, boolean rotate, boolean notify) {
        this.endShapesRotate.setBoolean(series, Boolean.valueOf(rotate));
        if (notify) {
            this.fireChangeEvent();
        }
    }

    public boolean getSeriesEndShapeRotate(int series) {
        Boolean rotate = this.endShapesRotate.getBoolean(series);
        return rotate == null ? this.getDefaultEndShapeRotate() : rotate;
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        LegendItem item = super.getLegendItem(datasetIndex, series);
        item.setShape(this.lookupLegendShape(series));
        return item;
    }

    public Shape lookupSeriesShape(int series) {
        Shape shape = this.getSeriesEndShape(series);
        if (shape == null) {
            shape = this.getSeriesBeginShape(series);
        }
        if (shape == null) {
            shape = super.lookupSeriesShape(series);
        }
        return shape;
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYItemRendererState state = super.initialise(g2, dataArea, plot, data, info);
        state.setProcessVisibleItemsOnly(false);
        return state;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        if (!this.getItemVisible(series, item) || !(dataset instanceof IntervalXYDataset)) {
            return;
        }
        IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
        double x0 = intervalDataset.getStartXValue(series, item);
        double y0 = intervalDataset.getStartYValue(series, item);
        double x1 = intervalDataset.getEndXValue(series, item);
        double y1 = intervalDataset.getEndYValue(series, item);
        if (Double.isNaN(x0) || Double.isNaN(y0) || Double.isNaN(x1) || Double.isNaN(y1)) {
            return;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
        double transY0 = rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            state.workingLine.setLine(transY0, transX0, transY1, transX1);
        } else if (orientation == PlotOrientation.VERTICAL) {
            state.workingLine.setLine(transX0, transY0, transX1, transY1);
        }
        boolean edgeVisible = this.drawEdge(g2, state, dataArea, dataset, series, item);
        if (edgeVisible && this.isItemLabelVisible(series, item)) {
            double centerX = transX0 * 0.5 + transX1 * 0.5;
            double centerY = transY0 * 0.5 + transY1 * 0.5;
            this.drawItemLabel(g2, orientation, dataset, series, item, centerX, centerY, false);
        }
    }

    protected boolean drawEdge(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, XYDataset dataset, int series, int item) {
        EntityCollection entities;
        Line2D line = state.workingLine;
        boolean beginVisible = dataArea.contains(line.getP1());
        boolean endVisible = dataArea.contains(line.getP2());
        if (!(beginVisible || endVisible || this.getSeriesDrawPlotCrossingLines(series))) {
            return false;
        }
        Line2D fullLine = (Line2D)line.clone();
        boolean lineVisible = LineUtils.clipLine((Line2D)line, (Rectangle2D)dataArea);
        if (!lineVisible) {
            return false;
        }
        Stroke itemStroke = this.getItemStroke(series, item);
        g2.setStroke(itemStroke);
        g2.setPaint(this.getItemPaint(series, item));
        g2.draw(line);
        Shape beginShape = null;
        if (beginVisible && (beginShape = this.createBeginShape(fullLine, series)) != null) {
            g2.fill(beginShape);
        }
        Shape endShape = null;
        if (endVisible && (endShape = this.createEndShape(fullLine, series)) != null) {
            g2.fill(endShape);
        }
        if ((entities = state.getEntityCollection()) != null) {
            Area hotspot = new Area(ShapeUtils.createLineRegion((Line2D)line, (float)this.calculateLineWidth(itemStroke)));
            if (beginShape != null) {
                hotspot.add(new Area(beginShape));
            }
            if (endShape != null) {
                hotspot.add(new Area(endShape));
            }
            hotspot.intersect(new Area(dataArea));
            this.addEntity(entities, hotspot, dataset, series, item, 0.0, 0.0);
        }
        return true;
    }

    protected Shape createBeginShape(Line2D line, int series) {
        Shape shape = this.getSeriesBeginShape(series);
        if (shape == null) {
            return null;
        }
        double tx = shape.getBounds2D().getCenterX();
        double ty = shape.getBounds2D().getCenterY();
        AffineTransform aff = new AffineTransform();
        aff.translate(line.getX1() - tx, line.getY1() - ty);
        if (this.getSeriesBeginShapeRotate(series)) {
            double angle = Math.atan2(line.getY2() - line.getY1(), line.getX2() - line.getX1());
            aff.rotate(angle, tx, ty);
        }
        return aff.createTransformedShape(shape);
    }

    protected Shape createEndShape(Line2D line, int series) {
        Shape shape = this.getSeriesEndShape(series);
        if (shape == null) {
            return null;
        }
        double tx = shape.getBounds2D().getCenterX();
        double ty = shape.getBounds2D().getCenterY();
        AffineTransform aff = new AffineTransform();
        aff.translate(line.getX2() - tx, line.getY2() - ty);
        if (this.getSeriesEndShapeRotate(series)) {
            double angle = Math.atan2(line.getY2() - line.getY1(), line.getX2() - line.getX1());
            aff.rotate(angle, tx, ty);
        }
        return aff.createTransformedShape(shape);
    }

    protected float calculateLineWidth(Stroke stroke) {
        return (float)stroke.createStrokedShape(new Line2D.Double(0.0, 0.0, 100.0, 0.0)).getBounds2D().getHeight();
    }
}

