/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.constraintgraph.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.trace4cps.analysis.constraintgraph.impl.Constraint;

public abstract class ConstraintGraphNode
implements Comparable<ConstraintGraphNode> {
    private final List<Constraint> succ = new ArrayList<Constraint>();
    private final int id;

    ConstraintGraphNode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public abstract double timestamp();

    public List<Constraint> constraints() {
        return this.succ;
    }

    void addConstraint(ConstraintGraphNode s, double w) {
        for (Constraint c : this.succ) {
            if (c.getDst() != s || c.weight() != w) continue;
            return;
        }
        this.succ.add(new Constraint(this, s, w));
    }

    @Override
    public int compareTo(ConstraintGraphNode o) {
        double t0 = this.timestamp();
        double t1 = o.timestamp();
        return Double.compare(t0, t1);
    }
}

