/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.trace4cps.analysis.mtl.ExplanationTable;
import org.eclipse.trace4cps.analysis.mtl.InformativePrefix;
import org.eclipse.trace4cps.analysis.mtl.MtlFormula;
import org.eclipse.trace4cps.analysis.mtl.State;
import org.eclipse.trace4cps.analysis.mtl.check.RegionImpl;
import org.eclipse.trace4cps.analysis.mtl.check.TabularExplanationTable;
import org.eclipse.trace4cps.analysis.mtl.impl.MTLtrue;

public final class CompactExplanationTableImpl
implements TabularExplanationTable {
    private final List<? extends State> trace;
    private final Map<MtlFormula, Integer> subForms;
    private int trueIndex = -1;
    private final int p;
    private final int[] table;

    public CompactExplanationTableImpl(List<? extends State> trace, Map<MtlFormula, Integer> subForms) {
        this.trace = trace;
        this.subForms = subForms;
        for (Map.Entry<MtlFormula, Integer> e : subForms.entrySet()) {
            if (!(e.getKey() instanceof MTLtrue)) continue;
            this.trueIndex = e.getValue();
        }
        this.p = subForms.size() / 8 + 1;
        this.table = new int[this.p * trace.size()];
        int i = 0;
        while (i < this.p * trace.size()) {
            this.table[i] = 0;
            ++i;
        }
    }

    @Override
    public List<? extends State> getTrace() {
        return this.trace;
    }

    @Override
    public int get(int formulaIndex, int stateIndex) {
        if (formulaIndex == this.trueIndex) {
            return 1;
        }
        return this.table[stateIndex * this.p + (formulaIndex >> 3)] >> ((formulaIndex & 7) << 2) & 0xF;
    }

    @Override
    public int put(int formulaIndex, int stateIndex, int c) {
        int n = stateIndex * this.p + (formulaIndex >> 3);
        this.table[n] = this.table[n] | c << ((formulaIndex & 7) << 2);
        return c;
    }

    public List<ExplanationTable.Region> getRegions(MtlFormula phi) {
        int formulaIndex = this.subForms.get(phi);
        ArrayList<ExplanationTable.Region> regions = new ArrayList<ExplanationTable.Region>();
        InformativePrefix current = this.getValue(formulaIndex, 0);
        RegionImpl r = new RegionImpl(current);
        r.setStart(0, this.trace.get(0).getTimestamp().doubleValue());
        int i = 1;
        while (i < this.trace.size()) {
            InformativePrefix v = this.getValue(formulaIndex, i);
            if (v != current) {
                r.setEnd(i - 1, this.trace.get(i - 1).getTimestamp().doubleValue());
                regions.add(r);
                current = v;
                r = new RegionImpl(current);
                r.setStart(i, this.trace.get(i).getTimestamp().doubleValue());
            }
            ++i;
        }
        r.setEnd(this.trace.size() - 1, this.trace.get(this.trace.size() - 1).getTimestamp().doubleValue());
        regions.add(r);
        return regions;
    }

    @Override
    public InformativePrefix getValue(MtlFormula phi, int index) {
        return this.getValue(this.subForms.get(phi), index);
    }

    public InformativePrefix getValue(int formulaIndex, int index) {
        switch (this.get(formulaIndex, index)) {
            case 1: {
                return InformativePrefix.GOOD;
            }
            case 2: {
                return InformativePrefix.BAD;
            }
            case 3: {
                return InformativePrefix.NON_INFORMATIVE;
            }
            case 0: {
                return InformativePrefix.NOT_COMPUTED;
            }
        }
        throw new IllegalStateException();
    }
}

