/*
 * Copyright (c) 2021, 2025 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core.impl;

import java.util.TreeSet;

public final class TSPoints extends AbstractTSPoints {
    private TreeSet<TimeValuePair> data = new TreeSet<TimeValuePair>();

    @Override
    public Iterable<TimeValuePair> getData() {
        return data;
    }

    @Override
    public int getSize() {
        return data.size();
    }

    @Override
    public Double getFirstTimeStamp() {
        if (data.isEmpty()) {
            return null;
        } else {
            return data.getFirst().getTime();
        }
    }

    @Override
    public Double getLastTimeStamp() {
        if (data.isEmpty()) {
            return null;
        } else {
            return data.getLast().getTime();
        }
    }

    /**
     * Add a new data-point to this time-series
     */
    public void add(double timestamp, double value) {
        data.add(new TimeValuePair(timestamp, value));
    }
}
