/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.trace4cps.analysis.behavior.Behavior;
import org.eclipse.trace4cps.analysis.behavior.BehavioralPartition;
import org.eclipse.trace4cps.analysis.behavior.HistogramEntry;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IAttributeFilter;
import org.eclipse.trace4cps.core.IEvent;

public class BehavioralAnalysis {
    private BehavioralAnalysis() {
    }

    public static BehavioralPartition partition(Iterable<IEvent> events, String idAtt, Set<String> uniquenessAtts) {
        return new BehavioralPartition(events, idAtt, uniquenessAtts);
    }

    public static List<HistogramEntry> createBehavioralHistogram(BehavioralPartition partition) {
        ArrayList<HistogramEntry> entries = new ArrayList<HistogramEntry>();
        for (List<Behavior> cell : partition) {
            entries.add(new HistogramEntry(cell));
        }
        Collections.sort(entries, new Comparator<HistogramEntry>(){

            @Override
            public int compare(HistogramEntry o1, HistogramEntry o2) {
                return Integer.compare(o2.size(), o1.size());
            }
        });
        return entries;
    }

    public static IAttributeFilter computeBehavioralRepresentativeFilter(BehavioralPartition partition) {
        if (partition.size() == 0) {
            return null;
        }
        final HashSet<Integer> objectIds = new HashSet<Integer>();
        for (Behavior b : partition.getRepresentatives()) {
            objectIds.add(b.getValue());
        }
        final String idAtt = partition.getIdAtt();
        return new IAttributeFilter(){

            @Override
            public boolean include(IAttributeAware a) {
                String id = a.getAttributeValue(idAtt);
                if (id != null && BehavioralPartition.isInteger(id)) {
                    return objectIds.contains(Integer.parseInt(id));
                }
                return false;
            }
        };
    }
}

