/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl.impl;

import java.util.Map;
import org.eclipse.trace4cps.analysis.mtl.impl.IExp;

public class VarIExp
implements IExp {
    private final String value;

    public VarIExp(String value) {
        this.value = value;
    }

    @Override
    public double evaluate(Map<String, Long> valuation) {
        Long l = valuation.get(this.value);
        if (l == null) {
            throw new IllegalStateException("No value for free variable \"" + this.value + "\"");
        }
        return l.longValue();
    }

    @Override
    public long evaluateLong(Map<String, Long> valuation) {
        Long l = valuation.get(this.value);
        if (l == null) {
            throw new IllegalStateException("No value for free variable \"" + this.value + "\"");
        }
        return l;
    }

    @Override
    public boolean isNaturalNumber() {
        return true;
    }

    @Override
    public boolean hasVariable() {
        return true;
    }

    public String toString() {
        return this.value;
    }
}

