/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.io.conv;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum AttributeValueType {
    STRING(0, "String", "String"),
    DOUBLE(1, "Double", "Double");

    public static final int STRING_VALUE = 0;
    public static final int DOUBLE_VALUE = 1;
    private static final AttributeValueType[] VALUES_ARRAY;
    public static final List<AttributeValueType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttributeValueType[]{STRING, DOUBLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttributeValueType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeValueType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeValueType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeValueType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeValueType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return DOUBLE;
            }
        }
        return null;
    }

    private AttributeValueType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

