/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.widgets;

import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.trace4cps.common.jfreechart.ui.widgets.ChartPanelComposite;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class ChartPanelCompositeHistory {
    private final Action backAction = new Action("Back"){
        {
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            ChartPanelCompositeHistory.this.back();
        }
    };
    private final Action forwardAction = new Action("Forward"){
        {
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            ChartPanelCompositeHistory.this.forward();
        }
    };
    private final PropertyChangeListener chartChangeListener = e -> {
        JFreeChart chart = (JFreeChart)e.getNewValue();
        this.setPlot(chart == null ? null : chart.getPlot());
    };
    private final LinkedList<XYPlotHistoryElement> history = new LinkedList();
    private final LinkedList<XYPlotHistoryElement> future = new LinkedList();
    private final PlotChangeListener plotChangeListener;
    private final Job updateJob;
    private XYPlot xyPlot = null;

    public ChartPanelCompositeHistory(ChartPanelComposite chartPanelComposite) {
        this(chartPanelComposite, 50, 1000L);
    }

    public ChartPanelCompositeHistory(ChartPanelComposite chartPanelComposite, final int historySize, long quietTime) {
        this.updateJob = new Job("ChartPanelCompositeHistory update"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                XYPlotHistoryElement current = ChartPanelCompositeHistory.this.createHistoryElement(ChartPanelCompositeHistory.this.xyPlot);
                if (ChartPanelCompositeHistory.this.history.isEmpty() || !Objects.equals(current, ChartPanelCompositeHistory.this.history.peek())) {
                    ChartPanelCompositeHistory.this.history.push(current);
                    while (ChartPanelCompositeHistory.this.history.size() > historySize + 1) {
                        ChartPanelCompositeHistory.this.history.removeLast();
                    }
                    ChartPanelCompositeHistory.this.future.clear();
                    ChartPanelCompositeHistory.this.updateActions();
                }
                return Status.OK_STATUS;
            }
        };
        this.plotChangeListener = e -> {
            if (e.getType() != ChartChangeEventType.GENERAL) {
                this.clearHistory();
            }
            this.updateJob.cancel();
            this.updateJob.schedule(quietTime);
        };
        chartPanelComposite.getChartPanel().addPropertyChangeListener("Chart", this.chartChangeListener);
        chartPanelComposite.addDisposeListener(e -> {
            ((ChartPanelComposite)((Object)((Object)e.getSource()))).getChartPanel().removePropertyChangeListener("Chart", this.chartChangeListener);
            this.dispose();
        });
        JFreeChart chart = chartPanelComposite.getChart();
        this.setPlot(chart == null ? null : chart.getPlot());
    }

    public void dispose() {
        this.setPlot(null);
    }

    public Action getBackAction() {
        return this.backAction;
    }

    public Action getForwardAction() {
        return this.forwardAction;
    }

    public void clearHistory() {
        this.history.clear();
        this.future.clear();
        this.updateActions();
    }

    protected synchronized void setPlot(Plot plot) {
        if (this.xyPlot == plot) {
            return;
        }
        if (this.xyPlot != null) {
            this.xyPlot.removeChangeListener(this.plotChangeListener);
        }
        this.clearHistory();
        if (plot instanceof XYPlot) {
            this.xyPlot = (XYPlot)plot;
            this.xyPlot.addChangeListener(this.plotChangeListener);
        } else {
            this.xyPlot = null;
        }
    }

    protected synchronized void back() {
        if (this.history.size() <= 1) {
            return;
        }
        this.future.push(this.history.pop());
        this.history.peek().apply(this.xyPlot);
        this.updateActions();
    }

    protected synchronized void forward() {
        if (this.future.isEmpty()) {
            return;
        }
        this.history.push(this.future.pop());
        this.history.peek().apply(this.xyPlot);
        this.updateActions();
    }

    protected void updateActions() {
        this.backAction.setEnabled(this.history.size() > 1);
        this.forwardAction.setEnabled(!this.future.isEmpty());
    }

    protected XYPlotHistoryElement createHistoryElement(XYPlot xyPlot) {
        return new XYPlotHistoryElement(xyPlot);
    }

    protected static class XYPlotHistoryElement {
        private final Range rangeAxisRange;
        private final Range domainAxisRange;

        public XYPlotHistoryElement(XYPlot xyPlot) {
            ValueAxis rangeAxis = xyPlot == null ? null : xyPlot.getRangeAxis();
            this.rangeAxisRange = rangeAxis == null || rangeAxis.isAutoRange() ? null : rangeAxis.getRange();
            ValueAxis domainAxis = xyPlot == null ? null : xyPlot.getDomainAxis();
            this.domainAxisRange = domainAxis == null || domainAxis.isAutoRange() ? null : domainAxis.getRange();
        }

        public Range getRangeAxisRange() {
            return this.rangeAxisRange;
        }

        public Range getDomainAxisRange() {
            return this.domainAxisRange;
        }

        public void apply(XYPlot xyPlot) {
            boolean notify = xyPlot.isNotify();
            xyPlot.setNotify(false);
            try {
                ValueAxis domainAxis;
                ValueAxis rangeAxis = xyPlot.getRangeAxis();
                if (rangeAxis != null) {
                    if (this.rangeAxisRange == null) {
                        rangeAxis.setAutoRange(true, true);
                    } else {
                        rangeAxis.setRange(this.rangeAxisRange, true, true);
                    }
                }
                if ((domainAxis = xyPlot.getDomainAxis()) != null) {
                    if (this.domainAxisRange == null) {
                        domainAxis.setAutoRange(true, true);
                    } else {
                        domainAxis.setRange(this.domainAxisRange, true, true);
                    }
                }
            }
            finally {
                xyPlot.setNotify(notify);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.domainAxisRange == null ? 0 : this.domainAxisRange.hashCode());
            result = 31 * result + (this.rangeAxisRange == null ? 0 : this.rangeAxisRange.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XYPlotHistoryElement other = (XYPlotHistoryElement)obj;
            if (this.domainAxisRange == null ? other.domainAxisRange != null : !this.domainAxisRange.equals((Object)other.domainAxisRange)) {
                return false;
            }
            return !(this.rangeAxisRange == null ? other.rangeAxisRange != null : !this.rangeAxisRange.equals((Object)other.rangeAxisRange));
        }
    }
}

