/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.core.impl.ModifiableTrace;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.core.io.ParseException;
import org.eclipse.trace4cps.core.io.TraceReader;
import org.eclipse.trace4cps.ui.action.OpenTraceView;
import org.eclipse.trace4cps.ui.view.TraceViewer;
import org.eclipse.trace4cps.ui.view.action.BehaviorClassesAction;
import org.eclipse.trace4cps.ui.view.action.BehaviorHistogramAction;
import org.eclipse.trace4cps.ui.view.action.BehaviorRepresentativesAction;
import org.eclipse.trace4cps.ui.view.action.ClaimDescriptionToggleAction;
import org.eclipse.trace4cps.ui.view.action.ClearExtensionAction;
import org.eclipse.trace4cps.ui.view.action.ClearFilterAction;
import org.eclipse.trace4cps.ui.view.action.ColoringAction;
import org.eclipse.trace4cps.ui.view.action.CriticalPathAction;
import org.eclipse.trace4cps.ui.view.action.DependencyAction;
import org.eclipse.trace4cps.ui.view.action.DescribingAction;
import org.eclipse.trace4cps.ui.view.action.DistanceAction;
import org.eclipse.trace4cps.ui.view.action.DropDownAggregateAction;
import org.eclipse.trace4cps.ui.view.action.FilterAction;
import org.eclipse.trace4cps.ui.view.action.GroupingAction;
import org.eclipse.trace4cps.ui.view.action.HideAction;
import org.eclipse.trace4cps.ui.view.action.LatencyAction;
import org.eclipse.trace4cps.ui.view.action.ResourceHistogramAction;
import org.eclipse.trace4cps.ui.view.action.ResourceUsageAction;
import org.eclipse.trace4cps.ui.view.action.SaveViewConfigurationAction;
import org.eclipse.trace4cps.ui.view.action.SeparatorAction;
import org.eclipse.trace4cps.ui.view.action.ThroughputEventAction;
import org.eclipse.trace4cps.ui.view.action.ThroughputIdAction;
import org.eclipse.trace4cps.ui.view.action.TimingAnalysisAction;
import org.eclipse.trace4cps.ui.view.action.ToggleClaimScaleAction;
import org.eclipse.trace4cps.ui.view.action.ToggleSignalAction;
import org.eclipse.trace4cps.ui.view.action.ToggleSortAlphabeticAction;
import org.eclipse.trace4cps.ui.view.action.ToggleViewAction;
import org.eclipse.trace4cps.ui.view.action.VerifyAction;
import org.eclipse.trace4cps.ui.view.action.WipAction;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfiguration;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfigurationIO;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.EditorPart;
import org.jfree.data.Range;

public class TraceView
extends EditorPart {
    public static final String VIEW_ID = "org.eclipse.trace4cps.ui.TraceView";
    public static final String MEMENTO_FILE_KEY = "TRACE_FILE";
    private TraceViewer traceViewer;
    private ToolBarManager mgr;
    private List<File> files = new ArrayList<File>();
    private List<ITrace> unfilteredTraces = new ArrayList<ITrace>();

    public TraceViewer getViewer() {
        return this.traceViewer;
    }

    public TraceViewConfiguration getViewConfiguration() {
        return this.traceViewer.getPlotManager().getViewConfig();
    }

    public boolean hasClaims(boolean filtered) {
        int i = 0;
        while (i < this.getNumTraces()) {
            ITrace trace = this.getTrace(i, filtered);
            if (!trace.getClaims().isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasEvents(boolean includeClaimEvents, boolean filtered) {
        int i = 0;
        while (i < this.getNumTraces()) {
            ITrace trace = this.getTrace(i, filtered);
            if (includeClaimEvents ? !trace.getEvents().isEmpty() : TraceHelper.hasNonClaimEvents((ITrace)trace)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasDependencies(boolean filtered) {
        int i = 0;
        while (i < this.getNumTraces()) {
            ITrace trace = this.getTrace(i, filtered);
            if (!trace.getDependencies().isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasSignals(boolean filtered) {
        int i = 0;
        while (i < this.getNumTraces()) {
            ITrace trace = this.getTrace(i, filtered);
            if (!trace.getSignals().isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasTimeSeries(boolean filtered) {
        int i = 0;
        while (i < this.getNumTraces()) {
            ITrace trace = this.getTrace(i, filtered);
            if (!trace.getTimeSeries().isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Range getDomainAxisRange() {
        return this.traceViewer.getRange();
    }

    public int getNumTraces() {
        return this.unfilteredTraces.size();
    }

    public ITrace getTrace() {
        return this.getTrace(0, true);
    }

    public File getTraceFile(int index) {
        return this.files.get(index);
    }

    public File getViewConfigFile(int index) {
        File traceFile = this.files.get(index);
        return new File(traceFile.getParentFile(), "." + traceFile.getName() + ".view");
    }

    public ITrace getTrace(int index) {
        return this.getTrace(index, true);
    }

    public ITrace getTrace(int index, boolean filtered) {
        if (filtered) {
            return (ITrace)this.traceViewer.getPlotManager().getTraces().get(index);
        }
        return this.unfilteredTraces.get(index);
    }

    public Set<String> getAttributeNames(TracePart part) {
        HashSet<String> result = new HashSet<String>();
        for (ITrace trace : this.traceViewer.getPlotManager().getTraces()) {
            switch (part) {
                case ALL: {
                    result.addAll(TraceHelper.getAttributeNames((ITrace)trace));
                    break;
                }
                case CLAIM: {
                    result.addAll(TraceHelper.getAttributeNames((Collection)trace.getClaims()));
                    break;
                }
                case RESOURCE: {
                    result.addAll(TraceHelper.getAttributeNames((Collection)trace.getResources()));
                    break;
                }
                case EVENT: {
                    result.addAll(TraceHelper.getAttributeNames((Collection)trace.getEvents()));
                    break;
                }
                case DEPENDENCY: {
                    result.addAll(TraceHelper.getAttributeNames((Collection)trace.getDependencies()));
                    break;
                }
                case SIGNAL: {
                    result.addAll(TraceHelper.getAttributeNames((Collection)trace.getSignals()));
                    break;
                }
                case TIMESERIES: {
                    result.addAll(TraceHelper.getAttributeNames((Collection)trace.getTimeSeries()));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return result;
    }

    public Set<String> getAllAttributeValuesFor(String att, TracePart part) {
        HashSet<String> result = new HashSet<String>();
        for (ITrace trace : this.traceViewer.getPlotManager().getTraces()) {
            switch (part) {
                case ALL: {
                    result.addAll(TraceHelper.getAttributeValues((ITrace)trace, (String)att));
                    break;
                }
                case CLAIM: {
                    result.addAll(TraceHelper.getAttributeValues((Collection)trace.getClaims(), (String)att));
                    break;
                }
                case RESOURCE: {
                    result.addAll(TraceHelper.getAttributeValues((Collection)trace.getResources(), (String)att));
                    break;
                }
                case EVENT: {
                    result.addAll(TraceHelper.getAttributeValues((Collection)trace.getEvents(), (String)att));
                    break;
                }
                case DEPENDENCY: {
                    result.addAll(TraceHelper.getAttributeValues((Collection)trace.getDependencies(), (String)att));
                    break;
                }
                case SIGNAL: {
                    result.addAll(TraceHelper.getAttributeValues((Collection)trace.getSignals(), (String)att));
                    break;
                }
                case TIMESERIES: {
                    result.addAll(TraceHelper.getAttributeValues((Collection)trace.getTimeSeries(), (String)att));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return result;
    }

    public void addExtension(IPsop s, int traceIdx) {
        ((ModifiableTrace)this.traceViewer.getPlotManager().getTraces().get(traceIdx)).addSignal(s);
    }

    public void addDependencyExtension(List<IDependency> deps, int traceIdx) {
        ((ModifiableTrace)this.traceViewer.getPlotManager().getTraces().get(traceIdx)).addDependencies(deps);
    }

    public void addEventExtension(List<IEvent> events, int traceIdx) {
        ((ModifiableTrace)this.traceViewer.getPlotManager().getTraces().get(traceIdx)).addEvents(events);
    }

    public boolean hasExtension(TracePart part) {
        int i = 0;
        while (i < this.getNumTraces()) {
            if (((ModifiableTrace)this.traceViewer.getPlotManager().getTraces().get(i)).hasExtension(part)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clearExtensions(TracePart part) {
        int i = 0;
        while (i < this.getNumTraces()) {
            ((ModifiableTrace)this.traceViewer.getPlotManager().getTraces().get(i)).clearExtension(part);
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        ArrayList<File> inputFiles = new ArrayList<File>();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput in = (IFileEditorInput)input;
            IPath location = in.getFile().getLocation();
            if (location == null) throw new PartInitException("Failed to get File for " + String.valueOf(in.getFile()));
            inputFiles.add(location.toFile());
        } else if (input instanceof MultiFileEditorInput) {
            inputFiles.addAll(((MultiFileEditorInput)input).getFiles());
        }
        try {
            this.setInput(inputFiles);
            return;
        }
        catch (IOException | ParseException e) {
            throw new PartInitException("Failed to initialize Trace view", e);
        }
    }

    private void setInput(List<File> inputFiles) throws ParseException, IOException, PartInitException {
        if (inputFiles.isEmpty()) {
            throw new PartInitException("no input files specified");
        }
        if (inputFiles.size() > 1) {
            this.setPartName("Trace comparison");
        } else {
            this.setPartName(inputFiles.get(0).getName());
        }
        for (File file : inputFiles) {
            ITrace trace = TraceReader.readTrace((File)file);
            this.unfilteredTraces.add(trace);
            this.files.add(file);
        }
        this.check2ndOrderSignals();
    }

    private void check2ndOrderSignals() {
        for (ITrace trace : this.unfilteredTraces) {
            for (IPsop signal : trace.getSignals()) {
                for (IPsopFragment f : signal.getFragments()) {
                    if (f.getOrder() != 2) continue;
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    workbench.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning(null, (String)"Warning: visualization incomplete", (String)"Currently, the visualization of 2nd order signals is not correct. A 2nd order fragments is approximated by a single first-order fragement. The temporal logic analysis based on these signals, however, is correct.");
                        }
                    });
                    return;
                }
            }
        }
    }

    public void update() {
        this.traceViewer.refresh();
        this.mgr.update(true);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.mgr = new ToolBarManager(256);
        this.mgr.createControl(parent);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.mgr.getControl());
        this.traceViewer = new TraceViewer(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.traceViewer.getControl());
        if (this.files.size() == 1) {
            try {
                TraceViewConfiguration viewConfig = TraceViewConfigurationIO.fromFile((File)this.getViewConfigFile(0));
                this.traceViewer.getPlotManager().setViewConfiguration(viewConfig);
            }
            catch (IOException | TraceException throwable) {
                // empty catch block
            }
        }
        this.traceViewer.getPlotManager().setTraces(this.unfilteredTraces);
        this.fillToolBar((IToolBarManager)this.mgr);
        this.getSite().setSelectionProvider((ISelectionProvider)this.traceViewer);
        this.update();
    }

    private void fillToolBar(IToolBarManager mgr) {
        mgr.add((IAction)new ToggleViewAction(this));
        mgr.add((IAction)new ToggleSortAlphabeticAction(this));
        mgr.add((IAction)new ToggleClaimScaleAction(this));
        mgr.add((IAction)new ToggleSignalAction(this));
        this.createDescribingMenu(mgr);
        this.createColoringMenu(mgr);
        this.createGroupingMenu(mgr);
        this.createHideMenu(mgr);
        this.createFilterMenu(mgr);
        mgr.add((IContributionItem)new Separator("Analysis"));
        mgr.add((IAction)new CriticalPathAction(this));
        mgr.add((IAction)new VerifyAction(this));
        mgr.add((IAction)new TimingAnalysisAction(this));
        this.createLittlesLawMenu(mgr);
        this.createResourceMenu(mgr);
        this.createBehaviorMenu(mgr);
        this.createComparisonMenu(mgr);
        mgr.add((IContributionItem)new Separator("General"));
        this.createClearExtensionMenu(mgr);
        mgr.add((IAction)new SaveViewConfigurationAction(this));
    }

    private void createDescribingMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new ClaimDescriptionToggleAction(this), new DescribingAction(this, TracePart.CLAIM), new DescribingAction(this, TracePart.RESOURCE), new DescribingAction(this, TracePart.EVENT), new DescribingAction(this, TracePart.DEPENDENCY), new DescribingAction(this, TracePart.SIGNAL), new DescribingAction(this, TracePart.TIMESERIES)};
        mgr.add((IAction)new DropDownAggregateAction(this, 0, "Describing", "/icons/xml_text_node.png", actions));
    }

    private void createColoringMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new ColoringAction(this, TracePart.CLAIM), new ColoringAction(this, TracePart.EVENT), new ColoringAction(this, TracePart.DEPENDENCY), new ColoringAction(this, TracePart.TIMESERIES)};
        mgr.add((IAction)new DropDownAggregateAction(this, 0, "Coloring", "/icons/palette_view.gif", actions));
    }

    private void createGroupingMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new GroupingAction(this, TracePart.CLAIM), new GroupingAction(this, TracePart.EVENT)};
        mgr.add((IAction)new DropDownAggregateAction(this, 0, "Grouping", "/icons/category_obj.png", actions));
    }

    private void createFilterMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new FilterAction(this, TracePart.CLAIM), new FilterAction(this, TracePart.RESOURCE), new FilterAction(this, TracePart.EVENT), new FilterAction(this, TracePart.DEPENDENCY), new FilterAction(this, TracePart.SIGNAL), new FilterAction(this, TracePart.TIMESERIES)};
        mgr.add((IAction)new DropDownAggregateAction(this, 0, "Filter", "/icons/filter_ps.png", actions));
    }

    private void createLittlesLawMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new ThroughputEventAction(this), new ThroughputIdAction(this), new LatencyAction(this), new WipAction(this)};
        mgr.add((IAction)new DropDownAggregateAction(this, 1, "Little's Law analysis", "/icons/change_obj.png", actions));
    }

    private void createResourceMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new ResourceUsageAction(this), new ResourceHistogramAction(this)};
        mgr.add((IAction)new DropDownAggregateAction(this, 1, "Resource-usage analysis", "/icons/resource.png", actions));
    }

    private void createBehaviorMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new BehaviorClassesAction(this), new BehaviorRepresentativesAction(this), new BehaviorHistogramAction(this)};
        mgr.add((IAction)new DropDownAggregateAction(this, 1, "Behavioral analysis", "/icons/anomaly.png", actions));
    }

    private void createComparisonMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new DistanceAction(this), new DependencyAction(this)};
        mgr.add((IAction)new DropDownAggregateAction(this, 2, "Trace comparison", "/icons/diff.png", actions));
    }

    private void createHideMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new HideAction(this, TracePart.CLAIM), new HideAction(this, TracePart.EVENT), new HideAction(this, TracePart.DEPENDENCY), new HideAction(this, TracePart.SIGNAL), new HideAction(this, TracePart.TIMESERIES)};
        mgr.add((IAction)new DropDownAggregateAction(this, 0, "Hide", "/icons/pin_view.png", actions));
    }

    private void createClearExtensionMenu(IToolBarManager mgr) {
        Action[] actions = new Action[]{new ClearFilterAction(this, TracePart.CLAIM), new ClearFilterAction(this, TracePart.RESOURCE), new ClearFilterAction(this, TracePart.EVENT), new ClearFilterAction(this, TracePart.DEPENDENCY), new ClearFilterAction(this, TracePart.SIGNAL), new ClearFilterAction(this, TracePart.TIMESERIES), new ClearFilterAction(this, TracePart.ALL), new SeparatorAction(), new ClearExtensionAction(this, TracePart.CLAIM), new ClearExtensionAction(this, TracePart.EVENT), new ClearExtensionAction(this, TracePart.DEPENDENCY), new ClearExtensionAction(this, TracePart.SIGNAL), new ClearExtensionAction(this, TracePart.TIMESERIES), new ClearExtensionAction(this, TracePart.ALL)};
        mgr.add((IAction)new DropDownAggregateAction(this, 0, "Clear filters or extensions", "/icons/delete.png", actions));
    }

    public void setFocus() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
        this.traceViewer.getControl().setFocus();
    }

    public void dispose() {
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public static void showView(final List<File> files, final boolean openTracePerspective) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchWindow wbw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = wbw.getActivePage();
                    if (openTracePerspective) {
                        PlatformUI.getWorkbench().showPerspective("org.eclipse.trace4cps.ui.perspective", wbw);
                    }
                    page.openEditor((IEditorInput)new MultiFileEditorInput(files), TraceView.VIEW_ID);
                }
                catch (WorkbenchException e) {
                    Status status = new Status(4, OpenTraceView.class, e.getMessage(), (Throwable)e);
                    ErrorDialog.openError(null, (String)"Error", (String)"Failed to open TRACE view", (IStatus)status);
                }
            }
        });
    }

    private static final class MultiFileEditorInput
    implements IEditorInput {
        private final List<File> files;

        private MultiFileEditorInput(List<File> files) {
            this.files = files;
        }

        public List<File> getFiles() {
            return this.files;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public boolean exists() {
            return false;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return "MultiFileEditorInput";
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return "MultiFileEditorInput";
        }
    }
}

