/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.utils.SparseList;

public class CTFStream
implements ICTFStream {
    private long fId = 0L;
    private StructDeclaration fPacketContextDecl = null;
    private IDeclaration fEventHeaderDecl = null;
    private StructDeclaration fEventContextDecl = null;
    private CTFTrace fTrace = null;
    private List<@Nullable IEventDeclaration> fEvents = new ArrayList<IEventDeclaration>();
    private boolean fEventUnsetId = false;
    private boolean fStreamIdSet = false;
    private final Set<CTFStreamInput> fInputs = new HashSet<CTFStreamInput>();

    public CTFStream(CTFTrace trace) {
        this.fTrace = trace;
    }

    public void setId(long id) {
        this.fId = id;
        this.fStreamIdSet = true;
    }

    @Override
    public long getId() {
        return this.fId;
    }

    @Override
    public boolean isIdSet() {
        return this.fStreamIdSet;
    }

    @Override
    public boolean isEventHeaderSet() {
        return this.fEventHeaderDecl != null;
    }

    @Override
    public boolean isEventContextSet() {
        return this.fEventContextDecl != null;
    }

    @Override
    public boolean isPacketContextSet() {
        return this.fPacketContextDecl != null;
    }

    public void setEventHeader(StructDeclaration eventHeader) {
        this.fEventHeaderDecl = eventHeader;
    }

    public void setEventHeader(IEventHeaderDeclaration eventHeader) {
        this.fEventHeaderDecl = eventHeader;
    }

    public void setEventContext(StructDeclaration eventContext) {
        this.fEventContextDecl = eventContext;
    }

    public void setPacketContext(StructDeclaration packetContext) {
        this.fPacketContextDecl = packetContext;
    }

    @Override
    public IDeclaration getEventHeaderDeclaration() {
        return this.fEventHeaderDecl;
    }

    @Override
    public StructDeclaration getEventContextDecl() {
        return this.fEventContextDecl;
    }

    @Override
    public StructDeclaration getPacketContextDecl() {
        return this.fPacketContextDecl;
    }

    @Override
    public Set<CTFStreamInput> getStreamInputs() {
        return this.fInputs;
    }

    @Override
    public CTFTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public List<@Nullable IEventDeclaration> getEventDeclarations() {
        return Collections.unmodifiableList(this.fEvents);
    }

    @Override
    public IEventDeclaration getEventDeclaration(int eventId) {
        int eventIndex;
        int n = eventIndex = (long)eventId == -2L ? 0 : eventId;
        if (eventIndex < 0) {
            throw new IllegalArgumentException("Event ID cannot be negative.");
        }
        if (eventIndex >= this.fEvents.size()) {
            return null;
        }
        return this.fEvents.get(eventIndex);
    }

    public void addEvent(IEventDeclaration event) throws ParseException {
        if (this.fEventUnsetId) {
            throw new ParseException("Event without id with multiple events in a stream");
        }
        int id = ((EventDeclaration)event).id();
        if ((long)id == -2L) {
            if (!this.fEvents.isEmpty()) {
                throw new ParseException("Event without id with multiple events in a stream");
            }
            this.fEventUnsetId = true;
            this.fEvents.add(event);
        } else {
            if (this.fEvents.size() > id && this.fEvents.get(id) != null) {
                throw new ParseException("Event id already exists");
            }
            this.ensureSize(id);
            this.fEvents.set(id, event);
        }
    }

    public void addEvents(Collection<IEventDeclaration> events) throws CTFException {
        if (this.fEventUnsetId) {
            throw new CTFException("Cannot add to a stream with an unidentified event");
        }
        if (this.fEvents.isEmpty()) {
            this.fEvents.addAll(events);
            return;
        }
        for (IEventDeclaration event : events) {
            if (event == null) continue;
            int index = event.getId().intValue();
            this.ensureSize(index);
            if (this.fEvents.get(index) != null) {
                throw new CTFException("Both lists have an event defined at position " + index);
            }
            this.fEvents.set(index, event);
        }
    }

    private void ensureSize(int index) {
        List<@Nullable IEventDeclaration> list = this.fEvents;
        if (list instanceof ArrayList) {
            if (index > 50000) {
                SparseList<@Nullable IEventDeclaration> sparseList = new SparseList<IEventDeclaration>(this.fEvents);
                sparseList.ensureSize(index + 1);
                this.fEvents = sparseList;
                return;
            }
            ((ArrayList)list).ensureCapacity(index);
            while (list.size() <= index) {
                list.add(null);
            }
        } else if (list instanceof SparseList) {
            SparseList sparseList = (SparseList)list;
            sparseList.ensureSize(index + 1);
        }
    }

    public void addInput(CTFStreamInput input) {
        this.fInputs.add(input);
    }

    public String toString() {
        return "Stream [id=" + this.fId + ", packetContextDecl=" + this.fPacketContextDecl + ", eventHeaderDecl=" + this.fEventHeaderDecl + ", eventContextDecl=" + this.fEventContextDecl + ", trace=" + this.fTrace + ", events=" + this.fEvents + ", inputs=" + this.fInputs + "]";
    }
}

