/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.LocalProjectScope;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class IndexerPreferences {
    public static final int SCOPE_INSTANCE = 0;
    public static final int SCOPE_PROJECT_PRIVATE = 1;
    public static final int SCOPE_PROJECT_SHARED = 2;
    public static final int UPDATE_POLICY_IMMEDIATE = 0;
    public static final int UPDATE_POLICY_LAZY = 1;
    public static final int UPDATE_POLICY_MANUAL = 2;
    public static final String KEY_INDEXER_ID = "indexerId";
    public static final String KEY_INDEX_ALL_FILES = "indexAllFiles";
    public static final String KEY_INDEX_UNUSED_HEADERS_WITH_DEFAULT_LANG = "indexUnusedHeadersWithDefaultLang";
    public static final String KEY_INDEX_UNUSED_HEADERS_WITH_ALTERNATE_LANG = "indexUnusedHeadersWithAlternateLang";
    public static final String KEY_INDEX_ON_OPEN = "indexOnOpen";
    public static final String KEY_INCLUDE_HEURISTICS = "useHeuristicIncludeResolution";
    public static final String KEY_SKIP_ALL_REFERENCES = "skipReferences";
    public static final String KEY_SKIP_IMPLICIT_REFERENCES = "skipImplicitReferences";
    public static final String KEY_SKIP_TYPE_REFERENCES = "skipTypeReferences";
    public static final String KEY_SKIP_MACRO_REFERENCES = "skipMacroReferences";
    public static final String KEY_UPDATE_POLICY = "updatePolicy";
    public static final String KEY_SKIP_FILES_LARGER_THAN_MB = "skipFilesLargerThanMB";
    public static final String KEY_SKIP_INCLUDED_FILES_LARGER_THAN_MB = "skipIncludedFilesLargerThanMB";
    private static final String KEY_INDEXER_PREFS_SCOPE = "preferenceScope";
    private static final String KEY_INDEX_IMPORT_LOCATION = "indexImportLocation";
    public static final String KEY_REINDEX_ON_CONFIG_CHANGE = "reindexOnConfigChange";
    public static final String KEY_REINDEX_ON_INDEXER_CHANGE = "reindexOnIndexerChange";
    public static final String KEY_INDEX_ALL_HEADER_VERSIONS = "indexAllHeaderVersions";
    public static final String KEY_INDEX_ALL_VERSIONS_SPECIFIC_HEADERS = "indexAllVersionsSpecificHeaders";
    private static final String DEFAULT_INDEX_IMPORT_LOCATION = ".settings/cdt-index.zip";
    private static final int DEFAULT_UPDATE_POLICY = 0;
    public static final int DEFAULT_FILE_SIZE_LIMIT_MB = 8;
    public static final int DEFAULT_INCLUDED_FILE_SIZE_LIMIT_MB = 16;
    private static final String QUALIFIER = "org.eclipse.cdt.core";
    private static final String INDEXER_NODE = "indexer";

    public static int getScope(IProject project) {
        int scope = 0;
        if (project != null) {
            Preferences ppp = IndexerPreferences.getLocalPreferences(project);
            scope = ppp.getInt(KEY_INDEXER_PREFS_SCOPE, -1);
            if (scope == -1) {
                scope = IndexerPreferences.determineScopeOnFirstUse(project);
            }
            if (scope != 0 && IndexerPreferences.get(project, scope, KEY_INDEXER_ID, null) == null) {
                scope = 0;
                ppp.putInt(KEY_INDEXER_PREFS_SCOPE, scope);
                CCoreInternals.savePreferences(project, false);
            }
        }
        return scope;
    }

    public static int setScope(IProject project, int scope) {
        Preferences[] prefs;
        if (project == null) {
            throw new IllegalArgumentException();
        }
        boolean makeCopy = false;
        switch (scope) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                makeCopy = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (makeCopy && (prefs = IndexerPreferences.getPreferences(project, scope))[0].get(KEY_INDEXER_ID, null) == null) {
            Preferences ppp = IndexerPreferences.getLocalPreferences(project);
            int oldScope = ppp.getInt(KEY_INDEXER_PREFS_SCOPE, 0);
            Properties props = IndexerPreferences.getProperties(project, oldScope);
            IndexerPreferences.setProperties(prefs[0], props);
        }
        Preferences ppp = IndexerPreferences.getLocalPreferences(project);
        ppp.putInt(KEY_INDEXER_PREFS_SCOPE, scope);
        return scope;
    }

    public static void setUpdatePolicy(IProject project, int policy) {
        switch (policy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        IndexerPreferences.getInstancePreferences().put(KEY_UPDATE_POLICY, String.valueOf(policy));
    }

    public static Properties getProperties(IProject project) {
        return IndexerPreferences.getProperties(project, IndexerPreferences.getScope(project));
    }

    public static Properties getProperties(IProject project, int scope) {
        Preferences[] prefs = IndexerPreferences.getPreferences(project, scope);
        Properties props = new Properties();
        int i = 0;
        while (i < prefs.length) {
            IndexerPreferences.readProperties(prefs[i], props);
            if (i == 0) {
                IndexerPreferences.migrateProperties(props);
            }
            ++i;
        }
        return props;
    }

    private static void migrateProperties(Properties props) {
        if (props.get(KEY_INDEX_UNUSED_HEADERS_WITH_DEFAULT_LANG) == null && Boolean.parseBoolean((String)props.get(KEY_INDEX_ALL_FILES))) {
            props.put(KEY_INDEX_UNUSED_HEADERS_WITH_DEFAULT_LANG, "true");
        }
    }

    public static Properties getDefaultIndexerProperties() {
        Preferences prefs = IndexerPreferences.getDefaultPreferences();
        Properties props = new Properties();
        IndexerPreferences.readProperties(prefs, props);
        return props;
    }

    public static int getDefaultUpdatePolicy() {
        Preferences[] prefs = new Preferences[]{IndexerPreferences.getDefaultPreferences()};
        return IndexerPreferences.getUpdatePolicy(prefs);
    }

    public static void setProperties(IProject project, int scope, Properties props) {
        Preferences[] prefs = IndexerPreferences.getPreferences(project, scope);
        IndexerPreferences.setProperties(prefs[0], props);
    }

    private static void setProperties(Preferences prefs, Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            prefs.put(key, val);
        }
    }

    public static String get(IProject project, String key, String defval) {
        IPreferencesService prefService = Platform.getPreferencesService();
        Preferences[] prefs = IndexerPreferences.getPreferences(project);
        return prefService.get(key, defval, prefs);
    }

    private static String get(IProject project, int scope, String key, String defval) {
        IPreferencesService prefService = Platform.getPreferencesService();
        Preferences[] prefs = IndexerPreferences.getPreferences(project, scope);
        return prefService.get(key, defval, prefs);
    }

    public static void set(IProject project, String key, String value) {
        if (IndexerPreferences.getScope(project) == 0) {
            IndexerPreferences.setScope(project, 1);
        }
        Preferences[] prefs = IndexerPreferences.getPreferences(project.getProject());
        prefs[0].put(key, value);
    }

    private static int determineScopeOnFirstUse(IProject project) {
        int scope = 0;
        Preferences prjPrefs = IndexerPreferences.getProjectPreferences(project);
        if (prjPrefs.get(KEY_INDEXER_ID, null) != null) {
            scope = 2;
        }
        IndexerPreferences.getLocalPreferences(project).putInt(KEY_INDEXER_PREFS_SCOPE, scope);
        CCoreInternals.savePreferences(project, false);
        return scope;
    }

    private static Preferences[] getPreferences(IProject project) {
        return IndexerPreferences.getPreferences(project, IndexerPreferences.getScope(project));
    }

    private static Preferences[] getPreferences(IProject project, int scope) {
        if (project != null) {
            switch (scope) {
                case 1: {
                    return new Preferences[]{IndexerPreferences.getLocalPreferences(project)};
                }
                case 2: {
                    return new Preferences[]{IndexerPreferences.getProjectPreferences(project)};
                }
            }
        }
        return IndexerPreferences.getInstancePreferencesArray();
    }

    private static Preferences[] getInstancePreferencesArray() {
        return new Preferences[]{IndexerPreferences.getInstancePreferences(), IndexerPreferences.getConfigurationPreferences(), IndexerPreferences.getDefaultPreferences()};
    }

    private static Preferences getInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(QUALIFIER).node(INDEXER_NODE);
    }

    private static Preferences getConfigurationPreferences() {
        return ConfigurationScope.INSTANCE.getNode(QUALIFIER).node(INDEXER_NODE);
    }

    private static Preferences getDefaultPreferences() {
        return DefaultScope.INSTANCE.getNode(QUALIFIER).node(INDEXER_NODE);
    }

    public static Preferences getProjectPreferences(IProject project) {
        return new ProjectScope(project).getNode(QUALIFIER).node(INDEXER_NODE);
    }

    private static Preferences getLocalPreferences(IProject project) {
        return new LocalProjectScope(project).getNode(QUALIFIER).node(INDEXER_NODE);
    }

    private static void readProperties(Preferences preferences, Properties props) {
        try {
            String[] keys;
            String[] stringArray = keys = preferences.keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String val;
                String key = stringArray[n2];
                if (props.get(key) == null && (val = preferences.get(key, null)) != null) {
                    props.put(key, val);
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void initializeDefaultPreferences(IEclipsePreferences defaultPreferences) {
        Preferences prefs = defaultPreferences.node(INDEXER_NODE);
        prefs.put(KEY_INDEXER_ID, "org.eclipse.cdt.core.fastIndexer");
        prefs.putBoolean(KEY_INDEX_ALL_FILES, true);
        prefs.putBoolean(KEY_INDEX_UNUSED_HEADERS_WITH_DEFAULT_LANG, true);
        prefs.putBoolean(KEY_INDEX_UNUSED_HEADERS_WITH_ALTERNATE_LANG, false);
        prefs.putBoolean(KEY_INDEX_ON_OPEN, false);
        prefs.putBoolean(KEY_INCLUDE_HEURISTICS, true);
        prefs.putInt(KEY_SKIP_FILES_LARGER_THAN_MB, 8);
        prefs.putInt(KEY_SKIP_INCLUDED_FILES_LARGER_THAN_MB, 16);
        prefs.putBoolean(KEY_SKIP_ALL_REFERENCES, false);
        prefs.putBoolean(KEY_SKIP_IMPLICIT_REFERENCES, false);
        prefs.putBoolean(KEY_SKIP_TYPE_REFERENCES, false);
        prefs.putBoolean(KEY_SKIP_MACRO_REFERENCES, false);
        prefs.put(KEY_INDEX_IMPORT_LOCATION, DEFAULT_INDEX_IMPORT_LOCATION);
        prefs.putBoolean(KEY_INDEX_ALL_HEADER_VERSIONS, false);
    }

    public static void setDefaultIndexerId(String defaultId) {
        IndexerPreferences.getDefaultPreferences().put(KEY_INDEXER_ID, defaultId);
    }

    public static void addChangeListener(IProject prj, IEclipsePreferences.IPreferenceChangeListener pcl) {
        Preferences node = IndexerPreferences.getProjectPreferences(prj);
        IndexerPreferences.addListener(node, pcl);
        node = IndexerPreferences.getLocalPreferences(prj);
        IndexerPreferences.addListener(node, pcl);
        node = IndexerPreferences.getInstancePreferences();
        IndexerPreferences.addListener(node, pcl);
    }

    private static void addListener(Preferences node, IEclipsePreferences.IPreferenceChangeListener pcl) {
        if (node instanceof IEclipsePreferences) {
            IEclipsePreferences enode = (IEclipsePreferences)node;
            enode.addPreferenceChangeListener(pcl);
        }
    }

    public static void removeChangeListener(IProject prj, IEclipsePreferences.IPreferenceChangeListener pcl) {
        Preferences node = IndexerPreferences.getProjectPreferences(prj);
        IndexerPreferences.removeListener(node, pcl);
        node = IndexerPreferences.getLocalPreferences(prj);
        IndexerPreferences.removeListener(node, pcl);
        node = IndexerPreferences.getInstancePreferences();
        IndexerPreferences.removeListener(node, pcl);
    }

    private static void removeListener(Preferences node, IEclipsePreferences.IPreferenceChangeListener pcl) {
        if (node instanceof IEclipsePreferences) {
            IEclipsePreferences enode = (IEclipsePreferences)node;
            enode.removePreferenceChangeListener(pcl);
        }
    }

    public static String getIndexImportLocation(IProject project) {
        Preferences[] prefs = project != null ? new Preferences[]{IndexerPreferences.getProjectPreferences(project), IndexerPreferences.getInstancePreferences(), IndexerPreferences.getConfigurationPreferences(), IndexerPreferences.getDefaultPreferences()} : new Preferences[]{IndexerPreferences.getInstancePreferences(), IndexerPreferences.getConfigurationPreferences(), IndexerPreferences.getDefaultPreferences()};
        return Platform.getPreferencesService().get(KEY_INDEX_IMPORT_LOCATION, DEFAULT_INDEX_IMPORT_LOCATION, prefs);
    }

    public static void setIndexImportLocation(IProject project, String location) {
        if (!location.equals(IndexerPreferences.getIndexImportLocation(project))) {
            IndexerPreferences.getProjectPreferences(project).put(KEY_INDEX_IMPORT_LOCATION, location);
        }
    }

    public static int getUpdatePolicy(IProject project) {
        Preferences[] prefs = IndexerPreferences.getInstancePreferencesArray();
        return IndexerPreferences.getUpdatePolicy(prefs);
    }

    private static int getUpdatePolicy(Preferences[] prefs) {
        String val = Platform.getPreferencesService().get(KEY_UPDATE_POLICY, null, prefs);
        if (val != null) {
            try {
                int result = Integer.parseInt(val);
                switch (result) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return result;
                    }
                }
            }
            catch (Exception e) {
                CCorePlugin.log(e);
            }
        }
        return 0;
    }

    public static boolean preferDefaultLanguage(IProject project) {
        Preferences[] prefs;
        IPreferencesService prefService = Platform.getPreferencesService();
        return !Boolean.parseBoolean(prefService.get(KEY_INDEX_UNUSED_HEADERS_WITH_ALTERNATE_LANG, null, prefs = IndexerPreferences.getPreferences(project))) || !Boolean.parseBoolean(prefService.get(KEY_INDEX_ALL_FILES, null, prefs)) || Boolean.parseBoolean(prefService.get(KEY_INDEX_UNUSED_HEADERS_WITH_DEFAULT_LANG, null, prefs));
    }

    public static boolean preferDefaultLanguage(Properties props) {
        return !Boolean.parseBoolean((String)props.get(KEY_INDEX_UNUSED_HEADERS_WITH_ALTERNATE_LANG)) || !Boolean.parseBoolean((String)props.get(KEY_INDEX_ALL_FILES)) || Boolean.parseBoolean((String)props.get(KEY_INDEX_UNUSED_HEADERS_WITH_DEFAULT_LANG));
    }

    public static void setReindexOnConfigChange(IProject project, boolean shouldReindexOnConfigChange) {
        if (shouldReindexOnConfigChange != IndexerPreferences.getReindexOnConfigChange(project)) {
            IndexerPreferences.getProjectPreferences(project).putBoolean(KEY_REINDEX_ON_CONFIG_CHANGE, shouldReindexOnConfigChange);
        }
    }

    public static boolean getReindexOnConfigChange(IProject project) {
        return IndexerPreferences.getProjectPreferences(project).getBoolean(KEY_REINDEX_ON_CONFIG_CHANGE, true);
    }

    public static void setReindexOnIndexerChange(IProject project, boolean shouldReindexOnIndexerChange) {
        if (shouldReindexOnIndexerChange != IndexerPreferences.getReindexOnIndexerChange(project)) {
            IndexerPreferences.getProjectPreferences(project).putBoolean(KEY_REINDEX_ON_INDEXER_CHANGE, shouldReindexOnIndexerChange);
        }
    }

    public static boolean getReindexOnIndexerChange(IProject project) {
        return IndexerPreferences.getProjectPreferences(project).getBoolean(KEY_REINDEX_ON_INDEXER_CHANGE, true);
    }
}

