/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.CTFCallsite;
import org.eclipse.tracecompass.ctf.core.event.CTFClock;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonTraceMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.ClockParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypedefParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.callsite.CallSiteParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.environment.EnvironmentParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event.EventParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream.StreamParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.trace.TraceDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;

public class IOStructGen {
    private final @NonNull CTFTrace fTrace;
    private ICTFMetadataNode fTree;
    private final @NonNull DeclarationScope fRoot;
    private boolean fHasBeenParsed = false;

    public IOStructGen(ICTFMetadataNode tree, @NonNull CTFTrace trace) {
        this.fTrace = trace;
        this.fTree = tree;
        this.fRoot = Objects.requireNonNull(trace.getScope());
    }

    public void generate() throws ParseException {
        this.parseRoot(this.fTree);
    }

    public void generateFragment() throws ParseException {
        this.parseIncompleteRoot(this.fTree);
    }

    public void setTree(ICTFMetadataNode newTree) {
        this.fTree = newTree;
    }

    private void parseRoot(ICTFMetadataNode root) throws ParseException {
        List<ICTFMetadataNode> children = root.getChildren();
        ICTFMetadataNode traceNode = null;
        boolean hasStreams = false;
        ArrayList<ICTFMetadataNode> events = new ArrayList<ICTFMetadataNode>();
        ArrayList<CTFCallsite> callsites = new ArrayList<CTFCallsite>();
        for (ICTFMetadataNode child : children) {
            String type = child.getType();
            if (CTFParser.tokenNames[89].equals(type)) {
                this.parseRootDeclaration(child);
                continue;
            }
            if (CTFParser.tokenNames[110].equals(type) || "trace-class".equals(type)) {
                JsonTraceMetadataNode node;
                JsonObject environment;
                if (traceNode != null) {
                    throw new ParseException("Only one trace block is allowed");
                }
                traceNode = child;
                if (child instanceof JsonTraceMetadataNode && (environment = (node = (JsonTraceMetadataNode)child).getEnvironment()) != null) {
                    LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
                    for (Map.Entry entry : environment.entrySet()) {
                        JsonElement value = (JsonElement)entry.getValue();
                        if (value.isJsonPrimitive()) {
                            env.put((String)entry.getKey(), value.getAsString());
                            continue;
                        }
                        env.put((String)entry.getKey(), value.toString());
                    }
                    this.fTrace.setEnvironment(env);
                }
                this.parseTrace(traceNode);
                continue;
            }
            if (CTFParser.tokenNames[104].equals(type) || "data-stream-class".equals(type)) {
                StreamParser.INSTANCE.parse(child, new StreamParser.Param(this.fTrace, this.fRoot));
                hasStreams = true;
                continue;
            }
            if (CTFParser.tokenNames[99].equals(type) || "event-record-class".equals(type)) {
                events.add(child);
                continue;
            }
            if (CTFParser.tokenNames[84].equals(type) || "clock-class".equals(type)) {
                CTFClock ctfClock = ClockParser.INSTANCE.parse(child, null);
                String nameValue = ctfClock.getName();
                this.fTrace.addClock(nameValue, ctfClock);
                continue;
            }
            if (CTFParser.tokenNames[98].equals(type)) {
                this.fTrace.setEnvironment((Map<String, String>)EnvironmentParser.INSTANCE.parse(child, null));
                continue;
            }
            if (CTFParser.tokenNames[83].equals(type)) {
                callsites.add(CallSiteParser.INSTANCE.parse(child, null));
                continue;
            }
            if ("preamble".equals(type) || "field-class-alias".equals(type)) continue;
            throw IOStructGen.childTypeError(child);
        }
        if (traceNode == null) {
            throw new ParseException("Missing trace block");
        }
        this.parseEvents(events, callsites, hasStreams);
        this.fHasBeenParsed = true;
    }

    private void parseEvents(List<ICTFMetadataNode> events, Collection<CTFCallsite> staticCallsites, boolean hasStreams) throws ParseException {
        if (!hasStreams && !events.isEmpty()) {
            this.fTrace.addStream(new CTFStream(this.fTrace));
        }
        for (ICTFMetadataNode event : events) {
            EventDeclaration ev = EventParser.INSTANCE.parse(event, new EventParser.Param(this.fTrace, this.fRoot));
            List<CTFCallsite> callsites = staticCallsites.stream().filter(cs -> ev.getName().equals(cs.getEventName())).collect(Collectors.toList());
            ev.addCallsites(callsites);
        }
    }

    private void parseIncompleteRoot(ICTFMetadataNode root) throws ParseException {
        if (!this.fHasBeenParsed) {
            throw new ParseException("You need to run generate first");
        }
        List<ICTFMetadataNode> children = root.getChildren();
        ArrayList<ICTFMetadataNode> events = new ArrayList<ICTFMetadataNode>();
        ArrayList<CTFCallsite> callsites = new ArrayList<CTFCallsite>();
        Iterator<ICTFMetadataNode> iterator = children.iterator();
        if (iterator.hasNext()) {
            ICTFMetadataNode child = iterator.next();
            String type = child.getType();
            if (CTFParser.tokenNames[89].equals(type)) {
                this.parseRootDeclaration(child);
            } else {
                if (CTFParser.tokenNames[110].equals(type)) {
                    throw new ParseException("Trace block defined here, please use generate and not generateFragment to parse this fragment");
                }
                if (CTFParser.tokenNames[104].equals(type)) {
                    StreamParser.INSTANCE.parse(child, new StreamParser.Param(this.fTrace, this.fRoot));
                } else if (CTFParser.tokenNames[99].equals(type)) {
                    events.add(child);
                } else if (CTFParser.tokenNames[84].equals(type)) {
                    CTFClock ctfClock = ClockParser.INSTANCE.parse(child, null);
                    String nameValue = ctfClock.getName();
                    this.fTrace.addClock(nameValue, ctfClock);
                } else if (CTFParser.tokenNames[98].equals(type)) {
                    this.fTrace.setEnvironment((Map<String, String>)EnvironmentParser.INSTANCE.parse(child, null));
                } else if (CTFParser.tokenNames[83].equals(type)) {
                    callsites.add(CallSiteParser.INSTANCE.parse(child, null));
                } else {
                    throw IOStructGen.childTypeError(child);
                }
            }
        }
        this.parseEvents(events, callsites, !Iterables.isEmpty(this.fTrace.getStreams()));
    }

    private void parseTrace(ICTFMetadataNode traceNode) throws ParseException {
        CTFTrace trace = this.fTrace;
        List<ICTFMetadataNode> children = traceNode.getChildren();
        if (children == null) {
            throw new ParseException("Trace block is empty");
        }
        for (ICTFMetadataNode child : children) {
            String type = child.getType();
            if (CTFParser.tokenNames[111].equals(type)) {
                TypeAliasParser.INSTANCE.parse(child, new TypeAliasParser.Param(trace, this.fRoot));
                continue;
            }
            if (child instanceof JsonStructureFieldMetadataNode) {
                IDeclaration packetHeaderDecl = TypeSpecifierListParser.INSTANCE.parse(child, new TypeSpecifierListParser.Param(this.fTrace, null, null, this.fRoot));
                trace.setPacketHeader((StructDeclaration)packetHeaderDecl);
                continue;
            }
            if (CTFParser.tokenNames[114].equals(type)) {
                TypedefParser.INSTANCE.parse(child, new TypedefParser.Param(trace, this.fRoot));
                continue;
            }
            if (CTFParser.tokenNames[85].equals(type) || CTFParser.tokenNames[86].equals(type)) {
                TraceDeclarationParser.INSTANCE.parse(child, new TraceDeclarationParser.Param(this.fTrace, this.fRoot));
                continue;
            }
            throw IOStructGen.childTypeError(child);
        }
        if (traceNode instanceof CTFAntlrMetadataNode && this.fTrace.getByteOrder() == null) {
            throw new ParseException("Trace byte order not set");
        }
    }

    private void parseRootDeclaration(ICTFMetadataNode declaration) throws ParseException {
        List<ICTFMetadataNode> children = declaration.getChildren();
        for (ICTFMetadataNode child : children) {
            String type = child.getType();
            if (CTFParser.tokenNames[114].equals(type)) {
                TypedefParser.INSTANCE.parse(child, new TypedefParser.Param(this.fTrace, this.fRoot));
                continue;
            }
            if (CTFParser.tokenNames[111].equals(type)) {
                TypeAliasParser.INSTANCE.parse(child, new TypeAliasParser.Param(this.fTrace, this.fRoot));
                continue;
            }
            if (CTFParser.tokenNames[117].equals(type)) {
                TypeSpecifierListParser.INSTANCE.parse(child, new TypeSpecifierListParser.Param(this.fTrace, null, null, this.fRoot));
                continue;
            }
            throw IOStructGen.childTypeError(child);
        }
    }

    private static ParseException childTypeError(ICTFMetadataNode child) {
        ICTFMetadataNode parent = child.getParent();
        String error = "Parent " + parent.getType() + " can't have a child of type " + child.getType() + ".";
        return new ParseException(error);
    }
}

