/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.old;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.old.RocmCallStackStateProvider;
import org.eclipse.tracecompass.incubator.rocm.core.trace.old.RocmTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class RocmMetadataStateProvider
extends AbstractTmfStateProvider {
    private static final String ID = "org.eclipse.tracecompass.incubator.rocm.core.stateprovider.functionname";
    public static final String FUNCTION_NAMES = "Function Names";

    public RocmMetadataStateProvider(@NonNull ITmfTrace trace) {
        super(trace, ID);
    }

    public int getVersion() {
        return 1;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new RocmCallStackStateProvider(this.getTrace());
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        if (event.getName().endsWith("function_name")) {
            ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
            if (ssb == null) {
                return;
            }
            int functionNameQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{FUNCTION_NAMES});
            int apiQuark = ssb.getQuarkRelativeAndAdd(functionNameQuark, new String[]{Integer.valueOf(((RocmTrace)event.getTrace()).getApiId(event.getName().split("_")[0] + "_api")).toString()});
            String functionName = (String)event.getContent().getFieldValue(String.class, new String[]{"name"});
            Integer cid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"correlation_id"});
            if (functionName == null || cid == null) {
                return;
            }
            ssb.modifyAttribute(ssb.getStartTime() + (long)cid.intValue(), (Object)functionName, apiQuark);
        }
    }

    public static int getFunctionId(@NonNull ITmfEvent event) {
        int nApi = ((RocmTrace)event.getTrace()).getNApi();
        Integer cid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"cid"});
        if (cid == null) {
            cid = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"correlation_id"});
        }
        if (cid == null) {
            return -1;
        }
        int apiId = event.getName().endsWith("function_name") ? ((RocmTrace)event.getTrace()).getApiId(event.getName().split("_")[0] + "_api") : ((RocmTrace)event.getTrace()).getApiId(event.getName());
        return cid * nApi + apiId;
    }
}

