/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.rocm.core.trace.old;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.rocm.core.trace.GpuAspect;
import org.eclipse.tracecompass.incubator.rocm.core.trace.RocmAspects;
import org.eclipse.tracecompass.incubator.rocm.core.trace.RocmCounterAspect;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class RocmTrace
extends CtfTmfTrace {
    private static final @NonNull Collection<@NonNull ITmfEventAspect<?>> ROCM_CTF_ASPECTS = ImmutableList.of((Object)TmfBaseAspects.getTimestampAspect(), (Object)TmfBaseAspects.getEventTypeAspect(), (Object)TmfBaseAspects.getContentsAspect(), (Object)TmfBaseAspects.getTraceNameAspect());
    private @NonNull Collection<ITmfEventAspect<?>> fAspects = ImmutableSet.copyOf(ROCM_CTF_ASPECTS);
    private static final int CONFIDENCE = 100;
    private static final int REDUCTION_FACTOR = 4096;
    private static final int VERSION = 1;
    private Map<String, Integer> fApiMap;

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return this.fAspects;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
        this.initializeApiMap();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)GpuAspect.INSTANCE);
        builder.addAll(RocmTrace.createRocmAspects((ITmfTraceWithPreDefinedEvents)this));
        builder.addAll(ROCM_CTF_ASPECTS);
        builder.addAll(this.createCounterAspects((ITmfTraceWithPreDefinedEvents)this));
        this.fAspects = builder.build();
    }

    public int getApiId(String apiName) {
        return this.fApiMap.getOrDefault(apiName, -1);
    }

    public int getNApi() {
        return this.fApiMap.size();
    }

    private void initializeApiMap() {
        this.fApiMap = new HashMap<String, Integer>();
        for (ITmfEventType eventType : this.getContainedEventTypes()) {
            if (!eventType.getName().endsWith("_api")) continue;
            this.fApiMap.put(eventType.getName(), this.fApiMap.size());
        }
    }

    private static Collection<ITmfEventAspect<?>> createRocmAspects(ITmfTraceWithPreDefinedEvents trace) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ITmfEventType eventType : trace.getContainedEventTypes()) {
            if (eventType.getName().equals("hsa_api")) {
                builder.add(RocmAspects.getQueueIDAspect());
                builder.add(RocmAspects.getQueueIndexAspect());
            }
            if (!eventType.getName().equals("hip_api")) continue;
            builder.add(RocmAspects.getStreamIDAspect());
        }
        builder.add(RocmAspects.getPIDAspect());
        builder.add(RocmAspects.getTIDAspect());
        builder.add(RocmAspects.getFunctionNameAspect());
        return builder.build();
    }

    private Collection<ITmfEventAspect<?>> createCounterAspects(ITmfTraceWithPreDefinedEvents trace) {
        ImmutableSet.Builder perfBuilder = new ImmutableSet.Builder();
        ITmfContext context = this.seekEvent((ITmfLocation)new CtfLocation(new CtfLocationInfo(0L, 0L)));
        Map environment = this.getEnvironment();
        int traceSize = 0;
        if (environment != null) {
            traceSize = Integer.parseInt((String)environment.get("nb_events"));
        }
        int nEventsToRead = Integer.min(traceSize, 10000);
        block0: for (ITmfEventType eventType : trace.getContainedEventTypes()) {
            if (!eventType.getName().equals("metric_name")) continue;
            int i = 0;
            while (i < nEventsToRead) {
                CtfTmfEvent event = this.getNext(context);
                if (event.getName().equals("metric_name_end")) break block0;
                if (event.getName().equals("metric_name")) {
                    RocmTrace.buildCounterAspectsFromEvent(perfBuilder, (ITmfEvent)event);
                }
                ++i;
            }
            break block0;
        }
        return perfBuilder.build();
    }

    private static void buildCounterAspectsFromEvent(ImmutableSet.Builder<ITmfEventAspect<?>> builder, ITmfEvent event) {
        String fieldName = (String)event.getContent().getFieldValue(String.class, new String[]{"name"});
        if (fieldName != null) {
            Integer id = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{"id"});
            builder.add((Object)new RocmCounterAspect(fieldName, fieldName, GpuAspect.class, id));
        }
    }

    public int size() {
        String size;
        Map environment = this.getEnvironment();
        if (environment != null && (size = (String)environment.get("nb_events")) != null) {
            return (int)(Long.parseLong(size) / 4096L);
        }
        return super.size();
    }

    public @Nullable IStatus validate(@Nullable IProject project, @Nullable String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Map environment = ((CtfTraceValidationStatus)status).getEnvironment();
            String domain = (String)environment.get("tracer_name");
            if (domain == null || !domain.equals("\"rocprof\"")) {
                return new Status(4, "org.eclipse.tracecompass.incubator.rocm.core", "This trace was not recognized as a ROCm trace. You can update your rocprofiler version or you can change manually the tracer name to \"rocprof\" in the metadata file to force the validation.");
            }
            int tracerMajor = Integer.parseInt((String)environment.get("plugin_major"));
            int tracerMinor = Integer.parseInt((String)environment.get("plugin_minor"));
            return RocmTrace.checkVersion(tracerMajor, tracerMinor);
        }
        return status;
    }

    private static IStatus checkVersion(int tracerMajor, int tracerMinor) {
        if (tracerMajor < 1) {
            return new Status(4, "org.eclipse.tracecompass.incubator.rocm.core", "The tracer version is " + tracerMajor + "." + tracerMinor + " and this version of the ROCm plugin supports only tracer with versions > 3.0");
        }
        if (tracerMajor > 1) {
            return new Status(4, "org.eclipse.tracecompass.incubator.rocm.core", "The ROCm plugin version needs to be updated to support this new version of rocprofiler.");
        }
        return new TraceValidationStatus(100, "org.eclipse.tracecompass.incubator.rocm.core");
    }

    public TmfTraceContext createTraceContext(TmfTimeRange selection, TmfTimeRange windowRange, @Nullable IFile editorFile, @Nullable ITmfFilter filter) {
        return new TmfTraceContext(selection, windowRange, editorFile, filter);
    }
}

