/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.mpi;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;

public class MessageIdentifiers {
    private static final long UNKNOWN_TIMESTAMP = -1L;
    private final int fCommunicator;
    private final int fSrcRank;
    private final int fDestRank;
    private final int fMessageTag;
    private final long fBeginTimestamp;

    public MessageIdentifiers(int communicator, int srcRank, int destRank, int messageTag, long beginTimestamp) {
        this.fCommunicator = communicator;
        this.fSrcRank = srcRank;
        this.fDestRank = destRank;
        this.fMessageTag = messageTag;
        this.fBeginTimestamp = beginTimestamp;
    }

    public MessageIdentifiers(int communicator, int srcRank, int destRank, int messageTag) {
        this(communicator, srcRank, destRank, messageTag, -1L);
    }

    public int hashCode() {
        return Objects.hash(this.fCommunicator, this.fSrcRank, this.fDestRank, this.fMessageTag, this.fBeginTimestamp);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        MessageIdentifiers that = (MessageIdentifiers)other;
        return this.fCommunicator == that.fCommunicator && this.fSrcRank == that.fSrcRank && this.fDestRank == that.fDestRank && this.fMessageTag == that.fMessageTag;
    }

    public long getBeginTimestamp() {
        return this.fBeginTimestamp;
    }
}

