/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class MoveDescriptor
extends JavaScriptRefactoringDescriptor {
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_FILES = "files";
    private static final String ATTRIBUTE_FOLDERS = "folders";
    private static final String ATTRIBUTE_FRAGMENTS = "fragments";
    private static final String ATTRIBUTE_MEMBERS = "members";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_POLICY = "policy";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_ROOTS = "roots";
    private static final String ATTRIBUTE_TARGET = "target";
    private static final String ATTRIBUTE_UNITS = "units";
    private static final String POLICY_MOVE_MEMBERS = "org.eclipse.wst.jsdt.ui.moveMembers";
    private static final String POLICY_MOVE_PACKAGES = "org.eclipse.wst.jsdt.ui.movePackages";
    private static final String POLICY_MOVE_RESOURCES = "org.eclipse.wst.jsdt.ui.moveResources";
    private static final String POLICY_MOVE_ROOTS = "org.eclipse.wst.jsdt.ui.moveRoots";
    private Object fDestination;
    private IFile[] fFiles;
    private IFolder[] fFolders;
    private IPackageFragment[] fFragments;
    private IMember[] fMembers;
    private String fMovePolicy = null;
    private String fPatterns = null;
    private boolean fQualified = false;
    private boolean fReferences = false;
    private IPackageFragmentRoot[] fRoots;
    private IJavaScriptUnit[] fUnits;

    public MoveDescriptor() {
        super("org.eclipse.wst.jsdt.ui.move");
    }

    @Override
    protected void populateArgumentMap() {
        block11: {
            String project;
            block13: {
                block12: {
                    block10: {
                        super.populateArgumentMap();
                        this.fArguments.put(ATTRIBUTE_POLICY, this.fMovePolicy);
                        project = this.getProject();
                        if (this.fDestination instanceof IJavaScriptElement) {
                            this.fArguments.put(ATTRIBUTE_DESTINATION, JavaScriptRefactoringDescriptor.elementToHandle(project, (IJavaScriptElement)this.fDestination));
                        } else if (this.fDestination instanceof IResource) {
                            this.fArguments.put(ATTRIBUTE_TARGET, JavaScriptRefactoringDescriptor.resourceToHandle(null, (IResource)this.fDestination));
                        }
                        if (!POLICY_MOVE_RESOURCES.equals(this.fMovePolicy)) break block10;
                        this.fArguments.put("references", Boolean.toString(this.fReferences));
                        this.fArguments.put(ATTRIBUTE_QUALIFIED, Boolean.toString(this.fQualified));
                        if (this.fPatterns != null && !"".equals(this.fPatterns)) {
                            this.fArguments.put(ATTRIBUTE_PATTERNS, this.fPatterns);
                        }
                        this.fArguments.put(ATTRIBUTE_FILES, Integer.valueOf(this.fFiles.length).toString());
                        int offset = 0;
                        while (offset < this.fFiles.length) {
                            this.fArguments.put("element" + (offset + 1), JavaScriptRefactoringDescriptor.resourceToHandle(project, (IResource)this.fFiles[offset]));
                            ++offset;
                        }
                        this.fArguments.put(ATTRIBUTE_FOLDERS, Integer.valueOf(this.fFolders.length).toString());
                        offset = 0;
                        while (offset < this.fFolders.length) {
                            this.fArguments.put("element" + (offset + this.fFiles.length + 1), JavaScriptRefactoringDescriptor.resourceToHandle(project, (IResource)this.fFolders[offset]));
                            ++offset;
                        }
                        this.fArguments.put(ATTRIBUTE_UNITS, Integer.valueOf(this.fUnits.length).toString());
                        offset = 0;
                        while (offset < this.fUnits.length) {
                            this.fArguments.put("element" + (offset + this.fFolders.length + this.fFiles.length + 1), JavaScriptRefactoringDescriptor.elementToHandle(project, (IJavaScriptElement)this.fUnits[offset]));
                            ++offset;
                        }
                        break block11;
                    }
                    if (!POLICY_MOVE_ROOTS.equals(this.fMovePolicy)) break block12;
                    this.fArguments.put(ATTRIBUTE_ROOTS, Integer.valueOf(this.fRoots.length).toString());
                    int offset = 0;
                    while (offset < this.fRoots.length) {
                        this.fArguments.put("element" + (offset + 1), JavaScriptRefactoringDescriptor.elementToHandle(project, (IJavaScriptElement)this.fRoots[offset]));
                        ++offset;
                    }
                    break block11;
                }
                if (!POLICY_MOVE_PACKAGES.equals(this.fMovePolicy)) break block13;
                this.fArguments.put(ATTRIBUTE_FRAGMENTS, Integer.valueOf(this.fFragments.length).toString());
                int offset = 0;
                while (offset < this.fFragments.length) {
                    this.fArguments.put("element" + (offset + 1), JavaScriptRefactoringDescriptor.elementToHandle(project, (IJavaScriptElement)this.fFragments[offset]));
                    ++offset;
                }
                break block11;
            }
            if (!POLICY_MOVE_MEMBERS.equals(this.fMovePolicy)) break block11;
            this.fArguments.put(ATTRIBUTE_MEMBERS, Integer.valueOf(this.fMembers.length).toString());
            int offset = 0;
            while (offset < this.fMembers.length) {
                this.fArguments.put("element" + (offset + 1), JavaScriptRefactoringDescriptor.elementToHandle(project, (IJavaScriptElement)this.fMembers[offset]));
                ++offset;
            }
        }
    }

    public void setDestination(IJavaScriptElement element) {
        Assert.isNotNull((Object)element);
        this.fDestination = element;
    }

    public void setDestination(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.fDestination = resource;
    }

    public void setFileNamePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        Assert.isLegal((!"".equals(patterns) ? 1 : 0) != 0, (String)"Pattern must not be empty");
        this.fPatterns = patterns;
    }

    public void setMoveMembers(IMember[] members) {
        Assert.isNotNull((Object)members);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fMembers = members;
        this.fMovePolicy = POLICY_MOVE_MEMBERS;
    }

    public void setMovePackageFragmentRoots(IPackageFragmentRoot[] roots) {
        Assert.isNotNull((Object)roots);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fRoots = roots;
        this.fMovePolicy = POLICY_MOVE_ROOTS;
    }

    public void setMovePackages(IPackageFragment[] fragments) {
        Assert.isNotNull((Object)fragments);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fFragments = fragments;
        this.fMovePolicy = POLICY_MOVE_PACKAGES;
    }

    public void setMoveResources(IFile[] files, IFolder[] folders, IJavaScriptUnit[] units) {
        Assert.isNotNull((Object)files);
        Assert.isNotNull((Object)folders);
        Assert.isNotNull((Object)units);
        Assert.isTrue((this.fMovePolicy == null ? 1 : 0) != 0, (String)"Clients must only call one of the 'setMoveXXX' methods.");
        this.fFiles = files;
        this.fFolders = folders;
        this.fUnits = units;
        this.fMovePolicy = POLICY_MOVE_RESOURCES;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fQualified = update;
    }

    public void setUpdateReferences(boolean update) {
        this.fReferences = update;
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (!status.hasFatalError()) {
            if (this.fMovePolicy == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveDescriptor_no_elements_set));
            }
            if (this.fDestination == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveDescriptor_no_destination_set));
            }
        }
        return status;
    }
}

