/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.backend;

import java.util.ArrayList;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.backend.StateHistoryBackendTestBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class InMemoryBackendTest
extends StateHistoryBackendTestBase {
    private static final String SSID = "test-ss";
    private static final int NUMBER_OF_ATTRIBUTES = 10;
    private static @Nullable IStateHistoryBackend fixture;

    @BeforeClass
    public static void init() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)SSID, (long)0L);
        int attribute = 0;
        while (attribute < 10) {
            int timeStart = 0;
            while (timeStart < 1000) {
                try {
                    int stateEndTime = timeStart * 100 + 90 + attribute;
                    int stateStartTime = timeStart * 100 + attribute;
                    backend.insertPastState((long)stateStartTime, (long)stateEndTime, attribute, (Object)(timeStart % 100));
                    if (timeStart != 999) {
                        backend.insertPastState((long)(stateEndTime + 1), (long)(stateEndTime + 9), attribute, null);
                    }
                }
                catch (TimeRangeException e) {
                    throw new IllegalStateException();
                }
                ++timeStart;
            }
            ++attribute;
        }
        fixture = backend;
    }

    private static void testInterval(@Nullable ITmfStateInterval interval, int startTime, int endTime, int value) {
        Assert.assertNotNull((Object)interval);
        Assert.assertEquals((long)startTime, (long)interval.getStartTime());
        Assert.assertEquals((long)endTime, (long)interval.getEndTime());
        try {
            Assert.assertEquals((long)value, (long)interval.getStateValue().unboxInt());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Override
    protected IStateHistoryBackend getBackendForBuilding(long startTime) {
        return StateHistoryBackendFactory.createInMemoryBackend((String)SSID, (long)startTime);
    }

    @Test
    public void testStartTime() {
        IStateHistoryBackend backend = fixture;
        Assert.assertNotNull((Object)backend);
        Assert.assertEquals((long)0L, (long)backend.getStartTime());
    }

    @Test
    public void testEndTime() {
        IStateHistoryBackend backend = fixture;
        Assert.assertNotNull((Object)backend);
        Assert.assertEquals((long)99999L, (long)backend.getEndTime());
    }

    @Test
    public void testDoQuery() {
        ArrayList<@Nullable E> interval = new ArrayList(10);
        int i = 0;
        while (i < 10) {
            interval.add(null);
            ++i;
        }
        IStateHistoryBackend backend = fixture;
        Assert.assertNotNull((Object)backend);
        try {
            backend.doQuery(interval, 950L);
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)10L, (long)interval.size());
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(0), 900, 990, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(1), 901, 991, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(2), 902, 992, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(3), 903, 993, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(4), 904, 994, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(5), 905, 995, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(6), 906, 996, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(7), 907, 997, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(8), 908, 998, 9);
        InMemoryBackendTest.testInterval((ITmfStateInterval)interval.get(9), 909, 999, 9);
    }

    @Test
    public void testQueryAttribute() {
        try {
            IStateHistoryBackend backend = fixture;
            Assert.assertNotNull((Object)backend);
            Object[] interval = new TmfStateInterval[10];
            int i = 0;
            while (i < 10) {
                interval[i] = backend.doSingularQuery(950L, i);
                ++i;
            }
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[0], 900, 990, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[1], 901, 991, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[2], 902, 992, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[3], 903, 993, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[4], 904, 994, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[5], 905, 995, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[6], 906, 996, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[7], 907, 997, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[8], 908, 998, 9);
            InMemoryBackendTest.testInterval((ITmfStateInterval)interval[9], 909, 999, 9);
            ArrayList<@Nullable E> intervalQuery = new ArrayList(10);
            int i2 = 0;
            while (i2 < 10) {
                intervalQuery.add(null);
                ++i2;
            }
            backend.doQuery(intervalQuery, 950L);
            Object[] ref = intervalQuery.toArray(new ITmfStateInterval[0]);
            Assert.assertArrayEquals((Object[])ref, (Object[])interval);
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryAttributeEmpty() {
        try {
            IStateHistoryBackend backend = fixture;
            Assert.assertNotNull((Object)backend);
            ITmfStateInterval interval = backend.doSingularQuery(999L, 0);
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)interval.getStateValue());
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBegin() {
        try {
            IStateHistoryBackend backend = fixture;
            Assert.assertNotNull((Object)backend);
            ITmfStateInterval interval = backend.doSingularQuery(0L, 0);
            Assert.assertEquals((long)0L, (long)interval.getStartTime());
            Assert.assertEquals((long)90L, (long)interval.getEndTime());
            Assert.assertEquals((long)0L, (long)interval.getStateValue().unboxInt());
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testEnd() {
        try {
            IStateHistoryBackend backend = fixture;
            Assert.assertNotNull((Object)backend);
            ITmfStateInterval interval = backend.doSingularQuery(99998L, 9);
            InMemoryBackendTest.testInterval(interval, 99909, 99999, 99);
        }
        catch (StateSystemDisposedException | TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=TimeRangeException.class)
    public void testOutOfRange_1() throws TimeRangeException {
        try {
            IStateHistoryBackend backend = fixture;
            Assert.assertNotNull((Object)backend);
            ITmfStateInterval interval = backend.doSingularQuery(-1L, 0);
            Assert.assertNull((Object)interval);
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=TimeRangeException.class)
    public void testOutOfRange_2() throws TimeRangeException {
        try {
            IStateHistoryBackend backend = fixture;
            Assert.assertNotNull((Object)backend);
            ITmfStateInterval interval = backend.doSingularQuery(100000L, 0);
            Assert.assertNull((Object)interval);
        }
        catch (StateSystemDisposedException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

