/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.wizards.Messages;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class TrimTraceDialog
extends SelectionStatusDialog {
    private Text fNewElementName;
    private final TmfCommonProjectElement fElement;
    private String fResult;

    public TrimTraceDialog(Shell shell, TmfCommonProjectElement element) {
        this(shell, element, Messages.TrimTraceDialog_ExportTrimmedTrace);
    }

    public TrimTraceDialog(Shell shell, TmfCommonProjectElement element, String title) {
        super(shell);
        this.setTitle(title);
        this.fElement = element;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createNewTraceNameGroup(composite);
        return composite;
    }

    private void createNewTraceNameGroup(Composite parent) {
        this.setStatusLineAboveButtons(true);
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        String name = this.fElement.getName();
        Label newTaceLabel = new Label(folderGroup, 0);
        newTaceLabel.setFont(font);
        newTaceLabel.setText(Messages.RenameTraceDialog_TraceNewName);
        GridData data = new GridData(768);
        data.widthHint = 200;
        Text newElementName = new Text(folderGroup, 2048);
        newElementName.setLayoutData((Object)data);
        newElementName.setFont(font);
        newElementName.setFocus();
        newElementName.setText(name);
        newElementName.setSelection(0, name.length());
        newElementName.addListener(24, event -> this.validateNewTraceName());
        this.fNewElementName = newElementName;
        this.validateNewTraceName();
    }

    private void validateNewTraceName() {
        Path traceDestinationPath;
        IFolder tracesFolder;
        String newTraceName = this.fNewElementName.getText();
        TmfCommonProjectElement element = this.fElement;
        IWorkspace workspace = element.getResource().getWorkspace();
        IStatus nameStatus = workspace.validateName(newTraceName, 2);
        if ("".equals(newTraceName)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_EmptyNameError, null));
            return;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return;
        }
        IContainer parentFolder = element.getResource().getParent();
        if (parentFolder.findMember(newTraceName) != null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        TmfTraceFolder tracesFolderElement = element.getProject().getTracesFolder();
        if (tracesFolderElement != null && (tracesFolder = tracesFolderElement.getResource()).getFolder((IPath)(traceDestinationPath = new Path(newTraceName))).exists()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.tracecompass.tmf.ui", ""));
    }

    protected void computeResult() {
    }

    protected void okPressed() {
        this.fResult = this.fNewElementName.getText();
        super.okPressed();
    }

    public Object[] getResult() {
        String result = this.fResult;
        if (result != null) {
            return new String[]{result};
        }
        return new String[0];
    }
}

