/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.tests.historytree.HTNodeTest;
import org.eclipse.tracecompass.datastore.core.tests.historytree.HtTestUtils;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.HistoryTreeStub;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.classic.ClassicHistoryTreeStub;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.overlapping.OverlappingHistoryTreeStub;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.HTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HTCoreNodeTest<E extends IHTInterval, N extends HTNode<E>>
extends HTNodeTest<E, N> {
    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Core node", 46, HistoryTreeStub.NODE_FACTORY, HtTestUtils.READ_FACTORY, HTNodeTest.BASE_OBJ_FACTORY}, {"Classic core node", 70, ClassicHistoryTreeStub.CLASSIC_NODE_FACTORY, HtTestUtils.READ_FACTORY, HTNodeTest.BASE_OBJ_FACTORY}, {"Overlapping core node", 94, OverlappingHistoryTreeStub.OVERLAPPING_NODE_FACTORY, HtTestUtils.READ_FACTORY, HTNodeTest.BASE_OBJ_FACTORY});
    }

    public HTCoreNodeTest(String name, int headerSize, AbstractHistoryTree.IHTNodeFactory<E, N> factory, IHTIntervalReader<E> readFactory, HTNodeTest.ObjectFactory<E> objFactory) throws IOException {
        super(name, headerSize, IHTNode.NodeType.CORE, factory, readFactory, objFactory);
    }

    @Test
    public void testGetChild2() {
        long start = 10L;
        Object node = this.newNode(0, -1, 10L);
        Assert.assertEquals((long)0L, (long)node.getNbChildren());
        Object childNode = this.newNode(1, 0, start);
        node.linkNewChild(childNode);
        Assert.assertEquals((long)1L, (long)node.getNbChildren());
        Assert.assertEquals((long)childNode.getSequenceNumber(), (long)node.getChild(0));
        Object childNode2 = this.newNode(2, 0, start);
        node.linkNewChild(childNode2);
        Assert.assertEquals((long)2L, (long)node.getNbChildren());
        Assert.assertEquals((long)childNode.getSequenceNumber(), (long)node.getChild(0));
        Assert.assertEquals((long)childNode2.getSequenceNumber(), (long)node.getChild(1));
        Object childNode3 = this.newNode(10, 0, start);
        node.linkNewChild(childNode3);
        Assert.assertEquals((long)3L, (long)node.getNbChildren());
        Assert.assertEquals((long)childNode.getSequenceNumber(), (long)node.getChild(0));
        Assert.assertEquals((long)childNode2.getSequenceNumber(), (long)node.getChild(1));
        Assert.assertEquals((long)childNode3.getSequenceNumber(), (long)node.getChild(2));
    }

    @Override
    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetLatestChild() {
        super.testGetLatestChild();
    }

    @Test
    public void testGetLatestChild2() {
        long start = 10L;
        Object node = this.newNode(0, -1, 10L);
        Assert.assertEquals((long)0L, (long)node.getNbChildren());
        Object childNode = this.newNode(1, 0, start);
        node.linkNewChild(childNode);
        Assert.assertEquals((long)1L, (long)node.getNbChildren());
        Assert.assertEquals((long)childNode.getSequenceNumber(), (long)node.getLatestChild());
        Object childNode2 = this.newNode(2, 0, start);
        node.linkNewChild(childNode2);
        Assert.assertEquals((long)2L, (long)node.getNbChildren());
        Assert.assertEquals((long)childNode2.getSequenceNumber(), (long)node.getLatestChild());
        Object childNode3 = this.newNode(10, 0, start);
        node.linkNewChild(childNode3);
        Assert.assertEquals((long)3L, (long)node.getNbChildren());
        Assert.assertEquals((long)childNode3.getSequenceNumber(), (long)node.getLatestChild());
    }

    @Override
    @Test
    public void testLinkNewChild() throws IOException {
        Object object = this.createObject(10L, 11L);
        long time = 10L;
        int nbObjects = (4096 - this.getHeaderSize()) / object.getSizeOnDisk();
        Object node = this.newNode(0, -1, time);
        this.fillNode(node, nbObjects, time);
        Object childNode = this.newNode(1, 0, time);
        this.fillNode(childNode, nbObjects, time);
        node.linkNewChild(childNode);
        Assert.assertEquals((long)0L, (long)childNode.getNbChildren());
        Assert.assertEquals((long)1L, (long)node.getNbChildren());
        time = time + (long)nbObjects + 1L;
        childNode.closeThisNode(time);
        Object childNode2 = this.newNode(2, 0, time);
        this.fillNode(childNode2, nbObjects, time);
        node.linkNewChild(childNode2);
        Assert.assertEquals((long)0L, (long)childNode2.getNbChildren());
        Assert.assertEquals((long)2L, (long)node.getNbChildren());
        time = time + (long)nbObjects + 1L;
        childNode2.closeThisNode(time);
        Object childNode3 = this.newNode(3, 0, time);
        this.fillNode(childNode3, nbObjects, time);
        node.linkNewChild(childNode3);
        Assert.assertEquals((long)0L, (long)childNode3.getNbChildren());
        Assert.assertEquals((long)3L, (long)node.getNbChildren());
        time = time + (long)nbObjects + 1L;
        Object noPlace = this.newNode(4, 0, time);
        IllegalStateException exception = null;
        try {
            node.linkNewChild(noPlace);
        }
        catch (IllegalStateException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)exception);
        childNode3.closeThisNode(time);
        node.closeThisNode(time);
        this.write(node);
        this.write(childNode);
        this.write(childNode2);
        this.write(childNode3);
        Assert.assertTrue((boolean)node.isOnDisk());
        Assert.assertTrue((boolean)childNode.isOnDisk());
        Assert.assertTrue((boolean)childNode2.isOnDisk());
        Assert.assertTrue((boolean)childNode3.isOnDisk());
        HTNode readNode = this.read(0);
        HTNode readChildNode = this.read(1);
        HTNode readChildNode2 = this.read(2);
        HTNode readChildNode3 = this.read(3);
        Assert.assertTrue((boolean)readNode.isOnDisk());
        Assert.assertEquals(node, readNode);
        Assert.assertTrue((boolean)readChildNode.isOnDisk());
        Assert.assertEquals(childNode, readChildNode);
        Assert.assertTrue((boolean)readChildNode2.isOnDisk());
        Assert.assertEquals(childNode2, readChildNode2);
        Assert.assertTrue((boolean)readChildNode3.isOnDisk());
        Assert.assertEquals(childNode3, readChildNode3);
    }
}

