/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree;

import java.util.Comparator;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;

public class TmfVertex
implements ITmfVertex {
    public static Comparator<TmfVertex> ascending = Objects.requireNonNull(Comparator.nullsLast(Comparator.comparing(TmfVertex::getTimestamp)));
    public static Comparator<TmfVertex> descending = Objects.requireNonNull(Comparator.nullsLast(Comparator.comparing(TmfVertex::getTimestamp).reversed()));
    private final long fTimestamp;
    private final int fWorkerId;

    public TmfVertex(long timestamp, Integer workerId) {
        this.fTimestamp = timestamp;
        this.fWorkerId = workerId;
    }

    @Override
    public long getTimestamp() {
        return this.fTimestamp;
    }

    public int getWorkerId() {
        return this.fWorkerId;
    }

    @Override
    public int compareTo(@Nullable ITmfVertex other) {
        if (other == null) {
            return 1;
        }
        return Long.compare(this.fTimestamp, other.getTimestamp());
    }

    public String toString() {
        return "[w" + this.fWorkerId + "," + this.fTimestamp + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TmfVertex)) {
            return false;
        }
        TmfVertex other = (TmfVertex)obj;
        return this.fWorkerId == other.fWorkerId && this.fTimestamp == other.fTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.fWorkerId, this.fTimestamp);
    }
}

