/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.ITreeStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.AbstractSegmentStoreStatisticsDataProviderTest;
import org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore.statistics.StubTreeStatisticsAnalysis;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.IDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsAspects;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreTreeStatisticsDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SegmentStoreTreeStatisticsDataProviderTest
extends AbstractSegmentStoreStatisticsDataProviderTest {
    private static final @NonNull List<@NonNull String> EXPECTED_HEADER_LIST = Arrays.asList("Label", "Minimum", "Maximum", "Average", "Std Dev", "Count", "Total", "Min Time Range", "Max Time Range");
    private static final @NonNull List<@NonNull DataType> EXPECTED_DATATYPE_LIST = Arrays.asList(DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.TIME_RANGE, DataType.TIME_RANGE);
    private static final @NonNull List<@NonNull String> EXPECTED_TOOLTIP_LIST = Arrays.asList("", "", "", "", "", "", "", "", "");
    private static final List<@NonNull List<@NonNull String>> LIST_OF_EXPECTED_LABELS_FULL = Arrays.asList(Arrays.asList("", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[1000,1000]", "[1000,1002]"), Arrays.asList("Total", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[1000,1000]", "[1000,1002]"), Arrays.asList("child1", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[2000,2000]", "[2000,2002]"), Arrays.asList("grandChild11", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[4000,4000]", "[4000,4002]"), Arrays.asList("grandChild12", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[5000,5000]", "[5000,5002]"), Arrays.asList("child2", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[3000,3000]", "[3000,3002]"), Arrays.asList("grandChild21", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[6000,6000]", "[6000,6002]"), Arrays.asList("grandChild22", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[7000,7000]", "[7000,7002]"));
    private static final @NonNull List<@NonNull List<@NonNull String>> LIST_OF_EXPECTED_LABELS_SELECTION = Arrays.asList(Arrays.asList("Selection", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[1000,1000]", "[1000,1002]"), Arrays.asList("child1", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[2000,2000]", "[2000,2002]"), Arrays.asList("grandChild11", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[4000,4000]", "[4000,4002]"), Arrays.asList("grandChild12", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[5000,5000]", "[5000,5002]"), Arrays.asList("child2", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[3000,3000]", "[3000,3002]"), Arrays.asList("grandChild21", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[6000,6000]", "[6000,6002]"), Arrays.asList("grandChild22", "0", "2 ns", "1 ns", "1 ns", "3", "3 ns", "[7000,7000]", "[7000,7002]"));
    private static final @NonNull List<@NonNull AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder> EXPECTED_STATS_FULL = Arrays.asList(new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("", 0L, -1L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 1000L, 1000L, 1000L, 1002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("Total", 3L, 0L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 1000L, 1000L, 1000L, 1002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("child1", 4L, 3L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 2000L, 2000L, 2000L, 2002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("grandChild11", 5L, 4L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 4000L, 4000L, 4000L, 4002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("grandChild12", 6L, 4L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 5000L, 5000L, 5000L, 5002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("child2", 7L, 3L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 3000L, 3000L, 3000L, 3002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("grandChild21", 8L, 7L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 6000L, 6000L, 6000L, 6002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("grandChild22", 9L, 7L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 7000L, 7000L, 7000L, 7002L));
    private static final @NonNull List<@NonNull AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder> EXPECTED_STATS_SELECTION = Arrays.asList(new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("Selection", 10L, 0L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 1000L, 1000L, 1000L, 1002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("child1", 11L, 10L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 2000L, 2000L, 2000L, 2002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("grandChild11", 12L, 11L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 4000L, 4000L, 4000L, 4002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("grandChild12", 13L, 11L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 5000L, 5000L, 5000L, 5002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("child2", 14L, 10L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 3000L, 3000L, 3000L, 3002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("grandChild21", 15L, 14L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 6000L, 6000L, 6000L, 6002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("grandChild22", 16L, 14L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 7000L, 7000L, 7000L, 7002L));
    private static final List<@NonNull List<@NonNull String>> LIST_OF_EXPECTED_LABELS_WITH_MAPPER_FULL = Arrays.asList(Arrays.asList("My", "0", "2", "1.0", "1.0", "3", "3.0", "[1000,1000]", "[1000,1002]"), Arrays.asList("MyTotal", "0", "2", "1.0", "1.0", "3", "3.0", "[1000,1000]", "[1000,1002]"), Arrays.asList("Mychild1", "0", "2", "1.0", "1.0", "3", "3.0", "[2000,2000]", "[2000,2002]"), Arrays.asList("MygrandChild11", "0", "2", "1.0", "1.0", "3", "3.0", "[4000,4000]", "[4000,4002]"), Arrays.asList("MygrandChild12", "0", "2", "1.0", "1.0", "3", "3.0", "[5000,5000]", "[5000,5002]"), Arrays.asList("Mychild2", "0", "2", "1.0", "1.0", "3", "3.0", "[3000,3000]", "[3000,3002]"), Arrays.asList("MygrandChild21", "0", "2", "1.0", "1.0", "3", "3.0", "[6000,6000]", "[6000,6002]"), Arrays.asList("MygrandChild22", "0", "2", "1.0", "1.0", "3", "3.0", "[7000,7000]", "[7000,7002]"));
    private static final @NonNull List<@NonNull AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder> EXPECTED_STATS_WITH_MAPPER_FULL = Arrays.asList(new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("My", 1L, -1L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 1000L, 1000L, 1000L, 1002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("MyTotal", 17L, 1L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 1000L, 1000L, 1000L, 1002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("Mychild1", 18L, 17L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 2000L, 2000L, 2000L, 2002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("MygrandChild11", 19L, 18L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 4000L, 4000L, 4000L, 4002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("MygrandChild12", 20L, 18L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 5000L, 5000L, 5000L, 5002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("Mychild2", 21L, 17L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 3000L, 3000L, 3000L, 3002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("MygrandChild21", 22L, 21L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 6000L, 6000L, 6000L, 6002L), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolder("MygrandChild22", 23L, 21L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 7000L, 7000L, 7000L, 7002L));
    private static final String USER_DEFINED_EXTRA_HEADER = "userDefinedHeader";
    private static final String USER_DEFINED_EXTRA_VALUE = "userDefinedValue";
    private static final @NonNull DataType USER_DEFINED_DATATYPE = DataType.STRING;
    private static final @NonNull List<@NonNull String> EXPECTED_HEADER_LIST_USER_DEFINED = Stream.concat(EXPECTED_HEADER_LIST.stream(), Stream.of("userDefinedHeader")).collect(Collectors.toList());
    private static final @NonNull List<@NonNull DataType> EXPECTED_DATATYPE_LIST_USER_DEFINED = Stream.concat(EXPECTED_DATATYPE_LIST.stream(), Stream.of(USER_DEFINED_DATATYPE)).collect(Collectors.toList());
    private static final @NonNull List<@NonNull String> EXPECTED_TOOLTIP_LIST_USER_DEFINED = Stream.concat(EXPECTED_TOOLTIP_LIST.stream(), Stream.of("")).collect(Collectors.toList());
    private static final List<@NonNull List<@NonNull String>> LIST_OF_EXPECTED_LABELS_FULL_USER_DEFINED = LIST_OF_EXPECTED_LABELS_FULL.stream().map(list -> Stream.concat(list.stream(), Stream.of(USER_DEFINED_EXTRA_VALUE)).collect(Collectors.toList())).collect(Collectors.toList());
    private static final @NonNull List<@NonNull AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined> EXPECTED_STATS_FULL_USER_DEFINED = Arrays.asList(new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("", 2L, -1L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 1000L, 1000L, 1000L, 1002L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("Total", 24L, 2L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 1000L, 1000L, 1000L, 1002L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("child1", 25L, 24L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 2000L, 2000L, 2000L, 2002L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("grandChild11", 26L, 25L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 4000L, 4000L, 4000L, 4002L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("grandChild12", 27L, 25L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 5000L, 5000L, 5000L, 5002L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("child2", 28L, 24L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 3000L, 3000L, 3000L, 3002L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("grandChild21", 29L, 28L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 6000L, 6000L, 6000L, 6002L, "userDefinedValue"), new AbstractSegmentStoreStatisticsDataProviderTest.StatisticsHolderUserDefined("grandChild22", 30L, 28L, 0L, 2L, 1.0, 1.0, 3L, 3.0, 7000L, 7000L, 7000L, 7002L, "userDefinedValue"));
    private static List<ITableColumnDescriptor> fExpectedDescriptors;
    private static List<ITableColumnDescriptor> fExpectedDescriptorsUserDefined;
    private static SegmentStoreTreeStatisticsDataProvider fTestDataProvider;
    private static SegmentStoreTreeStatisticsDataProvider fTestDataProvider2;
    private static SegmentStoreTreeStatisticsDataProvider fTestDataProviderWithUserDefinedAspect;
    private static TmfXmlTraceStub fTrace;

    @BeforeClass
    public static void init() {
        SegmentStoreTreeStatisticsDataProviderTest.resetIds();
        fExpectedDescriptors = new ArrayList<ITableColumnDescriptor>();
        int i = 0;
        while (i < EXPECTED_HEADER_LIST.size()) {
            fExpectedDescriptors.add((ITableColumnDescriptor)new TableColumnDescriptor.Builder().setText(EXPECTED_HEADER_LIST.get(i)).setTooltip(EXPECTED_TOOLTIP_LIST.get(i)).setDataType(EXPECTED_DATATYPE_LIST.get(i)).build());
            ++i;
        }
        fExpectedDescriptorsUserDefined = new ArrayList<ITableColumnDescriptor>();
        i = 0;
        while (i < EXPECTED_HEADER_LIST_USER_DEFINED.size()) {
            fExpectedDescriptorsUserDefined.add((ITableColumnDescriptor)new TableColumnDescriptor.Builder().setText(EXPECTED_HEADER_LIST_USER_DEFINED.get(i)).setTooltip(EXPECTED_TOOLTIP_LIST_USER_DEFINED.get(i)).setDataType(EXPECTED_DATATYPE_LIST_USER_DEFINED.get(i)).build());
            ++i;
        }
        fTrace = new TmfXmlTraceStubNs();
        StubTreeStatisticsAnalysis analysis = new StubTreeStatisticsAnalysis();
        TmfXmlTraceStub trace = fTrace;
        Assert.assertNotNull((Object)trace);
        fTestDataProvider = new SegmentStoreTreeStatisticsDataProvider((ITmfTrace)trace, (ITreeStatisticsAnalysis)analysis, "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore");
        fTestDataProvider2 = new SegmentStoreTreeStatisticsDataProvider((ITmfTrace)trace, (ITreeStatisticsAnalysis)analysis, "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore");
        fTestDataProvider2.setLabelMapper(e -> "My" + e);
        fTestDataProvider2.setMapper(String::valueOf);
        @NonNull IDataAspect<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull SegmentStoreStatisticsAspects.NamedStatistics> userDefinedAspect = new IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics>(){

            public String getName() {
                return SegmentStoreTreeStatisticsDataProviderTest.USER_DEFINED_EXTRA_HEADER;
            }

            public @Nullable Object apply(SegmentStoreStatisticsAspects.NamedStatistics input) {
                return SegmentStoreTreeStatisticsDataProviderTest.USER_DEFINED_EXTRA_VALUE;
            }
        };
        fTestDataProviderWithUserDefinedAspect = new SegmentStoreTreeStatisticsDataProvider((ITmfTrace)trace, (ITreeStatisticsAnalysis)analysis, "org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore", Arrays.asList(userDefinedAspect));
    }

    @AfterClass
    public static void cleanup() {
        if (fTestDataProvider != null) {
            fTestDataProvider.dispose();
        }
        if (fTestDataProvider2 != null) {
            fTestDataProvider2.dispose();
        }
        if (fTestDataProviderWithUserDefinedAspect != null) {
            fTestDataProviderWithUserDefinedAspect.dispose();
        }
        if (fTrace != null) {
            fTrace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTreeFullRange() {
        HashMap<@NonNull K, @NonNull V> fetchParameters = new HashMap();
        @NonNull @NonNull TmfModelResponse response = fTestDataProvider.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)treeModel);
        Assert.assertEquals((String)"Header list size", (long)EXPECTED_HEADER_LIST.size(), (long)treeModel.getHeaders().size());
        Assert.assertEquals((String)"Header list", EXPECTED_HEADER_LIST, (Object)treeModel.getHeaders());
        @NonNull List columnDescriptors = treeModel.getColumnDescriptors();
        Assert.assertEquals((String)"Header descriptor list size", (long)EXPECTED_HEADER_LIST.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Column descriptor list", fExpectedDescriptors, (Object)columnDescriptors);
        Assert.assertNull((String)"Scope", (Object)treeModel.getScope());
        @NonNull List entries = treeModel.getEntries();
        Assert.assertNotNull((String)"Entries", (Object)entries);
        SegmentStoreTreeStatisticsDataProviderTest.verifyEntries(LIST_OF_EXPECTED_LABELS_FULL, EXPECTED_STATS_FULL, entries, 0, EXPECTED_STATS_FULL.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTreeSpecificRange() {
        long start = 1024L;
        long end = 4096L;
        FilterTimeQueryFilter filter = new FilterTimeQueryFilter(start, end, 2, true);
        @NonNull @NonNull Map fetchParameters = FetchParametersUtils.filteredTimeQueryToMap((FilterTimeQueryFilter)filter);
        @NonNull @NonNull TmfModelResponse response = fTestDataProvider.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)treeModel);
        Assert.assertEquals((String)"Header list size", (long)EXPECTED_HEADER_LIST.size(), (long)treeModel.getHeaders().size());
        Assert.assertEquals((String)"Header list", EXPECTED_HEADER_LIST, (Object)treeModel.getHeaders());
        @NonNull List columnDescriptors = treeModel.getColumnDescriptors();
        Assert.assertEquals((String)"Header descriptor list size", (long)EXPECTED_HEADER_LIST.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Column descriptor list", fExpectedDescriptors, (Object)columnDescriptors);
        Assert.assertNull((String)"Scope", (Object)treeModel.getScope());
        @NonNull List entries = treeModel.getEntries();
        Assert.assertNotNull((String)"Entries", (Object)entries);
        SegmentStoreTreeStatisticsDataProviderTest.verifyEntries(LIST_OF_EXPECTED_LABELS_FULL, EXPECTED_STATS_FULL, entries, 0, EXPECTED_STATS_FULL.size() + EXPECTED_STATS_SELECTION.size());
        SegmentStoreTreeStatisticsDataProviderTest.verifyEntries(LIST_OF_EXPECTED_LABELS_SELECTION, EXPECTED_STATS_SELECTION, entries, LIST_OF_EXPECTED_LABELS_FULL.size(), EXPECTED_STATS_FULL.size() + EXPECTED_STATS_SELECTION.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTreeWithMapperFullRange() {
        HashMap<@NonNull K, @NonNull V> fetchParameters = new HashMap();
        @NonNull @NonNull TmfModelResponse response = fTestDataProvider2.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)treeModel);
        Assert.assertEquals((String)"Header list size", (long)EXPECTED_HEADER_LIST.size(), (long)treeModel.getHeaders().size());
        Assert.assertEquals((String)"Header list", EXPECTED_HEADER_LIST, (Object)treeModel.getHeaders());
        @NonNull List columnDescriptors = treeModel.getColumnDescriptors();
        Assert.assertEquals((String)"Header descriptor list size", (long)EXPECTED_HEADER_LIST.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Column descriptor list", fExpectedDescriptors, (Object)columnDescriptors);
        Assert.assertNull((String)"Scope", (Object)treeModel.getScope());
        @NonNull List entries = treeModel.getEntries();
        Assert.assertNotNull((String)"Entries", (Object)entries);
        SegmentStoreTreeStatisticsDataProviderTest.verifyEntries(LIST_OF_EXPECTED_LABELS_WITH_MAPPER_FULL, EXPECTED_STATS_WITH_MAPPER_FULL, entries, 0, EXPECTED_STATS_WITH_MAPPER_FULL.size());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchTreeWithUserDefinedAspectsFullRange() {
        HashMap<@NonNull K, @NonNull V> fetchParameters = new HashMap();
        @NonNull @NonNull TmfModelResponse response = fTestDataProviderWithUserDefinedAspect.fetchTree(fetchParameters, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)response);
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)response.getModel();
        Assert.assertNotNull((Object)treeModel);
        Assert.assertEquals((String)"Header list size", (long)EXPECTED_HEADER_LIST_USER_DEFINED.size(), (long)treeModel.getHeaders().size());
        Assert.assertEquals((String)"Header list", EXPECTED_HEADER_LIST_USER_DEFINED, (Object)treeModel.getHeaders());
        @NonNull List columnDescriptors = treeModel.getColumnDescriptors();
        Assert.assertEquals((String)"Header descriptor list size", (long)EXPECTED_HEADER_LIST_USER_DEFINED.size(), (long)columnDescriptors.size());
        Assert.assertEquals((String)"Column descriptor list", fExpectedDescriptorsUserDefined, (Object)columnDescriptors);
        Assert.assertNull((String)"Scope", (Object)treeModel.getScope());
        @NonNull List entries = treeModel.getEntries();
        Assert.assertNotNull((String)"Entries", (Object)entries);
        SegmentStoreTreeStatisticsDataProviderTest.verifyEntriesWithUserDefinedAspect(LIST_OF_EXPECTED_LABELS_FULL_USER_DEFINED, EXPECTED_STATS_FULL_USER_DEFINED, entries, 0, EXPECTED_STATS_FULL_USER_DEFINED.size());
    }
}

