/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.internal.core.model.BinaryParserConfig;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.IncludeReference;
import org.eclipse.cdt.internal.core.model.LibraryReference;
import org.eclipse.cdt.internal.core.model.LibraryReferenceArchive;
import org.eclipse.cdt.internal.core.model.LibraryReferenceShared;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class CProject
extends Openable
implements ICProject {
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";

    public CProject(ICElement parent, IProject project) {
        super(parent, (IResource)project, 11);
    }

    @Override
    public IBinaryContainer getBinaryContainer() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getBinaryContainer();
    }

    @Override
    public IArchiveContainer getArchiveContainer() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getArchiveContainer();
    }

    @Override
    public IProject getProject() {
        return this.getUnderlyingResource().getProject();
    }

    @Override
    public ICElement findElement(IPath path) throws CModelException {
        ICElement celem = null;
        if (path.isAbsolute()) {
            celem = CModelManager.getDefault().create(path);
        } else {
            IProject project = this.getProject();
            if (project != null) {
                IPath p = project.getFullPath().append(path);
                celem = CModelManager.getDefault().create(p);
            }
        }
        if (celem == null) {
            CModelStatus status = new CModelStatus(979, path);
            throw new CModelException(status);
        }
        return celem;
    }

    public static boolean hasCNature(IProject p) {
        try {
            return p.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean hasCCNature(IProject p) {
        try {
            return p.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isCProject() {
        return CProject.hasCNature(this.getProject()) || CProject.hasCCNature(this.getProject());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CProject)) {
            return false;
        }
        CProject other = (CProject)o;
        return this.getProject().equals((Object)other.getProject());
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new CProjectInfo(this);
    }

    @Override
    public int hashCode() {
        return this.getProject().hashCode();
    }

    @Override
    public IIncludeReference[] getIncludeReferences() throws CModelException {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        IIncludeReference[] incRefs = null;
        if (pinfo != null) {
            incRefs = pinfo.incReferences;
        }
        if (incRefs == null) {
            IPathEntry[] entries = this.getResolvedPathEntries();
            ArrayList<IncludeReference> list = new ArrayList<IncludeReference>(entries.length);
            IPathEntry[] iPathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IPathEntry entrie = iPathEntryArray[n2];
                if (entrie.getEntryKind() == 16) {
                    IIncludeEntry entry = (IIncludeEntry)entrie;
                    list.add(new IncludeReference(this, entry));
                }
                ++n2;
            }
            incRefs = list.toArray(new IIncludeReference[list.size()]);
            if (pinfo != null) {
                pinfo.incReferences = incRefs;
            }
        }
        return incRefs;
    }

    @Override
    public ILibraryReference[] getLibraryReferences() throws CModelException {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        ILibraryReference[] libRefs = null;
        if (pinfo != null) {
            libRefs = pinfo.libReferences;
        }
        if (libRefs == null) {
            BinaryParserConfig[] binConfigs = CModelManager.getDefault().getBinaryParser(this.getProject());
            IPathEntry[] entries = this.getResolvedPathEntries();
            ArrayList<ILibraryReference> list = new ArrayList<ILibraryReference>(entries.length);
            IPathEntry[] iPathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ILibraryEntry entry;
                ILibraryReference lib;
                IPathEntry entrie = iPathEntryArray[n2];
                if (entrie.getEntryKind() == 1 && (lib = CProject.getLibraryReference(this, binConfigs, entry = (ILibraryEntry)entrie)) != null) {
                    list.add(lib);
                }
                ++n2;
            }
            libRefs = list.toArray(new ILibraryReference[list.size()]);
            if (pinfo != null) {
                pinfo.libReferences = libRefs;
            }
        }
        return libRefs;
    }

    private static ILibraryReference getLibraryReference(ICProject cproject, BinaryParserConfig[] binConfigs, ILibraryEntry entry) {
        if (binConfigs == null) {
            binConfigs = CModelManager.getDefault().getBinaryParser(cproject.getProject());
        }
        Parent lib = null;
        if (binConfigs != null) {
            BinaryParserConfig[] binaryParserConfigArray = binConfigs;
            int n = binConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                BinaryParserConfig binConfig = binaryParserConfigArray[n2];
                try {
                    IBinaryParser parser = binConfig.getBinaryParser();
                    IBinaryParser.IBinaryFile bin = parser.getBinary(entry.getFullLibraryPath());
                    if (bin != null) {
                        if (bin.getType() == 8) {
                            lib = new LibraryReferenceArchive((ICElement)cproject, entry, (IBinaryParser.IBinaryArchive)bin);
                            break;
                        }
                        if (!(bin instanceof IBinaryParser.IBinaryObject)) break;
                        lib = new LibraryReferenceShared((ICElement)cproject, entry, (IBinaryParser.IBinaryObject)bin);
                        break;
                    }
                }
                catch (IOException | CoreException throwable) {
                    // empty catch block
                }
                ++n2;
            }
        }
        if (lib == null) {
            lib = new LibraryReference(cproject, entry);
        }
        return lib;
    }

    @Override
    public String[] getRequiredProjectNames() throws CModelException {
        return this.projectPrerequisites(this.getResolvedPathEntries());
    }

    public String[] projectPrerequisites(IPathEntry[] entries) throws CModelException {
        return PathEntryManager.getDefault().projectPrerequisites(entries);
    }

    @Override
    public String getOption(String optionName, boolean inheritCCoreOptions) {
        if (CModelManager.OptionNames.contains(optionName)) {
            String cCoreDefault;
            IEclipsePreferences preferences = this.getPreferences();
            String string = cCoreDefault = inheritCCoreOptions ? CCorePlugin.getOption(optionName) : null;
            if (preferences == null) {
                return cCoreDefault;
            }
            String value = preferences.get(optionName, cCoreDefault).trim();
            return value == null ? null : value.trim();
        }
        return null;
    }

    @Override
    public Map<String, String> getOptions(boolean inheritCCoreOptions) {
        HashMap<String, String> options = inheritCCoreOptions ? CCorePlugin.getOptions() : new HashMap<String, String>(5);
        IEclipsePreferences preferences = this.getPreferences();
        if (preferences == null) {
            return options;
        }
        HashSet<String> optionNames = CModelManager.OptionNames;
        try {
            String[] propertyNames;
            String[] stringArray = propertyNames = preferences.keys();
            int n = propertyNames.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyName = stringArray[n2];
                String value = preferences.get(propertyName, null);
                if (value != null && optionNames.contains(propertyName)) {
                    options.put(propertyName, value.trim());
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return options;
    }

    @Override
    public void setOption(String optionName, String optionValue) {
        if (!CModelManager.OptionNames.contains(optionName)) {
            return;
        }
        IEclipsePreferences projectPreferences = this.getPreferences();
        if (optionValue == null) {
            projectPreferences.remove(optionName);
        } else {
            projectPreferences.put(optionName, optionValue);
        }
        try {
            projectPreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @Override
    public void setOptions(Map<String, String> newOptions) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (newOptions != null) {
            for (Map.Entry<String, String> e : newOptions.entrySet()) {
                String key = e.getKey();
                if (!CModelManager.OptionNames.contains(key)) continue;
                String value = e.getValue();
                preferences.setDefault(key, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(key, value);
            }
        }
        this.savePreferences(preferences);
    }

    private IEclipsePreferences getPreferences() {
        if (!this.isCProject()) {
            return null;
        }
        ProjectScope context = new ProjectScope(this.getProject());
        IEclipsePreferences preferences = context.getNode("org.eclipse.cdt.core");
        return preferences;
    }

    private void savePreferences(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        if (!this.isCProject()) {
            return;
        }
        for (String qualifiedName : CModelManager.OptionNames) {
            String dequalifiedName = qualifiedName.substring("org.eclipse.cdt.core".length() + 1);
            String value = null;
            try {
                value = preferences.getString(qualifiedName);
                if (value != null && !value.equals(preferences.getDefaultString(qualifiedName))) {
                    this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName), value);
                    continue;
                }
                this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName), null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private void setPreferences(Preferences preferences) {
        if (!this.isCProject()) {
            return;
        }
    }

    @Override
    public IPathEntry[] getResolvedPathEntries() throws CModelException {
        return CoreModel.getResolvedPathEntries(this);
    }

    @Override
    public IPathEntry[] getRawPathEntries() throws CModelException {
        return CoreModel.getRawPathEntries(this);
    }

    @Override
    public void setRawPathEntries(IPathEntry[] newEntries, IProgressMonitor monitor) throws CModelException {
        CoreModel.setRawPathEntries(this, newEntries, monitor);
    }

    @Override
    public ISourceRoot getSourceRoot(ISourceEntry entry) throws CModelException {
        return this.getSourceRoot(new CSourceEntry(entry.getPath(), entry.getExclusionPatterns(), 0));
    }

    public ISourceRoot getSourceRoot(ICSourceEntry entry) throws CModelException {
        IPath sp;
        IPath p = this.getPath();
        if (p.isPrefixOf(sp = entry.getFullPath())) {
            int count = sp.matchingFirstSegments(p);
            sp = sp.removeFirstSegments(count);
            Object res = null;
            res = sp.isEmpty() ? this.getProject() : this.getProject().findMember(sp);
            if (res != null) {
                return new SourceRoot((ICElement)this, (IResource)res, entry);
            }
        }
        return null;
    }

    @Override
    public ISourceRoot findSourceRoot(IResource res) {
        try {
            ISourceRoot[] roots;
            ISourceRoot[] iSourceRootArray = roots = this.getAllSourceRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceRoot root = iSourceRootArray[n2];
                if (root.isOnSourceEntry(res)) {
                    return root;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ISourceRoot findSourceRoot(IPath path) {
        try {
            ISourceRoot[] roots;
            ISourceRoot[] iSourceRootArray = roots = this.getAllSourceRoots();
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceRoot root = iSourceRootArray[n2];
                if (root.getPath().equals((Object)path)) {
                    return root;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ISourceRoot[] getSourceRoots() throws CModelException {
        ICElement[] children = this.getChildren();
        ArrayList<ISourceRoot> result = new ArrayList<ISourceRoot>(children.length);
        ICElement[] iCElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement element = iCElementArray[n2];
            if (element instanceof ISourceRoot) {
                result.add((ISourceRoot)element);
            }
            ++n2;
        }
        return result.toArray(new ISourceRoot[result.size()]);
    }

    @Override
    public ISourceRoot[] getAllSourceRoots() throws CModelException {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        ISourceRoot[] roots = null;
        if (pinfo != null) {
            if (pinfo.sourceRoots != null) {
                roots = pinfo.sourceRoots;
            } else {
                List<ISourceRoot> list = this.computeSourceRoots();
                pinfo.sourceRoots = list.toArray(new ISourceRoot[list.size()]);
                roots = pinfo.sourceRoots;
            }
        } else {
            List<ISourceRoot> list = this.computeSourceRoots();
            roots = list.toArray(new ISourceRoot[list.size()]);
        }
        return roots;
    }

    @Override
    public IOutputEntry[] getOutputEntries() throws CModelException {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        IOutputEntry[] outs = null;
        if (pinfo != null) {
            if (pinfo.outputEntries != null) {
                outs = pinfo.outputEntries;
            } else {
                IPathEntry[] entries = this.getResolvedPathEntries();
                pinfo.outputEntries = this.getOutputEntries(entries);
                outs = pinfo.outputEntries;
            }
        } else {
            IPathEntry[] entries = this.getResolvedPathEntries();
            outs = this.getOutputEntries(entries);
        }
        return outs;
    }

    public IOutputEntry[] getOutputEntries(IPathEntry[] entries) throws CModelException {
        ArrayList<IPathEntry> list = new ArrayList<IPathEntry>(entries.length);
        IPathEntry[] iPathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntry entrie = iPathEntryArray[n2];
            if (entrie.getEntryKind() == 128) {
                list.add(entrie);
            }
            ++n2;
        }
        IOutputEntry[] outputs = new IOutputEntry[list.size()];
        list.toArray(outputs);
        return outputs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isParentOfOutputEntry(IResource resource) {
        IPath path = resource.getFullPath();
        if (resource.getType() != 2) {
            if (resource.getType() != 4) return false;
        }
        try {
            IOutputEntry[] entries;
            IOutputEntry[] iOutputEntryArray = entries = this.getOutputEntries();
            int n = entries.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IOutputEntry entry = iOutputEntryArray[n2];
                if (path.isPrefixOf(entry.getPath())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isOnOutputEntry(IResource resource) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2 || resource.getType() == 4) {
            path = path.append("*");
        }
        try {
            IOutputEntry[] entries;
            IOutputEntry[] iOutputEntryArray = entries = this.getOutputEntries();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IOutputEntry entrie = iOutputEntryArray[n2];
                boolean on = this.isOnOutputEntry(entrie, path);
                if (on) {
                    return on;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return false;
    }

    private boolean isOnOutputEntry(IOutputEntry entry, IPath path) {
        return entry.getPath().isPrefixOf(path) && !CoreModelUtil.isExcluded(path, entry.fullExclusionPatternChars());
    }

    @Override
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        boolean validInfo;
        block5: {
            validInfo = false;
            try {
                IResource res = this.getResource();
                if (res != null && res.isAccessible()) {
                    validInfo = this.computeChildren(info, res);
                    break block5;
                }
                throw this.newNotPresentException();
            }
            finally {
                if (!validInfo) {
                    CModelManager.getDefault().removeInfo(this);
                }
            }
        }
        return validInfo;
    }

    protected List<ISourceRoot> computeSourceRoots() throws CModelException {
        ICConfigurationDescription cfg;
        ICSourceEntry[] entries = null;
        ICProjectDescription des = CProjectDescriptionManager.getInstance().getProjectDescription(this.getProject(), false);
        if (des != null && (cfg = des.getDefaultSettingConfiguration()) != null) {
            entries = cfg.getResolvedSourceEntries();
        }
        if (entries != null) {
            ArrayList<ISourceRoot> list = new ArrayList<ISourceRoot>(entries.length);
            ICSourceEntry[] iCSourceEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ICSourceEntry sourceEntry = iCSourceEntryArray[n2];
                ISourceRoot root = this.getSourceRoot(sourceEntry);
                if (root != null) {
                    list.add(root);
                }
                ++n2;
            }
            return list;
        }
        return Collections.emptyList();
    }

    protected boolean computeChildren(OpenableInfo info, IResource res) throws CModelException {
        List<ISourceRoot> sourceRoots = this.computeSourceRoots();
        ArrayList<ICContainer> children = new ArrayList<ICContainer>(sourceRoots.size());
        children.addAll(sourceRoots);
        boolean projectIsSourceRoot = false;
        for (ISourceRoot sourceRoot : sourceRoots) {
            if (!sourceRoot.getResource().equals((Object)this.getProject())) continue;
            projectIsSourceRoot = true;
            break;
        }
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.getProject().members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (child.getType() == 2) {
                    boolean found = false;
                    for (ISourceRoot sourceRoot : sourceRoots) {
                        if (!sourceRoot.isOnSourceEntry(child)) continue;
                        found = true;
                        break;
                    }
                    if (!found && !projectIsSourceRoot && (this.isParentOfOutputEntry(child) || this.isOnOutputEntry(child))) {
                        children.add(new CContainer(this, child));
                    }
                }
                ++n2;
            }
        }
        catch (CoreException resources) {
            // empty catch block
        }
        info.setChildren(children);
        if (info instanceof CProjectInfo) {
            CProjectInfo pinfo = (CProjectInfo)info;
            pinfo.sourceRoots = sourceRoots.toArray(new ISourceRoot[sourceRoots.size()]);
            pinfo.setNonCResources(null);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isOnSourceRoot(ICElement element) {
        try {
            ISourceRoot[] roots;
            ISourceRoot[] iSourceRootArray = roots = this.getSourceRoots();
            int n = roots.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceRoot root = iSourceRootArray[n2];
                if (root.isOnSourceEntry(element)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isOnSourceRoot(IResource resource) {
        try {
            ISourceRoot[] roots;
            ISourceRoot[] iSourceRootArray = roots = this.getSourceRoots();
            int n = roots.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceRoot root = iSourceRootArray[n2];
                if (root.isOnSourceEntry(resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean exists() {
        return this.isCProject();
    }

    @Override
    public Object[] getNonCResources() throws CModelException {
        return ((CProjectInfo)this.getElementInfo()).getNonCResources(this.getResource());
    }

    @Override
    protected void closing(Object info) throws CModelException {
        if (info instanceof CProjectInfo) {
            CModelManager.getDefault().removeBinaryRunner(this);
            CProjectInfo pinfo = (CProjectInfo)info;
            if (pinfo.vBin != null) {
                pinfo.vBin.close();
            }
            if (pinfo.vLib != null) {
                pinfo.vLib.close();
            }
            pinfo.resetCaches();
        }
        super.closing(info);
    }

    public void resetCaches() {
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(this);
        if (pinfo != null) {
            pinfo.resetCaches();
        }
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        switch (token.charAt(0)) {
            case '/': {
                CElement root;
                Path rootPath = Path.EMPTY;
                token = null;
                while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    char firstChar = token.charAt(0);
                    if (firstChar == '<' || firstChar == '{') break;
                    rootPath = rootPath.append(token);
                    token = null;
                }
                if (!rootPath.isAbsolute()) {
                    rootPath = this.getProject().getFullPath().append((IPath)rootPath);
                }
                if ((root = (CElement)((Object)this.findSourceRoot((IPath)rootPath))) == null) break;
                if (token != null) {
                    return root.getHandleFromMemento(token, memento);
                }
                return root.getHandleFromMemento(memento);
            }
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String tuName = memento.nextToken();
                IPath path = Path.fromPortableString((String)tuName);
                CElement tu = null;
                if (!path.isAbsolute()) {
                    IResource resource;
                    IProject project = this.getProject();
                    if (project != null && (resource = project.findMember(path)) != null && resource.getType() == 1) {
                        String contentTypeId;
                        IFile file = (IFile)resource;
                        tu = (CElement)CModelManager.getDefault().create(file, (ICProject)this);
                        if (tu == null && (contentTypeId = CoreModel.getRegistedContentTypeId(project, file.getName())) != null) {
                            tu = new TranslationUnit((ICElement)this, file, contentTypeId);
                        }
                    }
                } else {
                    tu = (CElement)((Object)CoreModel.getDefault().createTranslationUnitFrom((ICProject)this, path));
                }
                if (tu == null) break;
                return tu.getHandleFromMemento(memento);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '=';
    }
}

