/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.rtsj.framework;

import java.util.HashMap;
import org.eclipse.umlgen.rtsj.framework.ArgsBuffer;
import org.eclipse.umlgen.rtsj.framework.EventDataPort;
import org.eclipse.umlgen.rtsj.framework.ParameterSet;
import org.eclipse.umlgen.rtsj.framework.ServiceNotFoundException;
import org.eclipse.umlgen.rtsj.framework.async.PortProviderAsync;
import org.eclipse.umlgen.rtsj.framework.ethernet.ComProtocol;
import org.eclipse.umlgen.rtsj.framework.sync.PortProviderSync;

public class CommunicationLayer {
    private HashMap SynchronousConnections = new HashMap();
    private HashMap SynchronousProviderPortMap = new HashMap();
    private HashMap AsynchronousConnections = new HashMap();
    private HashMap AsynchronousProviderPortMap = new HashMap();
    private HashMap EventDataConnections = new HashMap();
    private HashMap EventDataPortMap = new HashMap();
    private HashMap ComponentMap = new HashMap();
    private HashMap<String, ComProtocol> comProtocols = new HashMap();

    public Object callSynchronous(String service, String ident, ParameterSet params) throws ServiceNotFoundException {
        PortProviderSync p = (PortProviderSync)this.SynchronousProviderPortMap.get(this.SynchronousConnections.get(ident));
        return p.invoke(service, params);
    }

    public void callAsynchronous(String service, String ident, String sender, ArgsBuffer params, int priority) {
        if (this.ComponentMap.containsKey(ident) && this.comProtocols.containsKey(sender)) {
            ComProtocol comProtocol = this.comProtocols.get(sender);
            comProtocol.sendFrame(((String[])this.ComponentMap.get(ident))[0], ident, service, params, priority);
            params.dequeue(params.getUsed());
        } else if (this.AsynchronousConnections.containsKey(ident)) {
            PortProviderAsync p = (PortProviderAsync)this.AsynchronousProviderPortMap.get(this.AsynchronousConnections.get(ident));
            p.store(service, params, priority);
            params.dequeue(params.getUsed());
        }
    }

    public void sendEventData(String service, String ident, String sender, ArgsBuffer params) {
        if (this.EventDataConnections.containsKey(ident)) {
            String[] receivers = (String[])this.EventDataConnections.get(ident);
            int i = 0;
            while (i < receivers.length) {
                EventDataPort p = (EventDataPort)this.EventDataPortMap.get(receivers[i]);
                p.store(service, params);
                ++i;
            }
            params.dequeue(params.getUsed());
        }
        if (this.ComponentMap.containsKey(ident) && this.comProtocols.containsKey(sender)) {
            ComProtocol comProtocol = this.comProtocols.get(sender);
            String[] receivers = (String[])this.ComponentMap.get(ident);
            int i = 0;
            while (i < receivers.length) {
                comProtocol.sendFrame(receivers[i], ident, service, params, 1);
                ++i;
            }
            params.dequeue(params.getUsed());
        }
    }

    public void registerSynchronousProviderPort(String ident, PortProviderSync ifProvider) {
        this.SynchronousProviderPortMap.put(ident, ifProvider);
    }

    public void registerAsynchronousProviderPort(String ident, PortProviderAsync ifProviderAsync) {
        this.AsynchronousProviderPortMap.put(ident, ifProviderAsync);
    }

    public void registerEventDataReceiverPort(String ident, EventDataPort ifProviderAsync) {
        this.EventDataPortMap.put(ident, ifProviderAsync);
    }

    public void setSynchronousConnection(String provider, String user) {
        this.SynchronousConnections.put(user, provider);
    }

    public void setAsynchronousConnection(String provider, String user) {
        this.AsynchronousConnections.put(user, provider);
    }

    public void setEventDataConnection(String sender, String[] receiver) {
        this.EventDataConnections.put(sender, receiver);
    }

    public void setComponentMap(String sender, String[] component) {
        this.ComponentMap.put(sender, component);
    }

    public boolean isSynchronousCall(String portIdent) {
        return this.AsynchronousConnections.containsKey(portIdent);
    }

    public boolean isSendEventData(String portIdent) {
        return this.EventDataConnections.containsKey(portIdent);
    }

    public void registerComProtocol(String comp, ComProtocol comProtocol) {
        this.comProtocols.put(comp, comProtocol);
    }
}

