/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.modeler.interactions.templates;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.umlgen.c.modeler.interactions.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private static final int BUFFER_SIZE = 1024;
    private File source;
    private IContainer destination;
    private Map<String, String> variables;
    private StringBuffer errors;

    public Template(File src) {
        this.source = src;
    }

    public void setDestination(IContainer container) {
        this.destination = container;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public void addVariable(String key, String value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, String>();
        }
        this.variables.put(key, value);
    }

    protected boolean checkTemplate() {
        boolean valid = true;
        this.errors = new StringBuffer();
        if (this.source == null || !this.source.exists()) {
            this.errors.append("The template source does not exist.\n");
            valid = false;
        }
        if (this.destination == null || !this.destination.exists()) {
            this.errors.append("The destination folder does not exist.\n");
        }
        return valid;
    }

    private IContainer generateFiles(File src, IContainer dest, IProgressMonitor monitor) throws CoreException {
        File[] members;
        File[] fileArray = members = src.listFiles();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            File member = fileArray[n2];
            if (member.isDirectory()) {
                String folderName = this.getProcessedString(member.getName());
                IFolder dstContainer = dest.getFolder((IPath)new Path(folderName));
                if (!dstContainer.exists()) {
                    dstContainer.create(true, true, monitor);
                }
                this.generateFiles(member, (IContainer)dstContainer, monitor);
            } else {
                this.copyFile(member, dest, monitor);
            }
            ++n2;
        }
        return dest;
    }

    private IFile copyFile(File file, IContainer dest, IProgressMonitor monitor) throws CoreException {
        String targetFileName = this.getProcessedString(file.getName());
        monitor.subTask(targetFileName);
        IFile dstFile = dest.getFile((IPath)new Path(targetFileName));
        InputStream stream = null;
        try {
            stream = this.getProcessedStream(file, dest.getDefaultCharset());
            if (dstFile.exists()) {
                dstFile.setContents(stream, true, true, monitor);
            } else {
                dstFile.create(stream, true, monitor);
            }
        }
        catch (IOException ioe) {
            Activator.log(ioe);
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ioe2) {
                Activator.log(ioe2);
            }
        }
        return dstFile;
    }

    private InputStream getProcessedStream(File file, String charset) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(stream);
        int bufsize = 1024;
        char[] cbuffer = new char[bufsize];
        int read = 0;
        StringBuffer keyBuffer = new StringBuffer();
        StringBuffer outBuffer = new StringBuffer();
        boolean replacementMode = false;
        boolean escape = false;
        while (read != -1) {
            read = reader.read(cbuffer);
            int i = 0;
            while (i < read) {
                char c = cbuffer[i];
                if (escape) {
                    if (c != '%') {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(c);
                    escape = false;
                } else if (c == '%') {
                    if (replacementMode) {
                        replacementMode = false;
                        String key = keyBuffer.toString();
                        String value = this.getVariable(key);
                        outBuffer.append(value);
                        keyBuffer.delete(0, keyBuffer.length());
                    } else {
                        replacementMode = true;
                    }
                } else if (c == '\\') {
                    escape = true;
                } else if (replacementMode) {
                    keyBuffer.append(c);
                } else {
                    outBuffer.append(c);
                }
                ++i;
            }
        }
        stream.close();
        return new ByteArrayInputStream(outBuffer.toString().getBytes(charset));
    }

    public String getProcessedString(String src) {
        if (src.indexOf(37) == -1) {
            return src;
        }
        int loc = -1;
        StringBuffer buffer = new StringBuffer();
        boolean replacementMode = false;
        int i = 0;
        while (i < src.length()) {
            char c = src.charAt(i);
            if (c == '%') {
                if (replacementMode) {
                    String key = src.substring(loc, i);
                    String value = this.getVariable(key);
                    buffer.append(value);
                    replacementMode = false;
                } else {
                    replacementMode = true;
                    loc = i + 1;
                }
            } else if (!replacementMode) {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String getVariable(String key) {
        if (this.variables != null && this.variables.get(key) != null) {
            return this.variables.get(key);
        }
        return key;
    }

    public IResource generate(IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Template Generation Process");
        Object dest = null;
        dest = this.source.isDirectory() ? this.generateFiles(this.source, this.destination, monitor) : this.copyFile(this.source, this.destination, monitor);
        monitor.subTask("");
        monitor.worked(1);
        return dest;
    }
}

