/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.builder;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.FlowFinalNode;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.umlgen.reverse.c.activity.UMLActivityBuilder;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityContext;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityNodesPins;
import org.eclipse.umlgen.reverse.c.activity.beans.LoopStatementWrapper;
import org.eclipse.umlgen.reverse.c.activity.builder.AbstractBuilder;
import org.eclipse.umlgen.reverse.c.activity.comments.CommentBuilder;
import org.eclipse.umlgen.reverse.c.activity.util.UMLActivityFactory;

public class LoopStatementBuilder
extends AbstractBuilder {
    public LoopStatementBuilder(UMLActivityBuilder activityBuilder, UMLActivityFactory factory, CommentBuilder commentBuilder) {
        super(activityBuilder, factory, commentBuilder);
    }

    public ActivityNodesPins buildLoopStatement(LoopStatementWrapper wrapperStmt, ActivityContext currentContext) {
        LoopNode loopNode = this.factory.createLoopNode(wrapperStmt.getLoopNodeName(), wrapperStmt.isTestedFirst(), currentContext);
        this.commentBuilder.buildComment((Element)loopNode, this.getCommentInfo((IASTNode)wrapperStmt.getWrappedStatement()));
        ActivityContext loopNodeContext = new ActivityContext((StructuredActivityNode)loopNode);
        this.createInitializer(loopNode, wrapperStmt, loopNodeContext);
        this.createTest(loopNode, wrapperStmt, loopNodeContext);
        this.createIteration(loopNode, wrapperStmt, loopNodeContext);
        this.createBody(loopNode, wrapperStmt, loopNodeContext);
        return new ActivityNodesPins((ActivityNode)loopNode, (ActivityNode)loopNode);
    }

    private void createInitializer(LoopNode loopNode, LoopStatementWrapper stmt, ActivityContext currentContext) {
        IASTStatement initializerStmt = stmt.getInitializerStatement();
        if (initializerStmt != null) {
            String initializerBody = initializerStmt.getRawSignature();
            initializerBody = initializerBody.substring(0, initializerBody.length() - 1);
            OpaqueAction setupAction = this.factory.createOpaqueAction(initializerBody, currentContext);
            loopNode.getSetupParts().add((Object)setupAction);
        }
    }

    private void createTest(LoopNode loopNode, LoopStatementWrapper stmt, ActivityContext currentContext) {
        String testBody = "";
        if (stmt.getConditionExpression() != null) {
            testBody = stmt.getConditionExpression().getRawSignature();
        }
        OpaqueAction testAction = this.factory.createOpaqueAction(testBody, currentContext);
        OutputPin decider = this.factory.createOutputPin();
        testAction.getOutputValues().add((Object)decider);
        loopNode.getTests().add((Object)testAction);
        loopNode.setDecider(decider);
    }

    private void createIteration(LoopNode loopNode, LoopStatementWrapper stmt, ActivityContext currentContext) {
        if (stmt.isFor()) {
            String iterationBody = "";
            if (stmt.getIterationExpression() != null) {
                iterationBody = stmt.getIterationExpression().getRawSignature();
            }
            OpaqueAction iterationAction = this.factory.createOpaqueAction(iterationBody, currentContext);
            OutputPin loopVariable = this.factory.createOutputPin();
            iterationAction.getOutputValues().add((Object)loopVariable);
            loopNode.getLoopVariables().add((Object)loopVariable);
        }
    }

    private void createBody(LoopNode loopNode, LoopStatementWrapper stmt, ActivityContext currentContext) {
        if (!(stmt.getBody() instanceof IASTNullStatement)) {
            ActivityNodesPins bodyNodes = this.activityBuilder.buildNodes(stmt.getBody(), currentContext);
            ActivityNode firstNode = bodyNodes.getStartNode();
            ActivityNode lastNode = bodyNodes.getEndNode();
            ExecutableNode bodyFirstNode = this.factory.ensureStartNodeIsExecutable(firstNode, currentContext);
            loopNode.getBodyParts().add((Object)bodyFirstNode);
            FlowFinalNode flowFinal = this.factory.getFlowFinalNodeForEndOfLoop(currentContext);
            this.factory.createControlFlow(lastNode, (ActivityNode)flowFinal, currentContext);
        }
    }
}

