/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.comments;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.umlgen.reverse.c.activity.beans.CommentInfo;
import org.eclipse.umlgen.reverse.c.activity.comments.NodeLocationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentsReconciler {
    private Map<IASTNode, NodeLocationInfo> nodesLocationInfo = Maps.newHashMap();

    public Map<IASTNode, CommentInfo> reconcile(IASTFunctionDefinition function) {
        List<IASTNode> interestingNodes = this.collectInterestingNodes(function);
        List<IASTComment> commentsToAnalyze = this.collectCommentsForFunction(function);
        return this.buildNodesAndComments(commentsToAnalyze, interestingNodes);
    }

    private Map<IASTNode, CommentInfo> buildNodesAndComments(List<IASTComment> commentsToAnalyze, List<IASTNode> interestingNodes) {
        HashMap nodesAndComments = Maps.newHashMap();
        for (IASTComment comment : commentsToAnalyze) {
            IASTNode node = this.getNodeForComment(comment, interestingNodes);
            if (node == null) continue;
            CommentInfo info = this.buildCommentInfo(node, comment, (CommentInfo)nodesAndComments.get(node));
            nodesAndComments.put(node, info);
        }
        return nodesAndComments;
    }

    private CommentInfo buildCommentInfo(IASTNode node, IASTComment comment, CommentInfo existingInfo) {
        CommentInfo info = existingInfo;
        if (info == null) {
            info = new CommentInfo();
        }
        int commentFirstLine = this.getStartingLine((IASTNode)comment);
        int stmtFirstLine = this.getStartingLine(node);
        int commentOffset = this.getStartingOffset((IASTNode)comment);
        int stmtOffset = this.getStartingOffset(node);
        if (commentFirstLine < stmtFirstLine) {
            info.addBefore(comment.getRawSignature());
        } else if (commentFirstLine == stmtFirstLine) {
            if (this.isInlined(comment, node)) {
                info.addInline(comment.getRawSignature());
            } else if (commentOffset < stmtOffset) {
                info.addBefore(comment.getRawSignature());
            } else {
                info.addSameLine(comment.getRawSignature());
            }
        } else {
            int stmtLastLine = this.getEndingLine(node);
            if (commentFirstLine < stmtLastLine) {
                info.addLastLine(comment.getRawSignature());
            }
        }
        return info;
    }

    private List<IASTComment> collectCommentsForFunction(IASTFunctionDefinition function) {
        int startingOffset = this.getStartingOffset((IASTNode)function);
        int endingOffset = this.getEndingOffset((IASTNode)function);
        ArrayList commentsWithoutStatements = Lists.newArrayList();
        IASTComment[] iASTCommentArray = function.getTranslationUnit().getComments();
        int n = iASTCommentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTComment comment = iASTCommentArray[n2];
            int cmtStartingOffset = this.getStartingOffset((IASTNode)comment);
            int cmtEndingOffset = this.getEndingOffset((IASTNode)comment);
            if (cmtStartingOffset >= startingOffset && cmtEndingOffset <= endingOffset) {
                commentsWithoutStatements.add(comment);
            }
            ++n2;
        }
        return commentsWithoutStatements;
    }

    private IASTNode getNodeForComment(IASTComment comment, List<IASTNode> interestingNodes) {
        int cmtStartingOffset = this.getStartingOffset((IASTNode)comment);
        int cmtEndingOffset = this.getEndingOffset((IASTNode)comment);
        int cmtStartingLine = this.getStartingLine((IASTNode)comment);
        IASTNode nearestEnclosingNode = null;
        int nearestEnclosingNodeOffset = 0;
        IASTNode nearestFollowingNode = null;
        int nearestFollowingNodeOffset = Integer.MAX_VALUE;
        IASTNode nearestNodeOnSameLine = null;
        int nearestNodeOnSameLineOffset = 0;
        for (IASTNode node : interestingNodes) {
            if (this.isInlined(comment, node)) {
                return node;
            }
            int stmtStartingOffset = this.getStartingOffset(node);
            int stmtEndingOffset = this.getEndingOffset(node);
            int stmtStartingLine = this.getStartingLine(node);
            if (stmtStartingOffset < cmtStartingOffset && stmtEndingOffset > cmtEndingOffset && stmtStartingOffset > nearestEnclosingNodeOffset) {
                nearestEnclosingNodeOffset = stmtStartingOffset;
                nearestEnclosingNode = node;
            }
            if (stmtStartingOffset > cmtEndingOffset && stmtStartingOffset < nearestFollowingNodeOffset) {
                nearestFollowingNodeOffset = stmtStartingOffset;
                nearestFollowingNode = node;
            }
            if (cmtStartingOffset <= stmtEndingOffset || stmtStartingLine != cmtStartingLine || stmtEndingOffset <= nearestNodeOnSameLineOffset) continue;
            nearestNodeOnSameLineOffset = stmtEndingOffset;
            nearestNodeOnSameLine = node;
        }
        IASTNode bestNode = this.pickBestNode(cmtStartingLine, nearestEnclosingNode, nearestFollowingNode, nearestNodeOnSameLine);
        return bestNode;
    }

    private boolean isInlined(IASTComment comment, IASTNode node) {
        return this.getStartingOffset((IASTNode)comment) >= this.getStartingOffsetForInline(node) && this.getEndingOffset((IASTNode)comment) <= this.getEndingOffsetForInline(node);
    }

    private IASTNode pickBestNode(int cmtStartingLine, IASTNode nearestEnclosingNode, IASTNode nearestFollowingNode, IASTNode nearestNodeOnSameLine) {
        IASTNode bestNode = null;
        if (nearestNodeOnSameLine != null) {
            if (nearestEnclosingNode != null) {
                int endOffset1 = this.getEndingOffset(nearestNodeOnSameLine);
                int startOffset2 = this.getStartingOffset(nearestEnclosingNode);
                bestNode = startOffset2 > endOffset1 ? nearestEnclosingNode : nearestNodeOnSameLine;
            } else {
                bestNode = nearestNodeOnSameLine;
            }
        } else if (nearestFollowingNode != null) {
            if (nearestEnclosingNode == null) {
                bestNode = nearestFollowingNode;
            } else {
                int startOffset1 = this.getStartingOffset(nearestFollowingNode);
                int endOffset1 = this.getEndingOffset(nearestFollowingNode);
                int startLine1 = this.getStartingLine(nearestFollowingNode);
                int startOffset2 = this.getStartingOffset(nearestEnclosingNode);
                int endOffset2 = this.getEndingOffset(nearestEnclosingNode);
                int startLine2 = this.getStartingLine(nearestEnclosingNode);
                bestNode = startLine2 == cmtStartingLine && startLine1 != cmtStartingLine ? nearestEnclosingNode : (startOffset1 > startOffset2 && endOffset1 < endOffset2 ? nearestFollowingNode : nearestEnclosingNode);
            }
        } else if (nearestEnclosingNode != null) {
            bestNode = nearestEnclosingNode;
        }
        return bestNode;
    }

    private List<IASTNode> collectInterestingNodes(IASTFunctionDefinition function) {
        ArrayList result = Lists.newArrayList();
        result.add(function.getBody());
        this.collectNodes((IASTNode)function.getBody(), result);
        return result;
    }

    private void collectNodes(IASTNode node, List<IASTNode> nodes) {
        if (node == null) {
            return;
        }
        if (node instanceof IASTSwitchStatement) {
            nodes.add(node);
            IASTSwitchStatement a = (IASTSwitchStatement)node;
            this.collectNodes((IASTNode)a.getBody(), nodes);
        } else if (node instanceof IASTForStatement) {
            nodes.add(node);
            IASTForStatement a = (IASTForStatement)node;
            this.collectNodes((IASTNode)a.getBody(), nodes);
        } else if (node instanceof IASTWhileStatement) {
            nodes.add(node);
            IASTWhileStatement a = (IASTWhileStatement)node;
            this.collectNodes((IASTNode)a.getBody(), nodes);
        } else if (node instanceof IASTDoStatement) {
            nodes.add(node);
            IASTDoStatement a = (IASTDoStatement)node;
            this.collectNodes((IASTNode)a.getBody(), nodes);
        } else if (node instanceof IASTIfStatement) {
            nodes.add(node);
            IASTIfStatement a = (IASTIfStatement)node;
            nodes.add((IASTNode)a.getThenClause());
            this.collectNodes((IASTNode)a.getThenClause(), nodes);
            if (a.getElseClause() != null) {
                nodes.add((IASTNode)a.getElseClause());
                this.collectNodes((IASTNode)a.getElseClause(), nodes);
            }
        } else if (node instanceof IASTCompoundStatement) {
            IASTCompoundStatement a = (IASTCompoundStatement)node;
            IASTStatement[] iASTStatementArray = a.getStatements();
            int n = iASTStatementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStatement st = iASTStatementArray[n2];
                this.collectNodes((IASTNode)st, nodes);
                ++n2;
            }
        } else {
            nodes.add(node);
        }
    }

    private int getStartingOffset(IASTNode node) {
        return this.getLocationInfo(node).getStartingOffset();
    }

    private int getEndingOffset(IASTNode node) {
        return this.getLocationInfo(node).getEndingOffset();
    }

    private int getStartingLine(IASTNode node) {
        return this.getLocationInfo(node).getStartingLine();
    }

    private int getEndingLine(IASTNode node) {
        return this.getLocationInfo(node).getEndingLine();
    }

    private int getStartingOffsetForInline(IASTNode node) {
        return this.getLocationInfo(node).getStartingOffsetForInline();
    }

    private int getEndingOffsetForInline(IASTNode node) {
        return this.getLocationInfo(node).getEndingOffsetForInline();
    }

    private NodeLocationInfo getLocationInfo(IASTNode node) {
        NodeLocationInfo locationInfo = this.nodesLocationInfo.get(node);
        if (locationInfo == null) {
            locationInfo = new NodeLocationInfo(node);
            this.nodesLocationInfo.put(node, locationInfo);
        }
        return locationInfo;
    }
}

