/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASTUtilities {
    private ASTUtilities() {
    }

    public static boolean hasDefaultStatement(IASTSwitchStatement stmt) {
        if (stmt.getBody() == null) {
            return false;
        }
        Predicate<IASTNode> breakStatement = new Predicate<IASTNode>(){

            public boolean apply(IASTNode node) {
                return node instanceof IASTDefaultStatement;
            }
        };
        List<IASTNode> nodes = Arrays.asList(stmt.getBody().getChildren());
        return Iterables.any(nodes, (Predicate)breakStatement);
    }

    public static boolean hasBreakStatement(List<IASTNode> nodes) {
        Predicate<IASTNode> hasBreakStatement = new Predicate<IASTNode>(){

            public boolean apply(IASTNode node) {
                return node instanceof IASTBreakStatement;
            }
        };
        return Iterables.any(nodes, (Predicate)hasBreakStatement);
    }

    public static boolean hasReturnStatement(List<IASTNode> nodes) {
        Predicate<IASTNode> hasReturnStatement = new Predicate<IASTNode>(){

            public boolean apply(IASTNode node) {
                return node instanceof IASTReturnStatement;
            }
        };
        return Iterables.any(nodes, (Predicate)hasReturnStatement);
    }

    public static List<List<IASTNode>> getStatementsGroupedByClause(IASTSwitchStatement switchStmt) {
        ArrayList groups = Lists.newArrayList();
        if (switchStmt.getBody() != null) {
            IASTNode[] nodes = switchStmt.getBody().getChildren();
            ArrayList group = null;
            IASTNode[] iASTNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode astNode = iASTNodeArray[n2];
                if (astNode instanceof IASTCaseStatement || astNode instanceof IASTDefaultStatement) {
                    group = Lists.newArrayList();
                    groups.add(group);
                }
                group.add(astNode);
                ++n2;
            }
        }
        return groups;
    }
}

