/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.event;

import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.umlgen.c.common.util.ModelManager;
import org.eclipse.umlgen.c.common.util.ModelUtil;
import org.eclipse.umlgen.reverse.c.event.AbstractEnumerationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationAdded
extends AbstractEnumerationEvent {
    @Override
    public void notifyChanges(ModelManager manager) {
        Classifier matchingClassifier = ModelUtil.findClassifierInPackage((Package)manager.getSourcePackage(), (String)this.getUnitName());
        Enumeration myEnumeration = ModelUtil.findEnumerationInClassifier((Classifier)matchingClassifier, (String)this.getCurrentName());
        if (myEnumeration == null) {
            if (matchingClassifier instanceof Class) {
                myEnumeration = (Enumeration)((Class)matchingClassifier).getNestedClassifier(this.getCurrentName(), false, UMLPackage.Literals.ENUMERATION, true);
            } else if (matchingClassifier instanceof Interface) {
                myEnumeration = (Enumeration)((Interface)matchingClassifier).getNestedClassifier(this.getCurrentName(), false, UMLPackage.Literals.ENUMERATION, true);
            }
        } else {
            myEnumeration.getOwnedLiterals().clear();
        }
        this.createEnumerators(myEnumeration);
        ModelUtil.setVisibility((NamedElement)myEnumeration, (ITranslationUnit)this.getTranslationUnit(), (ModelUtil.EventType)ModelUtil.EventType.ADD);
    }

    private void createEnumerators(Enumeration enumeration) {
        IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = this.getEnumerators();
        int n = iASTEnumeratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTEnumerationSpecifier.IASTEnumerator enumerator = iASTEnumeratorArray[n2];
            EnumerationLiteral literal = enumeration.createOwnedLiteral(enumerator.getName().toString());
            if (enumerator.getValue() != null) {
                LiteralString defaultExpression = (LiteralString)literal.createSpecification("initialisationValue", null, UMLPackage.Literals.LITERAL_STRING);
                defaultExpression.setValue(enumerator.getValue().getRawSignature());
            }
            ++n2;
        }
    }

    public static AbstractEnumerationEvent.AbstractBuilder<EnumerationAdded> builder() {
        return new AbstractEnumerationEvent.AbstractBuilder<EnumerationAdded>(){
            private EnumerationAdded event = new EnumerationAdded();

            @Override
            protected EnumerationAdded getEvent() {
                return this.event;
            }
        };
    }
}

