/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.common.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;
import org.eclipse.umlgen.c.common.Messages;
import org.eclipse.umlgen.c.common.interactions.SynchronizersManager;
import org.eclipse.umlgen.c.common.interactions.extension.IModelSynchronizer;
import org.eclipse.umlgen.c.common.ui.PreferenceStoreManager;

public class CProjectPropertyPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IProject project;
    private StringFieldEditor modelPath;
    private StringFieldEditor srcPath;
    private StringFieldEditor typePath;
    private StringFieldEditor extPath;
    private ResourceSet rscSet = new ResourceSetImpl();
    private Object[] packages;
    private ILabelProvider defaultLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new UMLItemProviderAdapterFactory());
    private ILabelProvider advancedLabelProvider;

    public void setElement(IAdaptable element) {
        this.project = (IProject)element.getAdapter(IResource.class);
        IModelSynchronizer synchronizer = SynchronizersManager.getSynchronizer();
        if (synchronizer != null) {
            synchronizer.setInitialValues(this.project);
            synchronizer.setDefaultValues(this.project);
        }
    }

    public IAdaptable getElement() {
        return this.project;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferenceStoreManager.getPreferenceStore(this.project);
    }

    protected Control createContents(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        this.createModelsGroup(mainComposite);
        this.createSettingsGroup(mainComposite);
        this.loadPreferences();
        return mainComposite;
    }

    private void createModelsGroup(Composite parent) {
        Group mainGroup = new Group(parent, 0);
        mainGroup.setText(Messages.getString("CProjectPropertyPage.0"));
        mainGroup.setLayout((Layout)new GridLayout());
        mainGroup.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite modelComposite = new Composite((Composite)mainGroup, 0);
        modelComposite.setLayout((Layout)new GridLayout());
        modelComposite.setLayoutData((Object)new GridData(4, 4, true, true, 0, 0));
        this.modelPath = new StringButtonFieldEditor(modelComposite){
            ElementTreeSelectionDialog dialog;
            {
                this.init("UMLModelPath", Messages.getString("CProjectPropertyPage.3"));
                this.createControl(composite);
                this.dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            }

            protected String changePressed() {
                Object[] result;
                IFile d = null;
                this.dialog.setInput((Object)CProjectPropertyPage.this.getElement());
                if (this.dialog.open() == 0 && (result = this.dialog.getResult()).length == 1 && result[0] instanceof IFile) {
                    d = (IFile)result[0];
                }
                if (d == null) {
                    return null;
                }
                URI uri = URI.createPlatformResourceURI((String)d.getFullPath().toString(), (boolean)false);
                return URI.decode((String)uri.toString());
            }
        };
        this.modelPath.setPreferenceName("UMLModelPath");
        this.modelPath.setLabelText(Messages.getString("CProjectPropertyPage.3"));
        this.modelPath.setEnabled(true, modelComposite);
        this.modelPath.setPreferenceStore(this.getPreferenceStore());
        this.modelPath.setPage((DialogPage)this);
        this.modelPath.setEmptyStringAllowed(false);
        this.modelPath.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("field_editor_value".equals(event.getProperty())) {
                    CProjectPropertyPage.this.resetPathFields();
                    CProjectPropertyPage.this.extractPackagesFromModel();
                }
            }
        });
    }

    private void resetPathFields() {
        this.srcPath.setStringValue("");
        this.typePath.setStringValue("");
        this.extPath.setStringValue("");
    }

    private void extractPackagesFromModel() {
        ArrayList<EObject> collection = new ArrayList<EObject>();
        URI uri = URI.createURI((String)this.modelPath.getStringValue(), (boolean)false);
        try {
            Resource model = this.rscSet.getResource(uri, true);
            if (model != null) {
                TreeIterator iterator = EcoreUtil.getAllContents((Resource)model, (boolean)false);
                while (iterator.hasNext()) {
                    collection.add((EObject)iterator.next());
                }
                this.packages = EcoreUtil.getObjectsByType(collection, (EClassifier)UMLPackage.Literals.PACKAGE).toArray();
            }
        }
        catch (Exception exception) {}
    }

    private void createSettingsGroup(Composite parent) {
        Group settingsGroup = new Group(parent, 0);
        settingsGroup.setLayout((Layout)new GridLayout());
        settingsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        settingsGroup.setText(Messages.getString("CProjectPropertyPage.7"));
        Composite intermediateComposite = new Composite((Composite)settingsGroup, 0);
        intermediateComposite.setLayout((Layout)new GridLayout());
        intermediateComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.srcPath = this.createStringFieldEditor(intermediateComposite, "srcPackageName", Messages.getString("CProjectPropertyPage.2"));
        this.typePath = this.createStringFieldEditor(intermediateComposite, "typePackageName", Messages.getString("CProjectPropertyPage.9"));
        this.extPath = this.createStringFieldEditor(intermediateComposite, "extPackageName", Messages.getString("CProjectPropertyPage.10"));
    }

    protected StringFieldEditor createStringFieldEditor(Composite parent, String key, String label) {
        StringFieldEditor fieldEditor = new StringFieldEditor(key, label, parent);
        fieldEditor.setPage((DialogPage)this);
        fieldEditor.setPreferenceStore(this.getPreferenceStore());
        return fieldEditor;
    }

    private void loadPreferences() {
        this.modelPath.load();
        this.srcPath.load();
        this.typePath.load();
        this.extPath.load();
        this.extractPackagesFromModel();
    }

    private void storePreferences() {
        this.modelPath.store();
        this.srcPath.store();
        this.typePath.store();
        this.extPath.store();
    }

    private void loadDefaultPreferences() {
        this.modelPath.loadDefault();
        this.srcPath.loadDefault();
        this.typePath.loadDefault();
        this.extPath.loadDefault();
        this.extractPackagesFromModel();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        for (Resource rsc : this.rscSet.getResources()) {
            rsc.unload();
        }
        this.rscSet = null;
    }
}

