/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.c.common.util;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.umlgen.c.common.Activator;
import org.eclipse.umlgen.c.common.Messages;
import org.eclipse.umlgen.c.common.interactions.SynchronizersManager;
import org.eclipse.umlgen.c.common.interactions.extension.IModelSynchronizer;
import org.eclipse.umlgen.c.common.ui.PreferenceStoreManager;
import org.eclipse.umlgen.c.common.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelManager {
    protected IProject project;
    protected Resource modelResource;
    protected boolean loadedFromModeler;
    private EObject model;
    private Package srcPackage;
    private Package typesPackage;
    private Package libsPackage;

    public ModelManager(IResource rsc) {
        this.project = rsc.getProject();
        IModelSynchronizer synchronizer = SynchronizersManager.getSynchronizer();
        if (synchronizer != null) {
            synchronizer.setDefaultValues(this.project);
        }
        this.initializeEditorPartListener();
        this.initializeModels();
    }

    public void dispose() {
        this.saveModels();
        this.unloadPreviousModels();
        this.project = null;
    }

    protected void initializeEditorPartListener() {
    }

    protected void initializeModels() {
        URI modelURI = this.getModelUri();
        ResourceSet rscSet = this.getResourceSet(modelURI);
        this.modelResource = rscSet.getResource(modelURI, true);
        this.model = (EObject)this.modelResource.getContents().get(0);
    }

    private URI getModelUri() {
        IPreferenceStore store = PreferenceStoreManager.getPreferenceStore(this.project);
        String modelPath = store.getString("UMLModelPath");
        return URI.createURI((String)modelPath);
    }

    protected void unloadPreviousModels() {
        this.srcPackage = null;
        this.typesPackage = null;
        this.libsPackage = null;
        this.model = null;
        if (!this.loadedFromModeler && this.modelResource != null) {
            this.modelResource.unload();
            this.modelResource = null;
        }
    }

    public void saveModels() {
        HashMap<String, String> options = new HashMap<String, String>();
        try {
            options.put("ENCODING", this.project.getDefaultCharset(true));
            this.saveModels(options);
        }
        catch (Exception e) {
            Status status = null;
            status = new Status(4, Activator.getBundleId(), 0, String.valueOf(Messages.getModelManager()) + e.getMessage(), (Throwable)e);
            Activator.log((IStatus)status);
        }
    }

    protected void saveModels(Map<String, String> options) throws CoreException, IOException {
        if (this.modelResource != null) {
            this.modelResource.save(options);
        }
    }

    public Model getUMLModel() {
        return (Model)this.model;
    }

    public IProject getProject() {
        return this.project;
    }

    public ICProject getCProject() {
        return CoreModel.getDefault().getCModel().getCProject(this.getProject().getName());
    }

    public Resource getModelResource() {
        return this.modelResource;
    }

    protected ResourceSet getResourceSet(URI modelURI) {
        return new ResourceSetImpl();
    }

    private Package findPackage(String pkgConstante) {
        IPreferenceStore store = PreferenceStoreManager.getPreferenceStore(this.project);
        String packToLocate = store.getString(pkgConstante);
        Collection packages = UMLUtil.findNamedElements((Resource)this.modelResource, (String)packToLocate, (boolean)false, (EClass)UMLPackage.Literals.PACKAGE);
        return packages.isEmpty() ? null : packages.toArray(new Package[0])[0];
    }

    public Package getSourcePackage() {
        if (this.srcPackage == null) {
            this.srcPackage = this.findPackage("srcPackageName");
        }
        return this.srcPackage;
    }

    public Package getTypePackage() {
        if (this.typesPackage == null) {
            this.typesPackage = this.findPackage("typePackageName");
        }
        return this.typesPackage;
    }

    public Package getLibsPackage() {
        if (this.libsPackage == null) {
            this.libsPackage = this.findPackage("extPackageName");
        }
        return this.libsPackage;
    }

    public DataType findDataType(final String typeName) {
        TreeIterator allDataTypes = UML2Util.getAllContents((EObject)this.model, (boolean)false, (boolean)false);
        return (DataType)UML2Util.findEObject((Iterator)allDataTypes, (UML2Util.EObjectMatcher)new UML2Util.EObjectMatcher(){

            public boolean matches(EObject eObject) {
                if (eObject instanceof DataType) {
                    DataType type = (DataType)eObject;
                    String name = type.getName();
                    VisibilityKind visibility = type.getVisibility();
                    return typeName.equals(name) && visibility == VisibilityKind.PUBLIC_LITERAL;
                }
                return false;
            }
        });
    }

    public DataType findDataTypeInTypesPck(String dataTypeName) {
        String qualifier = this.getTypePackage().getQualifiedName().concat("::" + dataTypeName);
        Collection dataTypes = UMLUtil.findNamedElements((Resource)this.modelResource, (String)qualifier, (boolean)false, (EClass)UMLPackage.Literals.DATA_TYPE);
        return dataTypes.isEmpty() ? null : dataTypes.toArray(new DataType[0])[0];
    }

    public DataType getDataType(String typeName) {
        DataType myType = this.findDataType(typeName);
        if (myType == null) {
            myType = this.createNewDataType(typeName);
        }
        return myType;
    }

    private DataType createNewDataType(String typeName) {
        PrimitiveType newType = null;
        if (ModelUtil.getPrimitiveTypes().contains(typeName)) {
            newType = this.getTypePackage().createOwnedPrimitiveType(typeName);
        } else {
            newType = (DataType)this.getTypePackage().createOwnedType(typeName, UMLPackage.Literals.DATA_TYPE);
            this.setSuperDataType((DataType)newType);
        }
        newType.setVisibility(VisibilityKind.PUBLIC_LITERAL);
        return newType;
    }

    private void setSuperDataType(DataType pointerType) {
        if (pointerType.getName().contains("*")) {
            while (pointerType.getRedefinedClassifiers().isEmpty()) {
                String superType = pointerType.getName();
                DataType candidateType = this.findDataType(superType = superType.substring(0, superType.lastIndexOf("*")));
                if (candidateType == null) {
                    candidateType = this.createNewDataType(superType);
                }
                pointerType.getRedefinedClassifiers().add((Object)candidateType);
            }
        }
    }
}

