/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.gen.embedded.c.ui.launch.tabs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.umlgen.gen.embedded.c.ui.UML2ECUIActivator;
import org.eclipse.umlgen.gen.embedded.c.ui.common.ConfigurationServices;
import org.eclipse.umlgen.gen.embedded.c.ui.launch.tabs.AbstractUML2ECLaunchConfigurationTab;
import org.eclipse.umlgen.gen.embedded.c.ui.utils.UML2ECMessages;

public class UML2ECGeneralLaunchConfigurationTab
extends AbstractUML2ECLaunchConfigurationTab {
    private Text modelPathText;
    private Text outputFolderPathText;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setFont(font);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        composite.setLayoutData((Object)gd);
        this.createGenerationGroup(composite, font);
        this.createEmbeddedCGroup(composite, font);
        this.setControl((Control)composite);
        this.update();
    }

    private void createGenerationGroup(Composite composite, Font font) {
        Group generationGroup = this.createGroup(composite, UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.GenerationGroupName"), 3, 1, 768);
        Composite comp = new Composite((Composite)generationGroup, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        Label modelPathLabel = new Label(comp, 0);
        modelPathLabel.setText(UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.UMLModelPathLabel"));
        this.modelPathText = new Text(comp, 2052);
        this.modelPathText.setFont(composite.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.modelPathText.setLayoutData((Object)gd);
        this.modelPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UML2ECGeneralLaunchConfigurationTab.this.update();
            }
        });
        Button browseModelButton = this.createPushButton(comp, UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.UMLModelBrowseButtonName"), null);
        browseModelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(UML2ECGeneralLaunchConfigurationTab.this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle(UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.UMLModelDialogTitle"));
                dialog.setInitialPattern("*.uml");
                dialog.open();
                if (dialog.getResult() != null && dialog.getResult().length > 0) {
                    Object[] results;
                    Object[] objectArray = results = dialog.getResult();
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object result = objectArray[n2];
                        if (result instanceof IFile) {
                            UML2ECGeneralLaunchConfigurationTab.this.modelPathText.setText(((IFile)result).getFullPath().toString());
                            break;
                        }
                        ++n2;
                    }
                }
                UML2ECGeneralLaunchConfigurationTab.this.update();
                UML2ECGeneralLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createHelpButton(comp, UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.UMLModelPathHelp"));
    }

    private void createEmbeddedCGroup(Composite composite, Font font) {
        Group embeddedCGroup = this.createGroup(composite, UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.ECGroupName"), 3, 1, 768);
        Composite comp = new Composite((Composite)embeddedCGroup, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        Label outputFolderPathLabel = new Label(comp, 0);
        outputFolderPathLabel.setText(UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.OutputFolderPathLabel"));
        this.outputFolderPathText = new Text(comp, 2052);
        this.outputFolderPathText.setFont(composite.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.outputFolderPathText.setLayoutData((Object)gd);
        this.outputFolderPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UML2ECGeneralLaunchConfigurationTab.this.update();
            }
        });
        Button browseOutputButton = this.createPushButton(comp, UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.OutputFolderBrowseButtonName"), null);
        browseOutputButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(UML2ECGeneralLaunchConfigurationTab.this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 2);
                dialog.setTitle(UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.OutputFolderDialogTitle"));
                dialog.setInitialPattern("**");
                dialog.open();
                if (dialog.getResult() != null && dialog.getResult().length > 0) {
                    Object[] results;
                    Object[] objectArray = results = dialog.getResult();
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object result = objectArray[n2];
                        if (result instanceof IFolder) {
                            UML2ECGeneralLaunchConfigurationTab.this.outputFolderPathText.setText(((IFolder)result).getFullPath().toString());
                            break;
                        }
                        ++n2;
                    }
                }
                UML2ECGeneralLaunchConfigurationTab.this.update();
                UML2ECGeneralLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createHelpButton(comp, UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.OutputFolderPathHelp"));
    }

    private void update() {
        IFolder folder;
        IFile model;
        String text;
        this.setErrorMessage(null);
        this.getLaunchConfigurationDialog().updateButtons();
        this.getLaunchConfigurationDialog().updateMessage();
        if (this.modelPathText != null && (text = this.modelPathText.getText()) != null && text.length() > 0 && (model = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(text))) != null && !model.exists()) {
            this.setErrorMessage(UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.MissingInputModel"));
        }
        if (this.outputFolderPathText != null && (text = this.outputFolderPathText.getText()) != null && text.length() > 0 && (folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(text))) != null && !folder.exists()) {
            this.setErrorMessage(UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.MissingOutputFolderPath"));
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("uml_model_path", "");
        if (this.modelPathText != null) {
            this.modelPathText.setText("");
        }
        configuration.setAttribute("output_folder_path", "");
        if (this.outputFolderPathText != null) {
            this.outputFolderPathText.setText("");
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String attribute = configuration.getAttribute("uml_model_path", "");
            this.modelPathText.setText(attribute);
            attribute = configuration.getAttribute("output_folder_path", "");
            this.outputFolderPathText.setText(attribute);
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.umlgen.gen.embedded.c.ui", e.getMessage(), (Throwable)e);
            UML2ECUIActivator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String umlModelPath = this.modelPathText.getText();
        configuration.setAttribute("uml_model_path", umlModelPath);
        if (umlModelPath != null && umlModelPath.length() != 0) {
            IFile modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(umlModelPath));
            ConfigurationServices.saveConfigurationProperty((IResource)modelFile, configuration.getName());
        }
        String outputFolderPath = this.outputFolderPathText.getText();
        configuration.setAttribute("output_folder_path", outputFolderPath);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        boolean isValid = true;
        try {
            String attribute = configuration.getAttribute("uml_model_path", "");
            isValid = isValid && attribute != null && attribute.trim().length() > 0;
            attribute = configuration.getAttribute("output_folder_path", "");
            isValid = isValid && attribute != null && attribute.trim().length() > 0;
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.umlgen.gen.embedded.c.ui", e.getMessage(), (Throwable)e);
            UML2ECUIActivator.getDefault().getLog().log((IStatus)status);
        }
        return isValid;
    }

    public String getName() {
        return UML2ECMessages.getString("UML2ECGeneralLaunchConfigurationTab.Name");
    }

    public Image getImage() {
        return UML2ECUIActivator.getDefault().getImage("icons/model_obj.gif");
    }
}

