/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c;

import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.umlgen.reverse.c.StructuralBuilder;
import org.eclipse.umlgen.reverse.c.event.AbstractCModelChangedEvent;
import org.eclipse.umlgen.reverse.c.event.AbstractCUnitEvent;
import org.eclipse.umlgen.reverse.c.event.CUnitRemoved;
import org.eclipse.umlgen.reverse.c.internal.bundle.Activator;
import org.eclipse.umlgen.reverse.c.reconciler.CASTReconciler;
import org.eclipse.umlgen.reverse.c.resource.C2UMLSyncNature;

public class ElementChangedListener
implements IElementChangedListener {
    private CASTReconciler cASTReconciler;

    public synchronized void setASTReconciler(CASTReconciler reconciler) {
        this.cASTReconciler = reconciler;
    }

    public void elementChanged(ElementChangedEvent event) {
        final ICElementDelta delta = event.getDelta();
        final ICElement element = delta.getElement();
        IWorkspaceRoot wsRoot = element.getResource().getWorkspace().getRoot();
        final int elementType = element.getElementType();
        if ((element instanceof ITranslationUnit || element instanceof ICModel) && wsRoot.findMember(element.getPath()) != null) {
            WorkspaceJob job = new WorkspaceJob("Synchronizing C code and UML Model from : ".concat(element.getElementName())){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    switch (elementType) {
                        case 60: {
                            if (!C2UMLSyncNature.isC2UMLSynchProject(element.getCProject()) || !(element instanceof IWorkingCopy) || !((IWorkingCopy)element).hasUnsavedChanges()) break;
                            ElementChangedListener.this.workingCopyChanged(delta);
                            break;
                        }
                        case 10: {
                            ElementChangedListener.this.cModelChanged(delta);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    private void cModelChanged(ICElementDelta delta) {
        ICElementDelta[] children = delta.getAffectedChildren();
        ICElement element = delta.getElement();
        int elementType = element.getElementType();
        if (elementType == 60 && C2UMLSyncNature.isC2UMLSynchProject(element.getCProject())) {
            if (!(element instanceof IWorkingCopy)) {
                switch (delta.getKind()) {
                    case 1: {
                        this.cUnitAdded(delta, element);
                        break;
                    }
                    case 2: {
                        this.cUnitRemoved(element);
                        break;
                    }
                    case 4: {
                        this.cUnitChanged(delta, element);
                    }
                }
            }
        } else {
            ICElementDelta[] iCElementDeltaArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ICElementDelta element2 = iCElementDeltaArray[n2];
                this.cModelChanged(element2);
                ++n2;
            }
        }
    }

    private void cUnitChanged(ICElementDelta delta, ICElement element) {
        int changeFlags = delta.getFlags();
    }

    private void cUnitRemoved(ICElement element) {
        Object event = ((AbstractCUnitEvent.AbstractBuilder)CUnitRemoved.builder().translationUnit((ITranslationUnit)element)).currentName(((ITranslationUnit)element).getElementName()).build();
        this.cASTReconciler.notifyListeners((AbstractCModelChangedEvent)event, true);
    }

    private void cUnitAdded(ICElementDelta delta, ICElement element) {
        ICElementDelta[] affectedChildren;
        block6: {
            StructuralBuilder builder = new StructuralBuilder(((ITranslationUnit)element).getResource());
            try {
                try {
                    builder.build((ITranslationUnit)element);
                }
                catch (CoreException e) {
                    Activator.log(e);
                    builder.dispose();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                builder.dispose();
                throw throwable;
            }
            builder.dispose();
        }
        ICElementDelta[] iCElementDeltaArray = affectedChildren = delta.getAffectedChildren();
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICElementDelta element2 = iCElementDeltaArray[n2];
            this.cModelChanged(element2);
            ++n2;
        }
    }

    private void workingCopyChanged(ICElementDelta delta) throws CoreException {
        ICElementDelta element;
        IWorkingCopy workingUnit = (IWorkingCopy)delta.getElement();
        ITranslationUnit originalUnit = workingUnit.getOriginalElement();
        boolean reconcile = false;
        ICElementDelta[] children = delta.getAffectedChildren();
        ICElementDelta[] addedChildren = delta.getAddedChildren();
        ICElementDelta[] removedChildrenInVrac = delta.getRemovedChildren();
        ICElementDelta[] removedChildren = new ICElementDelta[removedChildrenInVrac.length];
        int j = 0;
        ICElementDelta[] iCElementDeltaArray = removedChildrenInVrac;
        int n = removedChildrenInVrac.length;
        int n2 = 0;
        while (n2 < n) {
            element = iCElementDeltaArray[n2];
            if (element.getElement().getElementType() != 63 && element.getElement().getElementType() != 67 && element.getElement().getElementType() != 80 && element.getElement().getElementType() != 75) {
                removedChildren[j] = element;
                ++j;
            }
            ++n2;
        }
        iCElementDeltaArray = removedChildrenInVrac;
        n = removedChildrenInVrac.length;
        n2 = 0;
        while (n2 < n) {
            element = iCElementDeltaArray[n2];
            if (element.getElement().getElementType() == 63 || element.getElement().getElementType() == 67 || element.getElement().getElementType() == 80 || element.getElement().getElementType() == 75) {
                removedChildren[j] = element;
                ++j;
            }
            ++n2;
        }
        if (children.length > 0 && children.length == 2 * addedChildren.length && addedChildren.length == removedChildren.length) {
            this.cASTReconciler.reconcile(originalUnit, workingUnit);
            reconcile = true;
        } else if (children.length == 0) {
            if (workingUnit.getBuffer().hasUnsavedChanges() || originalUnit.getBuffer().hasUnsavedChanges()) {
                this.cASTReconciler.reconcile(originalUnit, workingUnit);
                reconcile = true;
            } else {
                Activator.log("ElementChangedListener.workingCopyChanged() - neither the IWorkingUnit nor the ITranslationUnit has unsaved changes", 1);
            }
        } else {
            int removedOrder = 0;
            ICElementDelta[] iCElementDeltaArray2 = children;
            int n3 = children.length;
            n = 0;
            while (n < n3) {
                ICElementDelta child = iCElementDeltaArray2[n];
                ICElement childElement = child.getElement();
                Activator.log("Traitrement de : ".concat(childElement.getElementName()), 1);
                if (child.getKind() == 1) {
                    this.elementAdded(workingUnit, originalUnit, childElement);
                } else if (child.getKind() == 2) {
                    this.elementRemoved(workingUnit, originalUnit, removedChildren[removedOrder].getElement());
                    ++removedOrder;
                }
                ++n;
            }
            if (!reconcile) {
                this.cASTReconciler.reconcile(originalUnit, workingUnit);
            }
        }
        workingUnit.getBuffer().save((IProgressMonitor)new NullProgressMonitor(), true);
    }

    private void elementRemoved(IWorkingCopy workingUnit, ITranslationUnit originalUnit, ICElement element) throws CoreException {
        if (element.getElementType() == 75 || element.getElementType() == 79) {
            this.cASTReconciler.removedElement(originalUnit, workingUnit, element);
        } else {
            this.cASTReconciler.removedElement(originalUnit.getAST(), workingUnit.getAST(), workingUnit.getOriginalElement(), element);
        }
    }

    private void elementAdded(IWorkingCopy workingUnit, ITranslationUnit originalUnit, ICElement element) throws CoreException {
        if (element.getElementType() == 75 || element.getElementType() == 79) {
            this.cASTReconciler.addedElement(originalUnit, workingUnit, element);
        } else {
            this.cASTReconciler.addedElement(originalUnit.getAST(), workingUnit.getAST(), workingUnit.getOriginalElement(), element);
        }
    }
}

