/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.umlgen.reverse.c.event.AbstractCModelChangedEvent;
import org.eclipse.umlgen.reverse.c.event.AbstractCUnitEvent;
import org.eclipse.umlgen.reverse.c.event.CUnitAdded;
import org.eclipse.umlgen.reverse.c.internal.bundle.Activator;
import org.eclipse.umlgen.reverse.c.internal.reconciler.BindingResolver;
import org.eclipse.umlgen.reverse.c.internal.reconciler.CFileReconciler;
import org.eclipse.umlgen.reverse.c.internal.reconciler.HFileReconciler;
import org.eclipse.umlgen.reverse.c.internal.reconciler.IFileReconciler;
import org.eclipse.umlgen.reverse.c.internal.reconciler.SameFileLocation;
import org.eclipse.umlgen.reverse.c.listener.UMLModelChangeListener;
import org.eclipse.umlgen.reverse.c.reconciler.ASTCommentReconciler;
import org.eclipse.umlgen.reverse.c.resource.ProjectUtil;

public class StructuralBuilder {
    private static final String MSG_UNDEFINED_DECLARATION = ". The Type is defined outside and the Declaration is not found even in includes dependencies. Module is not already defined.";
    private UMLModelChangeListener umlModelChangeListener;
    private final HFileReconciler hFileReconciler;
    private final CFileReconciler cFileReconciler = new CFileReconciler();
    private final ASTCommentReconciler commentReconciler;
    private final boolean includeInactiveNode;
    private final IResource resource;
    private Collection<IASTDeclaration> declarations;

    public StructuralBuilder(IResource modelFile) {
        this.includeInactiveNode = true;
        this.hFileReconciler = new HFileReconciler();
        this.commentReconciler = new ASTCommentReconciler();
        this.resource = modelFile;
    }

    private int filesCount(IResource[] members, int count) {
        int result = count;
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource rsc = iResourceArray[n2];
            if (rsc instanceof IFile && ("c".equalsIgnoreCase(((IFile)rsc).getFileExtension()) || "h".equalsIgnoreCase(((IFile)rsc).getFileExtension()))) {
                ++result;
            } else if (rsc instanceof IFolder) {
                try {
                    result = this.filesCount(((IFolder)rsc).members(), count);
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            ++n2;
        }
        return result;
    }

    public void build() throws CoreException {
        final ICProject cProject = CoreModel.getDefault().getCModel().getCProject(this.resource.getProject().getName());
        final IWorkspaceRoot wsRoot = cProject.getResource().getWorkspace().getRoot();
        final int nbWorks = this.filesCount(this.resource.getProject().members(), 0);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Reversing code contained in project " + StructuralBuilder.this.resource.getProject().getName() + ".", nbWorks);
                    try {
                        try {
                            cProject.accept(new ICElementVisitor(){

                                public boolean visit(ICElement element) throws CoreException {
                                    if (monitor.isCanceled()) {
                                        throw new CoreException((IStatus)new Status(1, Activator.getId(), "Reverse process interrupted by user"));
                                    }
                                    if (element instanceof ITranslationUnit && wsRoot.findMember(element.getPath()) != null) {
                                        switch (element.getElementType()) {
                                            case 60: {
                                                monitor.subTask("Reversing file " + element.getPath());
                                                ITranslationUnit translationUnit = (ITranslationUnit)element;
                                                StructuralBuilder.this.build(translationUnit, true);
                                                monitor.worked(1);
                                                return false;
                                            }
                                        }
                                    }
                                    return true;
                                }
                            });
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log("Error in job", 4, e);
        }
        catch (InterruptedException e) {
            Activator.log("Interrupted job", 4, e);
        }
    }

    public void build(ITranslationUnit translationUnit) throws CoreException, CModelException {
        this.build(translationUnit, false);
    }

    public void build(ITranslationUnit translationUnit, boolean fullBuild) throws CoreException, CModelException {
        Activator.log("Reversing file : " + translationUnit.getPath(), 1);
        if (!fullBuild) {
            this.preBuild(translationUnit);
        }
        IASTTranslationUnit ast = translationUnit.getAST();
        Object[] declarationsArray = translationUnit.getAST().getDeclarations(this.includeInactiveNode);
        this.declarations = Collections2.filter((Collection)Lists.newArrayList((Object[])declarationsArray), (Predicate)new SameFileLocation(ast));
        IResource cRsc = translationUnit.getResource();
        if (cRsc != null) {
            this.umlModelChangeListener = this.getUMLModelChangeListener(cRsc);
            Object event = ((AbstractCUnitEvent.AbstractBuilder)CUnitAdded.builder().translationUnit(translationUnit)).currentName(translationUnit.getElementName()).setModelMananager(this.umlModelChangeListener.getModelManager()).build();
            this.umlModelChangeListener.notifyChanges((AbstractCModelChangedEvent)event, false);
            this.addIfNDef(translationUnit, ast);
            this.addIncludes(translationUnit, ast);
            this.addEnumerations(translationUnit, ast);
            this.addStructures(translationUnit, ast);
            this.addTypeDefs(translationUnit, ast);
            this.addMacros(translationUnit, ast);
            this.addVariableDeclarations(translationUnit, ast);
            this.addVariables(translationUnit, ast);
            this.addFunctionDeclarations(translationUnit, ast);
            this.addFunctionDefinitions(translationUnit, ast);
            this.addComments(translationUnit, ast);
        }
        if (!fullBuild) {
            this.postBuild(translationUnit);
        }
    }

    private UMLModelChangeListener getUMLModelChangeListener(IResource rsc) {
        if (this.umlModelChangeListener == null) {
            this.umlModelChangeListener = new UMLModelChangeListener(rsc);
        }
        return this.umlModelChangeListener;
    }

    public void dispose() {
        if (this.umlModelChangeListener != null) {
            this.umlModelChangeListener.dispose();
            this.umlModelChangeListener = null;
        }
    }

    private void postBuild(ITranslationUnit translationUnit) throws CoreException {
        ProjectUtil.addToBuildSpec(translationUnit.getCProject().getProject(), "org.eclipse.umlgen.gen.c.builder");
    }

    private void preBuild(ITranslationUnit translationUnit) throws CoreException {
        ProjectUtil.removeFromBuildSpec(translationUnit.getCProject().getProject(), "org.eclipse.umlgen.gen.c.builder");
    }

    private void addComments(ITranslationUnit translationUnit, IASTTranslationUnit ast) {
        try {
            IWorkingCopy workingUnit = translationUnit.getWorkingCopy();
            this.commentReconciler.addModelChangeListener(this.umlModelChangeListener);
            this.commentReconciler.reconcile((ITranslationUnit)workingUnit, null, new IASTDeclaration[1]);
            this.commentReconciler.removeModelChangeListener(this.umlModelChangeListener);
        }
        catch (CoreException e) {
            Activator.log("Error during the Addition of Comments : " + e.getMessage(), 4);
        }
    }

    private IFileReconciler getFileReconciler(IASTTranslationUnit tu) {
        return tu.isHeaderUnit() ? this.hFileReconciler : this.cFileReconciler;
    }

    private void addIncludes(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        Object[] includesArray = ast.getIncludeDirectives();
        Collection filteredInclusions = Collections2.filter((Collection)Lists.newArrayList((Object[])includesArray), (Predicate)new SameFileLocation(ast));
        for (IASTPreprocessorIncludeStatement include : filteredInclusions) {
            AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement(include, translationUnit);
            this.umlModelChangeListener.notifyChanges(event, false);
        }
    }

    private void addMacros(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        Object[] macros = ast.getMacroDefinitions();
        Collection filteredMacros = Collections2.filter((Collection)Lists.newArrayList((Object[])macros), (Predicate)new SameFileLocation(ast));
        for (IASTPreprocessorMacroDefinition macro : filteredMacros) {
            AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement(macro, translationUnit);
            this.umlModelChangeListener.notifyChanges(event, false);
        }
    }

    private void addIfNDef(ITranslationUnit translationUnit, IASTTranslationUnit ast) {
        Object[] prerocStmts = ast.getAllPreprocessorStatements();
        Collection filteredPreprocStmts = Collections2.filter((Collection)Lists.newArrayList((Object[])prerocStmts), (Predicate)new SameFileLocation(ast));
        if (ast.getFileLocation() != null) {
            int firstNodePosition = ast.getFileLocation().getNodeLength();
            if (ast.getDeclarations().length > 0 && ast.getDeclarations()[0] instanceof IASTNode) {
                firstNodePosition = ast.getFileLocation().getNodeLength();
            }
            boolean first = true;
            for (IASTPreprocessorStatement preprocStmt : filteredPreprocStmts) {
                if (!(preprocStmt instanceof IASTPreprocessorIfndefStatement) || !first || ((IASTPreprocessorIfndefStatement)preprocStmt).getFileLocation().getNodeOffset() >= firstNodePosition) continue;
                AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement((IASTPreprocessorIfndefStatement)preprocStmt, translationUnit);
                this.umlModelChangeListener.notifyChanges(event, false);
                first = false;
            }
        }
    }

    private void addVariableDeclarations(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        for (ICElement element : translationUnit.getChildrenOfType(77)) {
            IVariableDeclaration varDecl = (IVariableDeclaration)element;
            IASTSimpleDeclaration simpleDeclaration = BindingResolver.resolveBindingIASTSimpleDeclaration(this.declarations, (ICElement)varDecl);
            AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement(simpleDeclaration, varDecl);
            this.umlModelChangeListener.notifyChanges(event, false);
        }
    }

    private void addVariables(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        for (ICElement element : translationUnit.getChildrenOfType(76)) {
            IVariable var = (IVariable)element;
            IASTSimpleDeclaration simpleDeclaration = BindingResolver.resolveBindingIASTSimpleDeclaration(this.declarations, (ICElement)var);
            AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement(simpleDeclaration, var);
            this.umlModelChangeListener.notifyChanges(event, false);
        }
    }

    private void addFunctionDeclarations(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        for (ICElement element : translationUnit.getChildrenOfType(73)) {
            IFunctionDeclaration coreElement = (IFunctionDeclaration)element;
            IASTSimpleDeclaration declaration = BindingResolver.resolveBindingIASTFunctionDeclarator(this.declarations, (ICElement)coreElement);
            if (declaration != null) {
                AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement((IASTFunctionDeclarator)declaration.getDeclarators()[0], coreElement);
                this.umlModelChangeListener.notifyChanges(event, false);
                continue;
            }
            Activator.log("Undefined declaration : " + coreElement.getElementName() + MSG_UNDEFINED_DECLARATION, 2);
        }
    }

    private void addFunctionDefinitions(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        for (ICElement element : translationUnit.getChildrenOfType(74)) {
            IFunction coreElement = (IFunction)element;
            IASTFunctionDefinition functionDefinition = BindingResolver.resolveBindingIASTFunctionDefinition(this.declarations, (ICElement)coreElement);
            AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement(functionDefinition, coreElement);
            this.umlModelChangeListener.notifyChanges(event, false);
        }
    }

    private void addStructures(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        int anonymousRanking = 1;
        for (ICElement element : translationUnit.getChildrenOfType(67)) {
            IStructure coreElement = (IStructure)element;
            IASTSimpleDeclaration simpleDeclaration = BindingResolver.resolveBindingIASTStructure(this.declarations, (ICElement)coreElement, anonymousRanking);
            if (simpleDeclaration != null) {
                AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement((IASTCompositeTypeSpecifier)simpleDeclaration.getDeclSpecifier(), coreElement);
                this.umlModelChangeListener.notifyChanges(event, false);
                if (!"".equals(coreElement.getElementName())) continue;
                ++anonymousRanking;
                continue;
            }
            Activator.log("Undefined Structure : " + coreElement.getElementName() + MSG_UNDEFINED_DECLARATION, 2);
        }
    }

    private void addEnumerations(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        int anonymousRanking = 1;
        for (ICElement element : translationUnit.getChildrenOfType(63)) {
            IEnumeration coreElement = (IEnumeration)element;
            IASTSimpleDeclaration simpleDeclaration = BindingResolver.resolveBindingIASTEnumeration(this.declarations, (ICElement)coreElement, anonymousRanking);
            if (simpleDeclaration != null) {
                AbstractCModelChangedEvent event = this.getFileReconciler(ast).addElement((IASTEnumerationSpecifier)simpleDeclaration.getDeclSpecifier(), coreElement);
                this.umlModelChangeListener.notifyChanges(event, false);
                if (!"".equals(coreElement.getElementName())) continue;
                ++anonymousRanking;
                continue;
            }
            Activator.log("Undefined Enumeration : " + coreElement.getElementName() + MSG_UNDEFINED_DECLARATION, 2);
        }
    }

    private void addTypeDefs(ITranslationUnit translationUnit, IASTTranslationUnit ast) throws CModelException {
        AbstractCModelChangedEvent event = null;
        for (ICElement element : translationUnit.getChildrenOfType(80)) {
            ITypeDef coreElement = (ITypeDef)element;
            IASTSimpleDeclaration simpleDeclaration = BindingResolver.resolveBindingIASTypeDefDeclaration(this.declarations, (ICElement)coreElement);
            if (simpleDeclaration != null && simpleDeclaration.getFileLocation() != null) {
                if (simpleDeclaration.getDeclSpecifier() instanceof IASTEnumerationSpecifier) {
                    event = this.getFileReconciler(ast).addElement((IASTEnumerationSpecifier)simpleDeclaration.getDeclSpecifier(), coreElement);
                } else if (simpleDeclaration.getDeclSpecifier() instanceof IASTCompositeTypeSpecifier) {
                    event = this.getFileReconciler(ast).addElement((IASTCompositeTypeSpecifier)simpleDeclaration.getDeclSpecifier(), coreElement);
                } else if (simpleDeclaration.getDeclSpecifier() instanceof IASTElaboratedTypeSpecifier) {
                    event = this.getFileReconciler(ast).addElement((IASTElaboratedTypeSpecifier)simpleDeclaration.getDeclSpecifier(), coreElement);
                } else if (simpleDeclaration.getDeclSpecifier() instanceof IASTNamedTypeSpecifier) {
                    event = this.getFileReconciler(ast).addElement(simpleDeclaration.getDeclarators()[0], coreElement);
                } else if (simpleDeclaration.getDeclSpecifier() instanceof IASTSimpleDeclSpecifier) {
                    event = this.getFileReconciler(ast).addElement(simpleDeclaration.getDeclarators()[0], coreElement);
                } else if (simpleDeclaration.getDeclarators()[0] instanceof IASTFunctionDeclarator) {
                    event = this.getFileReconciler(ast).addElement(simpleDeclaration.getDeclarators()[0], coreElement);
                }
                this.umlModelChangeListener.notifyChanges(event, false);
                continue;
            }
            Activator.log("Undefined TypedDef : " + coreElement.getElementName() + MSG_UNDEFINED_DECLARATION, 4);
        }
    }
}

