/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.builder;

import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.uml2.uml.ActivityFinalNode;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.umlgen.reverse.c.activity.UMLActivityBuilder;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityContext;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityNodesPins;
import org.eclipse.umlgen.reverse.c.activity.builder.AbstractBuilder;
import org.eclipse.umlgen.reverse.c.activity.comments.CommentBuilder;
import org.eclipse.umlgen.reverse.c.activity.util.UMLActivityFactory;

public class IfStatementBuilder
extends AbstractBuilder {
    public IfStatementBuilder(UMLActivityBuilder activityBuilder, UMLActivityFactory factory, CommentBuilder commentBuilder) {
        super(activityBuilder, factory, commentBuilder);
    }

    public ActivityNodesPins buildIfStatement(IASTIfStatement stmt, ActivityContext currentContext) {
        String decisionNodeName = this.getDecisionNodeName(stmt);
        DecisionNode decisionNode = this.factory.createDecisionNode(decisionNodeName, currentContext);
        MergeNode mergeNode = this.factory.createMergeNode(currentContext);
        this.commentBuilder.buildComment((Element)decisionNode, this.getCommentInfo((IASTNode)stmt));
        IASTStatement thenClause = stmt.getThenClause();
        ActivityNodesPins thenNodes = this.activityBuilder.buildNodes(thenClause, currentContext);
        ControlFlow thenFlow = this.factory.createControlFlow((ActivityNode)decisionNode, thenNodes.getStartNode(), stmt.getConditionExpression().getRawSignature(), currentContext);
        this.commentBuilder.buildComment((Element)thenFlow, this.getCommentInfo((IASTNode)thenClause));
        this.factory.createControlFlow(thenNodes.getEndNode(), (ActivityNode)mergeNode, currentContext);
        IASTStatement elseClause = stmt.getElseClause();
        ActivityNodesPins elseNodes = null;
        if (elseClause != null) {
            elseNodes = this.activityBuilder.buildNodes(elseClause, currentContext);
            ControlFlow elseFlow = this.factory.createControlFlow((ActivityNode)decisionNode, elseNodes.getStartNode(), "[else]", currentContext);
            this.commentBuilder.buildComment((Element)elseFlow, this.getCommentInfo((IASTNode)elseClause));
            if (elseNodes.getEndNode() instanceof MergeNode) {
                this.replaceMergeNode((MergeNode)elseNodes.getEndNode(), mergeNode);
            } else {
                this.factory.createControlFlow(elseNodes.getEndNode(), (ActivityNode)mergeNode, currentContext);
            }
        } else {
            this.factory.createControlFlow((ActivityNode)decisionNode, (ActivityNode)mergeNode, "[else]", currentContext);
        }
        if (thenNodes.getEndNode() instanceof ActivityFinalNode && elseNodes != null && elseNodes.getEndNode() instanceof ActivityFinalNode) {
            currentContext.getNodes().remove(mergeNode);
            return new ActivityNodesPins((ActivityNode)decisionNode, thenNodes.getEndNode());
        }
        return new ActivityNodesPins((ActivityNode)decisionNode, (ActivityNode)mergeNode);
    }

    private String getDecisionNodeName(IASTIfStatement stmt) {
        String name = stmt.getRawSignature();
        int stmtOffset = stmt.getFileLocation().getNodeOffset();
        int thenOffset = stmt.getThenClause().getFileLocation().getNodeOffset();
        return name.substring(0, thenOffset - stmtOffset).trim();
    }

    private void replaceMergeNode(MergeNode toBeReplaced, MergeNode substitute) {
        substitute.getIncomings().addAll((Collection)toBeReplaced.getIncomings());
        toBeReplaced.getIncomings().clear();
        substitute.getOutgoings().addAll((Collection)toBeReplaced.getOutgoings());
        toBeReplaced.getOutgoings().clear();
        toBeReplaced.destroy();
    }
}

