/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Clause;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.FlowFinalNode;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.umlgen.reverse.c.activity.UMLActivityBuilder;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityContext;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityNodesPins;
import org.eclipse.umlgen.reverse.c.activity.builder.AbstractBuilder;
import org.eclipse.umlgen.reverse.c.activity.comments.CommentBuilder;
import org.eclipse.umlgen.reverse.c.activity.util.ASTUtilities;
import org.eclipse.umlgen.reverse.c.activity.util.UMLActivityFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchStatementBuilder
extends AbstractBuilder {
    private static final String CASE = "case";
    private static final String DEFAULT = "default";

    public SwitchStatementBuilder(UMLActivityBuilder activityBuilder, UMLActivityFactory factory, CommentBuilder commentBuilder) {
        super(activityBuilder, factory, commentBuilder);
    }

    public ActivityNodesPins buildSwitchStatement(IASTSwitchStatement stmt, ActivityContext currentContext) {
        ConditionalNode condNode = this.createConditionnalNode(stmt, currentContext);
        this.commentBuilder.buildComment((Element)condNode, this.getCommentInfo((IASTNode)stmt));
        ActivityContext condNodeContext = new ActivityContext((StructuredActivityNode)condNode);
        OpaqueAction switchTestAction = this.factory.createOpaqueAction(this.getTestName(stmt), condNodeContext);
        switchTestAction.setName("test");
        Clause previousClause = null;
        ControlFlow pendingFlow = null;
        ArrayList clausesWithoutBody = Lists.newArrayList();
        List<List<IASTNode>> groups = ASTUtilities.getStatementsGroupedByClause(stmt);
        for (List<IASTNode> group : groups) {
            OpaqueAction testAction = this.buildTestActionForCaseGroup(group, condNodeContext);
            ExecutableNode bodyAction = this.buildBodyActionForCaseGroup(group, condNodeContext);
            boolean hasBreak = ASTUtilities.hasBreakStatement(group);
            boolean hasReturn = ASTUtilities.hasReturnStatement(group);
            Clause clause = this.factory.createClause(condNode, testAction);
            this.commentBuilder.buildComment((Element)clause, this.getCommentInfo((IASTNode)((IASTStatement)group.get(0))));
            if (bodyAction == null) {
                clausesWithoutBody.add(clause);
            } else {
                clause.getBodies().add((Object)bodyAction);
                for (Clause clauseWithoutBody : clausesWithoutBody) {
                    clauseWithoutBody.getBodies().add((Object)bodyAction);
                }
                clausesWithoutBody = Lists.newArrayList();
            }
            if (previousClause != null) {
                clause.getPredecessorClauses().add(previousClause);
            }
            if (pendingFlow != null) {
                pendingFlow.setTarget((ActivityNode)bodyAction);
                pendingFlow = null;
            }
            if (bodyAction != null && !hasBreak && !hasReturn) {
                pendingFlow = this.factory.createControlFlow(condNodeContext);
                pendingFlow.setSource((ActivityNode)bodyAction);
            }
            previousClause = clause;
        }
        if (pendingFlow != null) {
            FlowFinalNode flowFinal = this.factory.getFlowFinalNodeForEndOfSwitch(condNodeContext);
            pendingFlow.setTarget((ActivityNode)flowFinal);
        }
        return new ActivityNodesPins((ActivityNode)condNode, (ActivityNode)condNode);
    }

    public ActivityNodesPins buildCaseStatement(IASTCaseStatement stmt, ActivityContext currentContext) {
        String actionBody = stmt.getExpression() == null ? "" : stmt.getExpression().getRawSignature();
        String actionName = "case " + actionBody;
        OpaqueAction opaqueAction = this.buildActionForClauseStatement(actionName, actionBody, currentContext);
        return new ActivityNodesPins((ActivityNode)opaqueAction, (ActivityNode)opaqueAction);
    }

    public ActivityNodesPins buildDefaultStatement(IASTDefaultStatement stmt, ActivityContext currentContext) {
        OpaqueAction opaqueAction = this.buildActionForClauseStatement(DEFAULT, DEFAULT, currentContext);
        return new ActivityNodesPins((ActivityNode)opaqueAction, (ActivityNode)opaqueAction);
    }

    private OpaqueAction buildActionForClauseStatement(String actionName, String actionBody, ActivityContext currentContext) {
        OpaqueAction opaqueAction = this.factory.createOpaqueAction(actionBody, currentContext);
        opaqueAction.setName(this.factory.sanitizeString(actionName));
        opaqueAction.getOutputValues().add((Object)this.factory.createOutputPin());
        return opaqueAction;
    }

    private ConditionalNode createConditionnalNode(IASTSwitchStatement stmt, ActivityContext currentContext) {
        String nodeName = this.getConditionalNodeName(stmt);
        ConditionalNode condNode = this.factory.createConditionalNode(nodeName, currentContext);
        boolean hasDefaultStmt = ASTUtilities.hasDefaultStatement(stmt);
        condNode.setIsDeterminate(!hasDefaultStmt);
        condNode.setIsAssured(hasDefaultStmt);
        return condNode;
    }

    private String getConditionalNodeName(IASTSwitchStatement stmt) {
        String name = stmt.getRawSignature();
        int stmtOffset = stmt.getFileLocation().getNodeOffset();
        int bodyOffset = stmt.getBody().getFileLocation().getNodeOffset();
        return name.substring(0, bodyOffset - stmtOffset).trim();
    }

    private OpaqueAction buildTestActionForCaseGroup(List<IASTNode> group, ActivityContext currentContext) {
        IASTCaseStatement stmt = null;
        IASTNode node = group.get(0);
        if (node instanceof IASTCaseStatement) {
            stmt = (IASTCaseStatement)node;
        } else if (node instanceof IASTDefaultStatement) {
            stmt = (IASTDefaultStatement)node;
        }
        ActivityNodesPins nodes = this.activityBuilder.buildNodes((IASTStatement)stmt, currentContext);
        return (OpaqueAction)nodes.getStartNode();
    }

    private ExecutableNode buildBodyActionForCaseGroup(List<IASTNode> group, ActivityContext currentContext) {
        if (group.size() == 1) {
            return null;
        }
        ExecutableNode bodyAction = null;
        ActivityNode firstNode = null;
        ActivityNode previousNode = null;
        int i = 1;
        while (i < group.size()) {
            IASTNode astNode = group.get(i);
            ActivityNodesPins nodes = this.activityBuilder.buildNodes((IASTStatement)astNode, currentContext);
            if (i == 1) {
                firstNode = nodes.getStartNode();
            }
            if (previousNode != null) {
                this.factory.createControlFlow(previousNode, nodes.getStartNode(), currentContext);
            }
            previousNode = nodes.getEndNode();
            ++i;
        }
        bodyAction = this.factory.ensureStartNodeIsExecutable(firstNode, currentContext);
        return bodyAction;
    }

    private String getTestName(IASTSwitchStatement stmt) {
        String testName = "";
        if (stmt.getControllerExpression() != null) {
            testName = stmt.getControllerExpression().getRawSignature();
        }
        return testName;
    }
}

