/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.util;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityFinalNode;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Clause;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.FinalNode;
import org.eclipse.uml2.uml.FlowFinalNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.umlgen.reverse.c.activity.beans.ActivityContext;

public class UMLActivityFactory {
    private static final String EMPTY_STRING = "";
    private static final String FLOW_FINAL_END_OF_SWITCH = "end of switch";
    private static final String FLOW_FINAL_BREAK = "break";
    private static final String FLOW_FINAL_CONTINUE = "continue";
    private static final String FLOW_FINAL_END_OF_LOOP = "end of loop";
    private UMLFactory umlFactory = UMLFactory.eINSTANCE;
    private UMLPackage umlPackage = UMLPackage.eINSTANCE;

    public Activity createActivity(String activityName) {
        Activity activity = this.umlFactory.createActivity();
        activity.setName(this.sanitizeString(activityName));
        return activity;
    }

    public InitialNode createInitialNode(ActivityContext currentContext) {
        InitialNode initialNode = this.umlFactory.createInitialNode();
        currentContext.addNode((ActivityNode)initialNode);
        return initialNode;
    }

    public ActivityFinalNode createActivityFinalNode(ActivityContext currentContext) {
        ActivityFinalNode finalNode = this.umlFactory.createActivityFinalNode();
        currentContext.addNode((ActivityNode)finalNode);
        return finalNode;
    }

    public OutputPin createOutputPin() {
        OutputPin outputPin = this.umlFactory.createOutputPin();
        outputPin.createUpperBound(null, null, this.umlPackage.getLiteralNull());
        return outputPin;
    }

    public ConditionalNode createConditionalNode(String nodeName, ActivityContext currentContext) {
        ConditionalNode condNode = this.umlFactory.createConditionalNode();
        currentContext.addNode((ActivityNode)condNode);
        condNode.setName(this.sanitizeString(nodeName));
        return condNode;
    }

    public DecisionNode createDecisionNode(String nodeName, ActivityContext currentContext) {
        DecisionNode decisionNode = this.umlFactory.createDecisionNode();
        decisionNode.setName(this.sanitizeString(nodeName));
        currentContext.addNode((ActivityNode)decisionNode);
        return decisionNode;
    }

    public MergeNode createMergeNode(ActivityContext currentContext) {
        MergeNode mergeNode = this.umlFactory.createMergeNode();
        currentContext.addNode((ActivityNode)mergeNode);
        return mergeNode;
    }

    public OpaqueAction createOpaqueAction(String body, ActivityContext currentContext) {
        OpaqueAction opaqueAction = this.umlFactory.createOpaqueAction();
        currentContext.addNode((ActivityNode)opaqueAction);
        opaqueAction.getLanguages().add((Object)"C");
        opaqueAction.getBodies().add((Object)this.sanitizeString(body));
        return opaqueAction;
    }

    public Clause createClause(ConditionalNode condNode, OpaqueAction testAction) {
        Clause clause = this.umlFactory.createClause();
        condNode.getClauses().add((Object)clause);
        clause.getTests().add((Object)testAction);
        clause.setDecider((OutputPin)testAction.getOutputValues().get(0));
        return clause;
    }

    public String sanitizeString(String value) {
        String sanitizeValue = value;
        if (sanitizeValue != null && !sanitizeValue.equals(EMPTY_STRING)) {
            sanitizeValue = this.convertLineDelimitors(sanitizeValue);
        }
        return sanitizeValue;
    }

    private String convertLineDelimitors(String code) {
        return code.replaceAll("\r\n", "\n");
    }

    private OpaqueExpression createOpaqueExpression() {
        OpaqueExpression opaqueExpression = this.umlFactory.createOpaqueExpression();
        opaqueExpression.getLanguages().add((Object)"C");
        return opaqueExpression;
    }

    public LoopNode createLoopNode(String nodeName, boolean isTestedFirst, ActivityContext currentContext) {
        LoopNode loopNode = this.umlFactory.createLoopNode();
        loopNode.setName(this.sanitizeString(nodeName));
        loopNode.setIsTestedFirst(isTestedFirst);
        currentContext.addNode((ActivityNode)loopNode);
        return loopNode;
    }

    private ControlFlow createControlFlow(ValueSpecification guard, ActivityContext currentContext) {
        ControlFlow controlFlow = this.umlFactory.createControlFlow();
        LiteralInteger weight = this.umlFactory.createLiteralInteger();
        weight.setValue(1);
        controlFlow.setWeight((ValueSpecification)weight);
        controlFlow.setGuard(guard);
        currentContext.addEdge((ActivityEdge)controlFlow);
        return controlFlow;
    }

    public ControlFlow createControlFlow(ActivityContext currentContext) {
        return this.createControlFlow((ValueSpecification)this.trueLiteralBoolean(), currentContext);
    }

    public ControlFlow createControlFlow(ActivityNode fromNode, ActivityNode toNode, ActivityContext currentContext) {
        return this.createControlFlow(fromNode, toNode, (ValueSpecification)this.trueLiteralBoolean(), currentContext);
    }

    public ControlFlow createControlFlow(ActivityNode fromNode, ActivityNode toNode, String guard, ActivityContext currentContext) {
        OpaqueExpression guardExpression = this.createOpaqueExpression();
        guardExpression.getBodies().add((Object)this.sanitizeString(guard));
        return this.createControlFlow(fromNode, toNode, (ValueSpecification)guardExpression, currentContext);
    }

    private ControlFlow createControlFlow(ActivityNode fromNode, ActivityNode toNode, ValueSpecification guard, ActivityContext currentContext) {
        ControlFlow controlFlow = null;
        if (fromNode != null && toNode != null && !(fromNode instanceof FinalNode)) {
            controlFlow = this.createControlFlow(guard, currentContext);
            controlFlow.setSource(fromNode);
            controlFlow.setTarget(toNode);
        }
        return controlFlow;
    }

    public FlowFinalNode getFlowFinalNodeForBreak(ActivityContext currentContext) {
        return this.getFlowFinalNode(FLOW_FINAL_BREAK, currentContext);
    }

    public FlowFinalNode getFlowFinalNodeForContinue(ActivityContext currentContext) {
        return this.getFlowFinalNode(FLOW_FINAL_CONTINUE, currentContext);
    }

    public FlowFinalNode getFlowFinalNodeForEndOfLoop(ActivityContext currentContext) {
        return this.getFlowFinalNode(FLOW_FINAL_END_OF_LOOP, currentContext);
    }

    public FlowFinalNode getFlowFinalNodeForEndOfSwitch(ActivityContext currentContext) {
        return this.getFlowFinalNode(FLOW_FINAL_END_OF_SWITCH, currentContext);
    }

    private FlowFinalNode getFlowFinalNode(String name, ActivityContext currentContext) {
        return this.createFlowFinal(name, currentContext);
    }

    public ExecutableNode ensureStartNodeIsExecutable(ActivityNode firstNode, ActivityContext currentContext) {
        ExecutableNode realFirstNode = null;
        if (firstNode instanceof ExecutableNode) {
            realFirstNode = (ExecutableNode)firstNode;
        } else {
            realFirstNode = this.createOpaqueAction(EMPTY_STRING, currentContext);
            this.createControlFlow((ActivityNode)realFirstNode, firstNode, currentContext);
        }
        return realFirstNode;
    }

    public void addFlowTowardsActivityFinalNode(ActivityNode fromNode, ActivityNode finalNode, ActivityContext currentContext) {
        if (fromNode instanceof ActivityFinalNode) {
            return;
        }
        this.createControlFlow(fromNode, finalNode, currentContext);
    }

    private FlowFinalNode createFlowFinal(String name, ActivityContext currentContext) {
        FlowFinalNode flowFinalNode = this.umlFactory.createFlowFinalNode();
        flowFinalNode.setName(this.sanitizeString(name));
        currentContext.addNode((ActivityNode)flowFinalNode);
        return flowFinalNode;
    }

    private LiteralBoolean trueLiteralBoolean() {
        LiteralBoolean ret = this.umlFactory.createLiteralBoolean();
        ret.setValue(true);
        return ret;
    }

    public EAnnotation createEAnnotation(String source) {
        EAnnotation ann = EcoreFactory.eINSTANCE.createEAnnotation();
        ann.setSource(source);
        return ann;
    }
}

