/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.activity.util;

import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLActivitySanitizer {
    public void sanitize(Activity activity) {
        this.mergeOpaqueActions(activity);
        this.setOpaqueActionsNames(activity);
    }

    private void setOpaqueActionsNames(Activity activity) {
        TreeIterator contentIterator = activity.eAllContents();
        while (contentIterator.hasNext()) {
            EObject content = (EObject)contentIterator.next();
            if (!(content instanceof OpaqueAction)) continue;
            this.setOpaqueActionName((OpaqueAction)content);
        }
    }

    private void setOpaqueActionName(OpaqueAction opaqueAction) {
        String body;
        if (opaqueAction.getName() == null && (body = ((String)opaqueAction.getBodies().get(opaqueAction.getLanguages().indexOf((Object)"C"))).trim()).length() > 0) {
            int length = Math.min(12, body.length());
            String name = String.valueOf(body.substring(0, length)) + (body.length() > 12 ? "..." : "");
            opaqueAction.setName(name);
        }
    }

    private void mergeOpaqueActions(Activity activity) {
        ControlFlow cf = null;
        while ((cf = this.getNextControlFlowToMerge(activity)) != null) {
            OpaqueAction sourceOA = (OpaqueAction)cf.getSource();
            OpaqueAction targetOA = (OpaqueAction)cf.getTarget();
            String followingBody = (String)targetOA.getBodies().get(0);
            if (followingBody != null && !"".equals(followingBody)) {
                String precedingBody = (String)sourceOA.getBodies().get(0);
                StringBuilder sb = new StringBuilder(precedingBody);
                sb.append("\n").append(followingBody);
                sourceOA.getBodies().set(0, (Object)sb.toString());
            }
            sourceOA.getOutgoings().addAll((Collection)targetOA.getOutgoings());
            targetOA.getOutgoings().clear();
            targetOA.destroy();
            cf.destroy();
        }
    }

    private ControlFlow getNextControlFlowToMerge(Activity activity) {
        ControlFlow cf = null;
        TreeIterator contentIterator = activity.eAllContents();
        while (contentIterator.hasNext()) {
            EObject content = (EObject)contentIterator.next();
            if (!(content instanceof ControlFlow)) continue;
            cf = (ControlFlow)content;
            if (cf.getGuard() instanceof LiteralBoolean && cf.getGuard().booleanValue() && cf.getSource() instanceof OpaqueAction && cf.getTarget() instanceof OpaqueAction && cf.getSource().getOutgoings().size() == 1 && cf.getTarget().getIncomings().size() == 1 && !this.isActionAttachedToClause(cf.getTarget(), activity)) {
                return cf;
            }
            cf = null;
        }
        return cf;
    }

    private boolean isActionAttachedToClause(ActivityNode action, Activity activity) {
        Collection<EStructuralFeature.Setting> references = new EcoreUtil.UsageCrossReferencer((EObject)activity){

            protected boolean crossReference(EObject eObject, EReference eReference, EObject referencedObj) {
                return super.crossReference(eObject, eReference, referencedObj) && eReference == UMLPackage.Literals.CLAUSE__BODY;
            }

            protected boolean containment(EObject eObject) {
                return !(eObject instanceof OpaqueAction);
            }

            public Collection<EStructuralFeature.Setting> findUsage(EObject eObject) {
                return super.findUsage(eObject);
            }
        }.findUsage((EObject)action);
        return references.size() > 0;
    }
}

