/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.umlgen.reverse.c.internal.reconciler;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private Utils() {
    }

    public static <T> Collection<T> inLeftOnly(T[] left, T[] right) {
        return Utils.inLeftOnly(Lists.newArrayList((Object[])left), Lists.newArrayList((Object[])right), Functions.identity());
    }

    public static <T, X> Collection<T> inLeftOnly(T[] left, T[] right, Function<? super T, X> function) {
        return Utils.inLeftOnly(Lists.newArrayList((Object[])left), Lists.newArrayList((Object[])right), function);
    }

    public static <T> Collection<T> inLeftOnly(Collection<T> left, Collection<T> right) {
        return Utils.inLeftOnly(left, right, Functions.identity());
    }

    public static <X, T> Collection<T> inLeftOnly(Collection<T> left, Collection<T> right, Function<? super T, X> function) {
        ImmutableSet leftSet = ImmutableSet.copyOf((Iterable)Iterables.transform(left, function));
        ImmutableSet rigthSet = ImmutableSet.copyOf((Iterable)Iterables.transform(right, function));
        Sets.SetView intersection = Sets.intersection((Set)leftSet, (Set)rigthSet);
        Sets.SetView inLeftOnlyAfterFunction = Sets.difference((Set)leftSet, (Set)intersection);
        return Collections2.filter(left, (Predicate)new Predicate<T>((Set)inLeftOnlyAfterFunction, function){
            private final /* synthetic */ Set val$inLeftOnlyAfterFunction;
            private final /* synthetic */ Function val$function;
            {
                this.val$inLeftOnlyAfterFunction = set;
                this.val$function = function;
            }

            public boolean apply(T input) {
                return this.val$inLeftOnlyAfterFunction.contains(this.val$function.apply(input));
            }
        });
    }
}

